<?php

use App\Models\VendorSubmission;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OptDashboard;
use App\Http\Controllers\JobController;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\AdminDashboard;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\NoteController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AgingController;
use App\Http\Controllers\BatchController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\OptLeadDashboard;
use App\Http\Controllers\UsefulController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\CollegeController;
use App\Http\Controllers\MeetingController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\LiveDataController;
use App\Http\Controllers\AccountantDashboard;
use App\Http\Controllers\AgreementController;
use App\Http\Controllers\BenchsalesDashboard;
use App\Http\Controllers\HierarchyController;
use App\Http\Controllers\TimesheetController;
use App\Http\Controllers\ConsultantController;
use App\Http\Controllers\GuestHouseController;
use App\Http\Controllers\SubmissionController;
use App\Http\Controllers\CardListingController;
use App\Http\Controllers\ImplementorController;
use App\Http\Controllers\MailCampainController;
use App\Http\Controllers\CampaignListController;
use App\Http\Controllers\BenchsalesLeadDashboard;
use App\Http\Controllers\ConsultantJobController;
use App\Http\Controllers\JobConsultantController;
use App\Http\Controllers\VendorCompanyController;
use App\Http\Controllers\CampaignReportController;
use App\Http\Controllers\ConsultantCallController;
use App\Http\Controllers\CampaignContactController;
use App\Http\Controllers\AssignConsultantController;
use App\Http\Controllers\BenchsalesManagerDashboard;
use App\Http\Controllers\CampaignTemplateController;
use App\Http\Controllers\VendorSubmissionController;
use App\Http\Controllers\IncentiveStructureController;
use App\Http\Controllers\CampaignUnsubscriberController;
use App\Http\Controllers\Payrates\ConsultantPayrateController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::middleware(['auth'])->group(function() {
    // User Routes
	Route::post('user_change_status', [UserController::class, 'changeStatus']);
    Route::get('/profile', [UserController::class, 'profile']);
	Route::resource('users', UserController::class);
	Route::get('/get_company_users', [UserController::class, 'getCompanyUsers']);
	Route::post('/getUsers', [UserController::class, 'getUsers']);

    Route::get('/home', [HomeController::class, 'index'])->name('home');

    // Admin Routes
    Route::get('/admin', [AdminDashboard::class, 'dashboard'])->name('admin.dashboard');
    // OPT Routes
    Route::get('/opt', [OptDashboard::class, 'dashboard'])->name('opt.dashboard');
    Route::get('/opt_lead', [OptLeadDashboard::class, 'dashboard'])->name('opt.lead-dashboard');
    Route::get('/opt_manager', [OptManagerDashboard::class, 'dashboard'])->name('opt.manager-dashboard');
    // Benchasales Routes
    Route::get('/benchsales', [BenchsalesDashboard::class, 'dashboard'])->name('benchsales.dashboard');
    Route::get('/benchsales_lead', [BenchsalesLeadDashboard::class, 'dashboard'])->name('benchsales.lead-dashboard');
    Route::get('/benchsales_manager', [BenchsalesManagerDashboard::class, 'dashboard'])->name('benchsales.manager-dashboard');

    // Company Change
    Route::get('/changeCompany/{id?}', [UsefulController::class, 'changeCompany'])->name('change.company');

    // Favourite Menu
    Route::get('favourite_menu', [UsefulController::class, 'favouriteMenu'])->name('favourite.menu');

    // Main search of app
    Route::post('/main_search', [UsefulController::class, 'mainSearch']);

    // Users Login Details
    Route::get('user_logins', [UsefulController::class, 'userLogins']);

    // Meetings
    Route::resource('meetings', MeetingController::class);
    
    // Consultant Routes
    Route::resource('consultants', ConsultantController::class);

    /* Adding Exatra Forms to consultant form */
    Route::get('add_education', [UsefulController::class, 'addEducation']);
    Route::get('add_certification', [UsefulController::class, 'addCertification']);
    Route::get('add_experience', [UsefulController::class, 'addExperience']);
    Route::get('add_reference', [UsefulController::class, 'addReference']);
    Route::get('add_attachment', [UsefulController::class, 'addAttachment']);
    Route::get('add_contact', [UsefulController::class, 'addContact']);

    // Store consultant comments
    Route::get('save_comments', [UsefulController::class, 'saveComments']);

    /* Country & State & City Change */
    Route::get('get_states', [UsefulController::class, 'getStates']);
    Route::get('get_cities', [UsefulController::class, 'getCities']);

    // Import Consultants
    Route::get('/import_consultants', [ImportController::class, 'importConsultants']);
    Route::post('/save_import_consultants', [ImportController::class, 'saveImportConsultants']);
    Route::get('/save_sample_csv', [ImportController::class, 'downloadSampleFile']);
    Route::get('/save_imported_file/{id?}', [ImportController::class, 'saveImportedFile']);

    // Aging Consultants
    Route::get('/consultants_aging', [AgingController::class, 'aging']);

    // Consultant Call
    Route::resource('calls', ConsultantCallController::class);
    Route::post('consultant_call_copy', [ConsultantCallController::class, 'copyCall'])->name('consultant_call.copy');
    // Get Consultant Details
    Route::get('consultant_details/{id?}', [UsefulController::class, 'consultantDetails'])->name('consultant.details');

    // Viewing list in dashboard dashboard
    Route::get('/get_card_data', [CardListingController::class, 'getCardData']);
    Route::post('consultant_list', [CardListingController::class, 'consultantList']);
    Route::get('/visa_consultant_list/{type1?}/{type2?}', [CardListingController::class, 'visaConsultantList']);

    // Update Call lead in dashboard
    Route::post('/update_call', [UsefulController::class, 'updateCallStatus']);
    Route::get('/dashboard_call_leads', [UsefulController::class, 'dashboardCallleads']);
    Route::get('/dashboard_consultants_lists', [UsefulController::class, 'dashboardConsultantsList']);
    Route::get('/get_timezone_dates', [UsefulController::class, 'getTimezoneDates']);

    // Consultant Assigning in dashboard
    Route::get('/assign_consultants', [AssignConsultantController::class, 'assignConsultants']);
    Route::get('/get_consultants', [AssignConsultantController::class, 'getConsultants']);
    Route::post('/save_assign_consultants', [AssignConsultantController::class, 'saveAssignConsultants']);

    // Get visa status consultant count
    Route::get('visa_consultant_count', [UsefulController::class, 'visaConsultantCount']);

    // Yearwise consultant graph
    Route::get('consultants_graph', [UsefulController::class, 'consultantsGraph']);

    // Vector map
    Route::post('vector_map', [UsefulController::class, 'vectorMap']);
    Route::get('consultants_by_state/{id?}', [UsefulController::class, 'consultantsByState']);
    Route::get('clientslist_by_map/{id?}', [UsefulController::class, 'clientsByState']);

    // Ad Hock Meetings 
    Route::resource('meetings', MeetingController::class);
	Route::get('meeting_analytics', [MeetingController::class, 'analytics'])->name('meetings.analytics');
	Route::post('participants', [MeetingController::class, 'participants'])->name('participants');
	Route::get('meeting_copy/{id}', [MeetingController::class, 'copy'])->name('meetings.copy');

    // Agreement Routes
    Route::resource('agreements', AgreementController::class);
    Route::get('/download/{id?}', [UsefulController::class, 'downloadFile']);
    Route::get('/send_agreement', [AgreementController::class, 'sendAgreement']);
    Route::post('/send_agreement', [AgreementController::class, 'saveSendAgreement']);
    // Agreement logins
    Route::get('agreement_login/{cond_id}/{agree_id}/{login_id}', [AgreementController::class, 'login']);
    Route::post('login_check', [AgreementController::class, 'loginCheck']);
    Route::post('save_agreement_return', [AgreementController::class, 'agreementReturn']);
    Route::get('agreement_success_view', [AgreementController::class, 'successView']);
    Route::get('agreement_returns', [AgreementController::class, 'agreementReturns']);

    // Resume Search
    Route::get('resume_search', [UsefulController::class, 'resumeSearch']);
    Route::post('resume_search', [UsefulController::class, 'searchResume']);
    Route::get('download_resume/{id?}', [UsefulController::class, 'downloadResume']);

    // Chat Routes
    Route::get('chatdashboard', [ChatController::class, 'chat']);
	Route::post('chat_send',[ChatController::class, 'send']);
	Route::get('chat_olddata',[ChatController::class, 'olddata']);
	Route::get('/messages/{userId}', [ChatController::class, 'messages']);
	Route::post('/messages/{userId}', [ChatController::class, 'messagespost']);
	Route::post('/fileUpload/{userId}',[ChatController::class, 'fileupload']);
	Route::get('/online_users_list',[ChatController::class, 'online_users_list']);
    Route::get('/chat_history/{id}',[ChatController::class, 'chatHistory']);
    Route::resource('/chat', ChatController::class);
    Route::get('chat_activeusers', [ChatController::class, 'activeusers']);

    // Batch
    Route::resource('batch', BatchController::class);
    // College
    Route::resource('college', CollegeController::class);
    // Guest House
    Route::get('/allocated_guesthouses', [GuestHouseController::class, 'allocated']);
    Route::get('/non_allocated_guesthouses', [GuestHouseController::class, 'nonAllocated']);
    Route::resource('guesthouse', GuestHouseController::class);
    // Vendor Company
    Route::resource('vendor_companies', VendorCompanyController::class);
    // Vendors
    Route::resource('vendors', VendorController::class);
    // Implementors
    Route::resource('implementors', ImplementorController::class);
    // Clients
    Route::resource('clients', ClientController::class);
    // Job Company
    Route::resource('jobs', JobController::class);
    Route::post('/save_scheduled', [JobController::class, 'saveScheduled']);
    Route::post('/save_attended', [JobController::class, 'saveAttended']);
    Route::post('/save_selected', [JobController::class, 'saveSelected']);
    Route::post('/save_joined', [JobController::class, 'saveJoined']);

    // Vendor submissions
    Route::resource('vendor_submissions', VendorSubmissionController::class);
    Route::get('/technology_consultants', [UsefulController::class, 'technologyConsultants']);
    Route::get('/vendor_company_vendors', [UsefulController::class, 'vendorCompanyVendors']);
    Route::get('/vendor_details', [UsefulController::class, 'vendorDetails']);
    Route::get('/add_vendor', [UsefulController::class, 'addVendor']);
    Route::get('/change_submisssion_status', [VendorSubmissionController::class, 'changeSubmissionStatus']);
    Route::post('/save_client_interview', [VendorSubmissionController::class, 'saveClientInterview']);
    Route::get('/submission_join_form', [VendorSubmissionController::class, 'joinForm']);
    Route::post('/save_submission_Join', [VendorSubmissionController::class, 'saveSubmissionJoin']);
    Route::get('/submission_joined_list', [VendorSubmissionController::class, 'submissionJoinedList']);
    // Apply consultants to job
    Route::get('/vs_jobs', [ConsultantJobController::class, 'jobsList']);
    Route::get('/job_consultants/{id?}', [ConsultantJobController::class, 'jobConsultants']);
    Route::post('/save_job_consultants', [ConsultantJobController::class, 'saveJobConsultants']);    
    Route::get('/vs_consultants', [ConsultantJobController::class, 'vsConsultants']);
    Route::get('/consultant_jobs/{id?}', [ConsultantJobController::class, 'consultantJobs']);
    Route::post('/save_consultant_job', [ConsultantJobController::class, 'saveConsultantsJobs']);

    // First SMS
    Route::resource('/sms', SmsController::class);

    // My Mail Campaigns
    Route::resource('/my_mails', MailCampainController::class);
    // Campaign Lists
    Route::get('/campaign_lists_export/{id?}/{type?}', [CampaignListController::class, 'export']);
    Route::get('/campaign_lists_import/{id?}', [CampaignListController::class, 'import']);
    Route::resource('/campaign_lists', CampaignListController::class);
    // Campaign Templates
    Route::resource('/campaign_templates', CampaignTemplateController::class);
    Route::resource('/campaigns', CampaignController::class);
    Route::resource('/campaign_contacts', CampaignContactController::class);
    // Single Campaign
    Route::get('/campaign_single', [CampaignController::class, 'single']);
    Route::post('/campaign_single_save', [CampaignController::class, 'singleSave']);
    // Unsubscribers
    Route::resource('/campaign_unsubscribers', CampaignUnsubscriberController::class);
    Route::post('/campaign_unsubscribes_import', [CampaignUnsubscriberController::class, 'import']);
    Route::post('/campaign_unsubscribes_action', [CampaignUnsubscriberController::class, 'action']);
    // Report
    Route::post('/campaign_email_reports', [CampaignReportController::class, 'reports']);

    // My Consultant Submissions
    Route::get('/my_consultant_submissions', [SubmissionController::class, 'myConsultantSubmissions']);

    // Organization chart
    Route::resource('/hierarchy', HierarchyController::class);

    // Incentives
    Route::resource('/incentive_structures', IncentiveStructureController::class);
    Route::get('/assign_structure', [IncentiveStructureController::class, 'assignStructure']);
    Route::get('/get_structure_details/{id?}', [IncentiveStructureController::class, 'getStructureDetails']);
    Route::post('/save_structure_assign', [IncentiveStructureController::class, 'saveStructureAssign']);
    Route::get('/create_incentive', [IncentiveStructureController::class, 'createIncentive']);
    Route::post('/get_user_consultants', [IncentiveStructureController::class, 'getUserConsultants']);
    Route::post('/save_incentive_request', [IncentiveStructureController::class, 'saveIncentiveRequest']);
    Route::get('/incentive_requests', [IncentiveStructureController::class, 'incentiveRequests']);
    Route::post('/change_incentive_status', [IncentiveStructureController::class, 'changeIncentiveStatus']);
    Route::get('/incentives_yearly', [IncentiveStructureController::class, 'incentivesYearly']);
    Route::post('/yearly_incentives_details', [IncentiveStructureController::class, 'yearlyIncentivesDetails']);
    Route::get('/incentive_details', [IncentiveStructureController::class, 'incentiveDetails']);

    /**
	 * Consultant vendor payrates
	 */
	Route::group(['middleware'=>'auth'], function() {
		Route::get('consultant_payrates_list', [ConsultantPayrateController::class, 'payrateList']);
		Route::resource('/consultnatpayrates', ConsultantPayrateController::class);
        Route::get('getVendors', [ConsultantPayrateController::class, 'getVendorCompanies']);
	});

    //*TimeSheet By Danda Satish* //
	Route::get('timesheet',[TimesheetController::class, 'index']);
	Route::get('student_worked_hours',[TimesheetController::class, 'student_worked_hours']);
	Route::get('getClientdata/{id}',[TimesheetController::class, 'getClientdata']);
	Route::post('student_worked_hours',[TimesheetController::class, 'student_worked_hours']);
	Route::post('mis_store',[TimesheetController::class, 'store']);
	Route::get('employee_view_hours/{id}',[TimesheetController::class, 'show']);
	Route::post('weeks_wise_working_hours',[TimesheetController::class, 'weeks_wise_working_hours']);
	Route::get('timeheet_weekly_data',[TimesheetController::class, 'timeheet_weekly_data']);
	Route::get('downloadClientSheet/{id}',[TimesheetController::class, 'downloadClientSheet']);
	Route::get('approvalsTimesheet',[TimesheetController::class, 'approvalsTimesheet']);
	Route::get('approve_status_id/{id}',[TimesheetController::class, 'approve_status_id']);
	Route::get('approve_status_all/{id}',[TimesheetController::class, 'approve_status_all']);
	Route::get('all_employees_weekly_data',[TimesheetController::class, 'all_employees_weekly_data']);
	Route::get('getDataWeekAjaxinMonth',[TimesheetController::class, 'getDataWeekAjaxinMonth']);
	Route::get('getDataMonthAjaxinMonth',[TimesheetController::class, 'getDataMonthAjaxinMonth']);

    // Todo/Task 
    Route::resource('notes', NoteController::class);

    // Live Data 
    // OPT
    Route::get('/optlivecardsdata', [LiveDataController::class, 'optlivecardsdata']);
    Route::get('/optpolardata', [LiveDataController::class, 'optpolardata']);
    Route::get('/optbardata', [LiveDataController::class, 'optbardata']);
    Route::get('/optlinedata', [LiveDataController::class, 'optlinedata']);
    // Benchsales
    Route::get('/benchlivecardsdata', [LiveDataController::class, 'benchlivecardsdata']);
    Route::get('/benchpolardata', [LiveDataController::class, 'benchpolardata']);
    Route::get('/benchbardata', [LiveDataController::class, 'benchbardata']);
    Route::get('/benchlinedata', [LiveDataController::class, 'benchlinedata']);
    // Accounts
    Route::get('/accountslivecardsdata', [LiveDataController::class, 'accountslivecardsdata']);
    Route::get('/accountsbardata', [LiveDataController::class, 'accountsbardata']);
    Route::get('/accountspolardata', [LiveDataController::class, 'accountspolardata']);

});

