<?php

use App\Http\Controllers\Accounts\Common\Import;
use App\Http\Controllers\Accounts\Expenses\Bills;
use App\Http\Controllers\Accounts\Settings\Taxes;
use App\Http\Controllers\Accounts\Dashboard\Totals;
use App\Http\Controllers\Accounts\Expenses\Payments;
use App\Http\Controllers\Accounts\Incomes\Customers;
use App\Http\Controllers\Accounts\Settings\Settings;
use App\Http\Controllers\Accounts\AccountsController;
use App\Http\Controllers\Accounts\Banking\Reconciles;
use App\Http\Controllers\Accounts\Runpayrole\Payrole;
use App\Http\Controllers\Accounts\Dashboard\Dashboard;
use App\Http\Controllers\Accounts\Incomes\CreditMemos;
use App\Http\Controllers\Accounts\Settings\Categories;
use App\Http\Controllers\Accounts\Settings\Currencies;
use App\Http\Controllers\Accounts\Items\ItemController;
use App\Http\Controllers\Accounts\Common\TermController;
use App\Http\Controllers\Accounts\Reports\StandardReports;
use App\Http\Controllers\Accounts\Accounts\Expenses\Vendors;
use App\Http\Controllers\Accounts\Banking\DepositController;
use App\Http\Controllers\Accounts\Banking\JournalController;
use App\Http\Controllers\Accounts\Expenses\ChequeController;
use App\Http\Controllers\Accounts\Incomes\InvoiceController;
use App\Http\Controllers\Accounts\Banking\TransferController;
use App\Http\Controllers\Accounts\Incomes\CustomerController;
use App\Http\Controllers\Accounts\Accounts\Expenses\DebitMemos;
use App\Http\Controllers\Accounts\Accounting\AccountingController;

Route::group(['middleware' => ['AccountsMiddleware', 'auth']], function () {
    Route::get('/accountsdashboard', [Dashboard::class, 'index'])->name('accounts.dashboard');

    Route::group(['middleware' => 'accountmenu'], function () {
        Route::post('/invoice_totals', [Totals::class, 'incomeTotals'])->name('income.counts');
        Route::post('/expenses_totals', [Totals::class, 'expenseTotals'])->name('expenses.counts');
        Route::post('/profit_totals', [Totals::class, 'profitTotals'])->name('profit.counts');
        Route::post('/accounts_list', [Totals::class, 'accountsList'])->name('accounts.list');
        Route::post('/latest_expenses', [Totals::class, 'latestExpenses'])->name('latest.expenses.list');
        Route::post('/latest_incomes', [Totals::class, 'latestIncomes'])->name('latest.incomes.list');
        Route::get('dashboard/dashboard/cashflow', [Dashboard::class, 'cashFlow']);
    });

    Route::group(['prefix' => 'banking'], function () {
        Route::resource('accounts', AccountsController::class);
        Route::post('banking/accounts/changeSts', [AccountsController::class, 'changeStatus'])->name('account.status');
        Route::resource('transfers', TransferController::class);
        Route::get('tranfers/chart_id/{id}', [TransferController::class, 'chartId'])->name('banking.transfers.chart');
        Route::get('accounts/accountbalance/{id}', [AccountsController::class, 'accountBalance']);
        Route::resource('deposit', DepositController::class);
        Route::resource('journal', JournalController::class);
        Route::post('deposit/totaldeposite',[DepositController::class, 'totaldeposite']);
        Route::resource('reconcile', Reconciles::class);
    }); 

    Route::group(['prefix' => 'expenses'], function () {
        // Listing Invoices from dashboard
        Route::match(['get', 'post'], '/bills/dashboardlist', [Bills::class, 'dashboardList'])->name('dashboard.expenses.card');

        Route::get('bills/{bill}/received', [Bills::class, 'markReceived']);
        Route::get('bills/{bill}/print', [Bills::class, 'printBill']);
        Route::get('bills/{bill}/pdf', [Bills::class, 'pdfBill']);
        Route::get('bills/makepayment/{bill}',[Bills::class, 'paymentpage']);
        Route::post('bills/payment', [Bills::class, 'payment']);
        Route::delete('bills/payment/{payment}', [Bills::class, 'paymentDestroy']);
        Route::post('bills/import', [Bills::class, 'import']);
        Route::resource('bills', Bills::class);
        Route::get('bills/vendor_expense/{id}', [Bills::class, 'create']);
        Route::post('payments/import', 'Accounts\Expenses\Payments@import');
        Route::resource('payments', Payments::class);
        Route::get('vendors/autocompletevendor', [Vendors::class, 'autocompletevendor']);
        
        Route::post('vendors/vendor', [Vendors::class, 'vendor']);
        Route::post('vendors/import', [Vendors::class, 'import']);
        Route::get('vendors/billcenter', [Vendors::class, 'billcenter']);
        Route::resource('vendors', Vendors::class);
        Route::resource('cheques', ChequeController::class);
        Route::get('vendor_cheque/{id}', [ChequeController::class, 'create']);//Creating Cheque For Vendor
        Route::get('cheques/{cheque}/received', [ChequeController::class, 'markReceived']);
        Route::get('cheques/{cheque}/print', [ChequeController::class, 'printCheque']);
        Route::get('cheques/{cheque}/pdf', [ChequeController::class, 'pdfCheque']);
        Route::post('cheques/payment', [ChequeController::class, 'payment']);
        Route::delete('cheques/payment/{payment}', [ChequeController::class, 'paymentDestroy']);
        
        Route::get('debitmemo/getbills/{vendor_id}', [DebitMemos::class, 'getbills']);
        Route::resource('debitmemo', DebitMemos::class);
    });

    Route::group(['prefix' => 'incomes'], function () { 
        // Listing Invoices from dashboard
        Route::match(['get', 'post'], '/invoices/dashboardlist', 'Accounts\Incomes\Invoices@dashboardList')->name('dashboard.invoices.card');
        Route::resource('invoices', InvoiceController::class);
        Route::get('customers/autocompletecustomer', [CustomerController::class, 'autocompletecustomer']);

        Route::get('invoices/{invoice}/print', [InvoiceController::class, 'printInvoice']);
        Route::get('invoices/{invoice}/pdf', [InvoiceController::class, 'pdfInvoice']);
        Route::get('invoices/{invoice}/email', [InvoiceController::class, 'emailInvoice']);

        Route::get('invoices/create/{id}',[InvoiceController::class, 'create']);
        Route::get('customers/receivepayment/{customer}/{invoice_id}', [InvoiceController::class, 'receivepayment']);
        Route::post('invoices/customerpayment', [InvoiceController::class, 'customerpayment']);
        Route::get('parent_customer_id/{id}', [Customers::class, 'parent_customer_id']);

        Route::get('creditmemo/getinvoices/{customer_id}', [CreditMemos::class, 'getinvoices']);
        Route::resource('creditmemo', CreditMemos::class);

        Route::resource('customers', Customers::class);
    });

    Route::group(['prefix' => 'accounting'],function(){
        Route::post('chartofaccounts/import',[AccountingController::class, 'import']);
        Route::post('chartofaccounts_model_data',[AccountingController::class, 'chartofaccounts_model_data']);
        Route::resource('chartofaccounts', AccountingController::class);
        Route::get('runreport/{id}',[AccountingController::class, 'runreport']);
        Route::get('quickreportpdf/{id}',[AccountingController::class, 'quickreportpdf']);
        Route::get('quickreportpdfdownload/{id}/pdf', [AccountingController::class, 'quickreportpdfdownload']);
        Route::get('quickreportemail/{id}/email', [AccountingController::class, 'quickreportemail']);
    });

    Route::group(['prefix' => 'items'], function () {
        Route::get('items/autocomplete', [ItemController::class, 'autocomplete']);
        Route::get('items/autocompletebill', [ItemController::class, 'autocompletebill']);
        Route::post('items/totalItem', [ItemController::class, 'totalItem']);
        Route::post('items/totalDeposite', [ItemController::class, 'totalDeposite']);
        Route::post('items/totalBillamount', [ItemController::class, 'totalBillamount']);
        Route::post('items/totalChequeamount', [ItemController::class, 'totalChequeamount']);
        Route::post('items/import', [ItemController::class, 'import']);
        Route::resource('items', ItemController::class);
    });

    Route::group(['prefix' => 'netterms'],function(){
        Route::post('terms', [TermController::class, 'store']);
        Route::get('get_netterms/{id}', [TermController::class, 'show']);
    });

    Route::group(['prefix' => 'payrole'],function() {
        Route::get('timecard/{customer_id}', [Payrole::class, 'timecard']);
        Route::get('/timesheetdetails/{employee_id}', [Payrole::class, 'timesheetdetails']);

        Route::match(['get', 'post'], 'runpayrole/run_payrole', 'Accounts\Runpayrole\Runpayrole@runConsultantPayrole');
        Route::resource('payrole', Payrole::class);
        Route::get('/getpayrate/{id}', [Payrole::class, 'getpayrate']);
        Route::get('/timesheetdetails/{employee_id}', [Payrole::class, 'timesheetdetails']);
        Route::get('timesheet', [Payrole::class, 'timesheet']);
        Route::get('timesheet/create', [Payrole::class, 'timesheet_create']);
        Route::get('timesheet/{id}/edit', [Payrole::class, 'timesheet_edit']);
        Route::get('timesheet/timesheet_approve', [Payrole::class, 'timesheet_approve']);
        Route::get('timesheet/show_timesheet_weekly_data', [Payrole::class, 'show_timesheet_weekly_data']);
        Route::get('timecard/{customer_id}', [Payrole::class, 'timecard']);
        Route::get('/paystubs','Accounts\Runpayrole\Paystubs@index');
        Route::get('runpayrole/vendorpayrates','Accounts\Runpayrole\Runpayrole@vendorpayrates');
        Route::get('runpayrole/consultantanthours','Accounts\Runpayrole\Runpayrole@consultantanthours');

        Route::resource('setuppayrole','Accounts\Runpayrole\SetupPayrole');
        Route::resource('runpayrole','Accounts\Runpayrole\Runpayrole');
        Route::get('runpayrole/consultantvendors/{id}','Accounts\Runpayrole\Runpayrole@consultantvendors');
        //Route::get('payrole/runpayrole','Accounts\Runpayrole\Runpayrole@index');
        Route::get('/listpaystubs','Accounts\Runpayrole\Paystubs@listpaystubs');
    });

    Route::group(['prefix' => 'common'], function () {
        Route::get('import/{group}/{type}', [Import::class, 'create']);
    });

    Route::group(['prefix' => 'reports'], function () {
        Route::get('standard', [StandardReports::class, 'index']);
            Route::match(['get','post'],'standard/audit-log', [StandardReports::class, 'auditLog']);
            
            Route::match(['get','post'],'standard/balance-sheet-comparision', [StandardReports::class, 'balanceSheetCompariosion']);
            Route::match(['get','post'],'standard/balance-sheet-details', [StandardReports::class, 'balanceSheetDetails']);
            Route::match(['get','post'],'standard/balance-sheet', [StandardReports::class, 'balanceSheet']);
            Route::match(['get','post'],'standard/profit-loss', [StandardReports::class, 'profitLoss']);
            Route::match(['get','post'],'standard/profit-loss-details', [StandardReports::class, 'profitLossDetails']);
            Route::match(['get','post'],'standard/profit-loss-comparision', [StandardReports::class, 'profitLossComparision']);
            Route::match(['get','post'],'standard/statement-cash-flows', [StandardReports::class, 'statementCashFlows']);

            Route::match(['get','post'],'standard/accounts-recievables', [StandardReports::class, 'accountsRecievables']);
            Route::match(['get','post'],'standard/accounts-recievable-summary', [StandardReports::class, 'accountsRecievableSummary']);
            Route::match(['get','post'],'standard/collections-reports', [StandardReports::class, 'collectionsReports']);
            Route::match(['get','post'],'standard/customer-balance-summary', [StandardReports::class, 'customerBalanceSummary']);
            Route::match(['get','post'],'standard/invoice-list', [StandardReports::class, 'invoiceList']);
            Route::match(['get','post'],'standard/invoice-recieve-payments', [StandardReports::class, 'invoiceRecievePayments']);
            Route::match(['get','post'],'standard/open-invoices', [StandardReports::class, 'openInvoices']);

            Route::match(['get','post'],'standard/customer-contact-list', [StandardReports::class, 'customerContactList']);
            Route::match(['get','post'],'standard/deposit-details', [StandardReports::class, 'depositDetails']);
            Route::match(['get','post'],'standard/estimate-process-invoice', [StandardReports::class, 'estimateProcessInvoice']);
            Route::match(['get','post'],'standard/estimates-customer', [StandardReports::class, 'estimatesCustomer']);
            Route::match(['get','post'],'standard/product-service', [StandardReports::class, 'producService']);
            Route::match(['get','post'],'standard/sales-customer-summary', [StandardReports::class, 'salesCustomerSummary']);
            Route::match(['get','post'], 'standard/sales-customer-summary-detail', [StandardReports::class, 'salesCustomerSummaryDetail']);
            Route::match(['get','post'],'standard/sales-product-summary', [StandardReports::class, 'salesProductSummary']);
            Route::match(['get','post'],'standard/check-details', [StandardReports::class, 'checkDetails']);
            Route::match(['get','post'],'standard/transaction-vendor', [StandardReports::class, 'transactionVendor']);
            Route::match(['get','post'],'standard/vendor-contact-list', [StandardReports::class, 'vendorContactList']);

            Route::match(['get','post'],'standard/account-list', [StandardReports::class, 'accountList']);          
            Route::match(['get','post'],'standard/general-ledger', [StandardReports::class, 'generalLedger']);
            Route::match(['get','post'],'standard/journal', [StandardReports::class, 'journal']);
            Route::get('standard/reconciliation-reports', [StandardReports::class, 'reconciliationReports']);
            Route::match(['get','post'],'standard/transaction-date', [StandardReports::class, 'transactionDate']);
            Route::match(['get','post'],'standard/trial-balance', [StandardReports::class, 'trialBalance']);                   

        Route::match(['get', 'post'],'management/employee-expenses', 'Accounts\Reports\ManagementReports@employeeExpenses');
        Route::match(['get', 'post'],'management/employee-salary', 'Accounts\Reports\ManagementReports@employeeSalary');
        Route::match(['get', 'post'],'management/employee-worked-hours', 'Accounts\Reports\ManagementReports@employeeWorkedHours');
        Route::match(['get', 'post'],'management/employee-invoices', 'Accounts\Reports\ManagementReports@employeeInvoices');
        Route::match(['get', 'post'],'management/consultant-vendor-payments', 'Accounts\Reports\ManagementReports@consultantVendorPayments');
        Route::match(['get', 'post'],'management/vendor-payments', 'Accounts\Reports\ManagementReports@vendorPayments');
        Route::match(['get', 'post'],'management/consultant-monthly-hours', 'Accounts\Reports\ManagementReports@consultantMonthlyHours');
        Route::match(['get', 'post'],'management/payroll-summary', 'Accounts\Reports\ManagementReports@payrollSummary');
        Route::match(['get', 'post'],'management/invoioce-payment', 'Accounts\Reports\ManagementReports@invoice_payment');
        Route::resource('management', 'Accounts\Reports\ManagementReports');
    });

    Route::group(['prefix' => 'settings'], function () {
        Route::resource('categories', Categories::class);
        Route::get('currencies/currency', [Currencies::class, 'currency']);
        Route::get('currencies/config', [Currencies::class, 'config']);
        Route::resource('currencies', Currencies::class);
        Route::get('ac_settings', [Settings::class, 'edit']);
        Route::patch('ac_settings', [Settings::class, 'update']);
        Route::resource('taxes', Taxes::class);
    });
});
?>