@extends('layouts.default')
@section('title', 'Apply consultants for job')
@section('header-links')
    @include('includes.headers.vendor_submissions')
@endsection

@section('new_button')
<div class="searchBox mr-2 ml-35">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm',
    'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{!! URL::to('/vs_jobs') !!}"
    class="btn btn-info btn-Rcircle-iconic waves-effect waves-light d-flex align-items-center"><i
        class="material-icons"> list </i>Job list</a>
@endsection

@section('content')

{{ Form::open(['url'=>'save_job_consultants', 'id'=>'saveForm']) }}
<div class="row">
    <div class="col-lg-12 col-md-12">
        {{ Form::hidden('job_id', $job->id) }}
        <table class="table table-striped table-bordered table-filter">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Consultant</th>
                    <th>Email</th>
                    <th>Visa Status</th>
                    <th>Submitted By</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($applied as $li)
                <tr class="applied">
                    <td>{{ date(env('APP_DATE'), strtotime($li->created_at)) }}</td>
                    <td>{{ ucwords($li->name) }}</td>
                    <td>{{ ucwords($li->email) }}</td>
                    <td>{{ ucwords($li->visa_status) }}</td>
                    <td>{{ ucwords('Applied') }}</td>
                    <td>{{ ucwords($li->creater?->name) }}</td>
                    <td></td>
                </tr>             
                @endforeach

                @foreach ($notapplied as $li)
                <tr class="applied">
                    <td>{{ date(env('APP_DATE'), strtotime($li->created_at)) }}</td>
                    <td>{{ ucwords($li->name) }}</td>
                    <td>{{ $li->email }}</td>
                    <td>{{ ucwords($li->visa_status) }}</td>
                    <td>{{ ucwords('Not Applied') }}</td>
                    <td>{{ ucwords($li->creater?->name) }}</td>
                    <td>
                        <a title="Send Mail" onclick="get_mail('{{ $li->email }}')"
                            class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons"> mail </i></a>
                        <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                                onclick="addComment({{ $li->id }})"> <i class="material-icons"> comment </i> </button>

                        @form_checkbox('consultant_id[]', $li->id)
                    </td>
                </tr>             
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="col-md-12" style="display: inline-flex;">
        <div class="col-md-3"></div>
        <div class="col-md-4"></div>
        <div class="col-md-3">
            {{ Form::numberGroup('payrate', 'Payrate', null, ['id'=>'payrate', 'required'=>'required']) }}
        </div>
        <div class="col-md-2 text-right">
            <button class="btn btn-sm btn-primary pull-right" onclick="applyJob()">Click to Apply</button>
        </div>
    </div>
</div>
{{ Form::close() }}

@include('includes.new-comment')
@include('includes.new-mail')
@include('includes.datepicker')
@stop