@extends('layouts.default')
@section('title', 'Submission list')
@section('header-links')
    @include('includes.headers.vendor_submissions')
@endsection

@section('new_button')
<div class="searchBox mr-2 ml-35">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm',
    'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{!! URL::to('/vendor_submissions/create') !!}"
    class="btn btn-info btn-Rcircle-iconic waves-effect waves-light d-flex align-items-center"><i
        class="material-icons"> add </i> Submit to Vendor</a>
@endsection

<style>
    .modal-dialog {
        max-width: 60% !important;
    }

    .modal-lg {
        max-width: 100%;
    }
    
    .text-black {
        color: black;
    }
</style>

@section('content')

<div class="row">
    <div class="col-lg-12 col-md-12" id="ajaxData">
        <table class="table table-striped table-bordered table-filter">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Consultant</th>
                    <th>Job Title</th>
                    <th>Job Location</th>
                    <th>Client Name</th>
                    <th>Client Location</th>
                    <th>Interview Date</th>
                    <th>Pay Rate</th>
                    <th>Job Status</th>
                    <th>Submitted By</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($list as $li)
                <tr>
                    <td>{{ date(env('APP_DATE'), strtotime($li->created_at)) }}</td>
                    <td>{{ ucwords($li->consultant?->name) }}</td>
                    <td>{{ ucwords($li->job?->title) }}</td>
                    <td>{{ ucwords($li->job?->country?->name) }}</td>
                    <td>{{ ucwords($li->job?->client?->name) }}</td>
                    <td>{{ ucwords($li->job?->client?->country?->name) }}</td>
                    <td>{{ ($li->interview_date != '')?date(env('APP_DATE'), strtotime($li->interview_date)):'' }}</td>
                    <td>{{ $li->job?->min_payrate }}</td>
                    <td id="sub{{ $li->id }}">
                        @if($li->status != 'joined')
                        <a href="#" type="btn" title="Click to change Job Status" class=""
                            onClick="changeStatus('{{ $li->status }}', '{{ $li->id }}', '{{ $li->consultant_id }}')">
                            <u>{{ $vendor_statuses[$li->status] }}</u></a>
                        @else
                        Joined
                        @endif
                    </td>
                    <td>{{ ucwords($li->creater?->name) }}</td>
                    <td style="display: flex" id="action{{ $li->id }}">
                        <a title="Edit" href="/vendor_submissions/{{$li->id}}/edit"
                            class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                        <a title="Send Mail" onclick="get_mail('{{ $li->consultant?->email }}')"
                            class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons"> mail </i></a>
                        <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                                onclick="addComment({{ $li->consultant?->id }})"> <i class="material-icons"> comment </i> </button>
                    </td>
                </tr>             
                @endforeach
            </tbody>
        </table>
    </div>
</div>

{{-- Status Modal --}}
<div class="modal fade" id="statusModal">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Change Consultant Submission Status</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                {{ Form::hidden('vendor_submission_status', null, ['id'=>'vendor_submission_status']) }}
            </div>
            <div class="modal-body" style="height: 450px; overflow-y: auto;">
                <div class="col-md-12">
                    <fieldset>
                        <input type="hidden" name="consultant_id" id="consultant_id">
                        <input type="hidden" name="vendor_submission_id" id="vendor_submission_id">
                        <input type="hidden" name="consultant_status" id="consultant_status">
                        {{ csrf_field() }}
                        <div class="row">
                            <small>Job Status</small>
                            {{ Form::selectGroup('status', 'Status', $vendor_statuses, null, ['class'=>'selectpicker', 'id'=>'status', 'data-live-search'=>'true']) }}
                        </div>
                    </fieldset>

                    {{-- Client Interview --}}
                    <div class="mt-5 ml-0 mr-0" id="clientInterview" style="display: none;">
                        <form method="post" action="{{ url('/save_clientinterview') }}" id="clientForm" autocomplete="off">
                            <h4>Client Interview Details</h4>
                            <input type="hidden" name="consultant_id" id="consultant_id1">
                            <input type="hidden" name="vendor_submission_id" id="vendor_submission_id1">
                            <input type="hidden" name="consultant_status" id="consultant_status1">
                            {{ csrf_field() }}

                            <div class="row mt-3">
                                <div class="col-md-6 col-lg-6 col-sm-12">
                                    {{ Form::textGroup('client_interview_date', 'Interview Date:', null, ['id' => 'datepicker1', 'class' => 'form-control has-value', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'placeholder'=>'YYYY-MM-DD']) }} 
                                </div>
                                <div class="col-md-6 col-lg-6 col-sm-12">
                                    {{ Form::textGroup('client_interview_time', 'Interview time:-', null, ['id'=>'timepicker', 'class'=>'form-control scheduled_date timepicker', 'style'=>'top: 16px;bottom: 0px;padding-bottom: 0px;']) }}
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary btn-sm pull-right">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>

                    {{-- Joined --}}
                    <div class="mt-3 ml-0 mr-0" id="joinedDiv" style="display: none;">
                        <div id="joinedForm"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<button type="button" class="btn" data-toggle="modal" data-target="#statusModal" id="statusBtn"
    style="display: none;"></button>
{{-- Status Modal Ends Here --}}

@include('includes.new-comment')
@include('includes.new-mail')
@include('includes.datepicker')

<script>
    var today = new Date();

    $('#datepicker1').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
    $('#datepicker1').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        clearBtn: true
    });

    $('#timepicker').timepicker({
        timeFormat: 'H:i a'
    });

    function changeStatus(id, submission_id, consultant_id1) {
        $("#status > [value=" + id + "]").attr("selected", "true");
        $("#status").val(id);
        $("#consultant_id1").val(consultant_id1);
        $("#vendor_submission_id1").val(submission_id);
        $("#statusBtn").click();
        $("#joinedForm").html('');
    }

    $('select[name="status"]').on('change', function(){    
        var value = $(this).val();
        $("#consultant_status1").val(value);
        
        if (value == 'client_interview'){
            $("#clientInterview").show();
            $("#joinedDiv").hide();
        }
        else if(value == 'joined'){
            $("#clientInterview").hide();

            // Request Joined Form
            $.ajax({
                url: '{{ url('/submission_join_form') }}',
                type: 'GET',
                data: 'submission_id='+$("#vendor_submission_id1").val(),
                success:function(result){
                    $("#joinedForm").html(result);
                    $(".form-control").addClass('has-value');

                    $("#joinedFormId").on('submit', function(e) {
                        e.preventDefault();

                        $.ajax({
                            url: '{{ url('/save_submission_Join') }}',
                            type: 'POST',
                            data: $("#joinedFormId").serialize(),
                            success: function(result) {
                                $("#sub"+result.submission_id).html(result.btn);

                                $("#action"+result.submission_id+" a:first-child").remove();
                                $("#action"+result.submission_id).prepend(result.editbtn);

                                $("#pay"+result.submission_id).html(result.payrate);

                                $("#sub"+result.submission_id).attr("id", 'sub'+result.newId);
                                $("#pay"+result.submission_id).attr("id", 'pay'+result.newId);
                                $("#action"+result.submission_id).attr("id", 'action'+result.newId);
                                
                                $(".close").trigger('click');
                                $("#joinedForm").html('');                                
                            }
                        })
                    });
                }
            });

            $("#joinedDiv").show();
        } else {
            $("#clientInterview").hide();
            $("#joinedDiv").hide();

            $.ajax({
                url: '/change_submisssion_status',
                data: 'status='+$("#status").val()+'&vendor_submission_id='+$("#vendor_submission_id1").val()+'&consultant_id='+$("#consultant_id1").val(),
                success: function(result) {
                    $('.modal-backdrop').remove();
                    console.log('removed');
                    $(".close").trigger('click');
                    $("#sub"+result.submission_id).html(result.btn);

                    $("#action"+result.submission_id+" a:first-child").remove();
                    $("#action"+result.submission_id).prepend(result.editbtn);

                    $("#sub"+result.submission_id).attr("id", 'sub'+result.newId);
                    $("#pay"+result.submission_id).attr("id", 'pay'+result.newId);
                    $("#action"+result.submission_id).attr("id", 'action'+result.newId);
                }
            })
        }
    });

    // Client Interview Form Submit
    $("#clientForm").on('submit', function(e){
        e.preventDefault();

        $.ajax({
            url: '/save_client_interview',
            type: 'POST',
            data: $("#clientForm").serialize(),
            success: function() {
                console.log('ok');
            }
        })
    })
</script>
@stop