@extends('layouts.default')
@section('title', 'Edit vendor submission')
@section('header-links')
    @include('includes.headers.vendor_submissions')
@endsection
@section('content')
<style>
	.card {
	    margin-top: 20px !important;
	}
    label {
        font-weight: bold;
    }
</style>
<div class="pmd-tabs pmd-tabs-bg nav-CircleTabContainer">
	<div class="form_wizard wizard_horizontal" id="wizard">
		<ul role="tablist" class="wizard_steps nav nav-tabs" id="circleTabs">
			<li class="nav-item">
				<a class="nav-link" data-toggle="tab" href="#step-1" role="tab">
				<span class="cTbasIcon waves-effect waves-gray"><span
					class="icon24 icon-Education-Black"></span></span>
				<span class="cTbasLabel">Job Details</span>
				</a>
			</li>
			<li class="nav-item">
				<a class="nav-link " data-toggle="tab" href="#step-2" role="tab">
				<span class="cTbasIcon waves-effect waves-gray"><span
					class="icon24 icon-Certification-Black"></span></span>
				<span class="cTbasLabel">Vendor Details</span>
				</a>
			</li>
			<li class="nav-item">
				<a class="nav-link " data-toggle="tab" href="#step-3" role="tab">
				<span class="cTbasIcon waves-effect waves-gray"><span
					class="icon24 icon-Experience-Black"></span></span>
				<span class="cTbasLabel">Client Details</span>
				</a>
			</li>
		</ul>
        <div class="card">
            <h4>Consultant</h4>
            <div class="row">
                <div class="col-md-3">
                    <label for="">Name:- </label>
                    {{ ucwords($consultant->name) }}
                </div>
                <div class="col-md-3">
                    <label for="">Email:- </label>
                    {{ $consultant->email }}
                </div>
                <div class="col-md-3">
                    <label for="">Phone:- </label>
                    {{ $consultant->mobile }}
                </div>
            </div>
        </div>
		<div class="pmd-card-body nav-CircleTabBodyContainer">
            {!! Form::model($vendor_submission, ['route'=>['vendor_submissions.update', $vendor_submission->id], 'id'=>'vendorSubmissionForm', 'data-toggle'=>'validator', 'role'=>'form', 'method'=>'PUT']) !!}
			@csrf
			{{-- Selected Consultants --}}
			<div class="col-md-12 details" id="details">
				<!--ajax data here-->
			</div>

			<div class="tab-content">
				{{-- JOB DETAILS --}}
				<div class="tab-pane active" id="step-1" role="tabpanel">
					<div class="row">
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textGroup('job_title', 'Job title', $job->title, ['id'=>'job_title', 'required'=>'required', 'maxlength'=>'100', 'class'=>'step2Text form-control ']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('job_country_id', 'Country', $countries, $job->country_id, ['id'=>'country_1', 'onchange'=>'getStates(1)', 'required'=>'required', 'class'=>'selectpicker step2Select']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('job_state_id', 'State', $states, $job->state_id, ['id'=>'state_1', 'onchange'=>'getCities(1)']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('job_city_id', 'City', $cities, $job->city_id, ['id'=>'city_1']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::numberGroup('job_min_experience', 'Min Experience', $job->min_experience, ['id'=>'job_min_experience', 'required'=>'required', 'class'=>'step2Text form-control']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::numberGroup('job_max_experience', 'Max Experience', $job->max_experience, ['id'=>'job_max_experience', 'required'=>'required', 'class'=>'step2Text form-control']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('job_interview_mode', 'Interview Mode', $interview_modes, $job->interview_mode, ['id'=>'job_interview_mode', 'required'=>'required', 'class'=>'selectpicker step2Select']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('job_employment_type', 'Employment Types', $employment_types, $job->employment_type,
							['id'=>'job_employment_type', 'required'=>'required', 'class'=>'selectpicker step2Select']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::numberGroup('payrate','Pay Rate', $job->min_payrate, ['id'=>'payrate', 'required'=>'required', 'class'=>'step2Text form-control']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{{ Form::numberGroup('job_project_year', 'Years', $job->project_years, ['id'=>'job_project_year', 'max'=>'20']) }}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{{ Form::numberGroup('job_project_month', 'Months', $job->project_months, ['id'=>'job_project_month', 'max'=>'11']) }}
						</div>
					</div>
					<div class="row">
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textareaGroup('job_description', 'Job Description', $job->description, ['id'=>'job_description', 'required'=>'required', 'rows'=>'1', 'class'=>'form-ControlTextArea step2Text']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textareaGroup('job_internal_message', 'Job Internal Message', $job->internal_message, ['id'=>'job_internal_message', 'rows'=>'1']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textareaGroup('job_site_link', 'Job site link', $job->site_link, ['id'=>'job_site_link', 'rows'=>'1']) !!}
						</div>
					</div>
				</div>

				{{-- VENDOR DETAILS --}}
				<div class="tab-pane" id="step-2" role="tabpanel">
					<div class="card">
						<div id="">
                            @foreach($jobVendors as $k=>$jv)
                            @php
                                $vendors = vendorSelect($jv->vendor_company_id);
                            @endphp
							<div id="{{ $k+1 }}">
								<div class="row">
									<div class="col-md-3 col-sm-6">
										{{ Form::selectGroup('vendor_company_id[]', 'Vendor Company', $vendor_companies+['add'=>'Add new company'], $jv->vendor_company_id, ['id'=>'vendor_company_select_1', 'onchange'=>'getVendors(1)', 'required'=>'required', 'class'=>'step3Select selectpicker']) }}
									</div>
									<div class="col-md-3 col-sm-6">
										{{ Form::selectGroup('vendor_id[]', 'Vendor', ['add'=>'Add new vendor']+$vendors, $jv->vendor_id, ['id'=>'vendor_select_1', 'required'=>'required', 'class'=>'step3Select selectpicker vendorSelect', 'onchange'=>'getVendor(1)', 'size'=>'1']) }}
									</div>
								</div>
								<div class="row">
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::textGroup('vendor_name[]', 'Vendor name', $jv->vendor?->name, ['id'=>'vendor_name_1', 'required'=>'required', 'maxlength'=>'100', 'class'=>'step3Text form-control']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::textGroup('vendor_email[]', 'Vendor email', $jv->vendor?->email, ['id'=>'vendor_email_1', 'required'=>'required', 'pattern'=>'[a-z0-9._-]+@[a-z0-9.-]+\.[a-z.]{2,}$', 'maxlength'=>'50', 'class'=>'step3Text form-control']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::textGroup('vendor_mobile[]', 'Vendor mobile', $jv->vendor?->mobile, ['id'=>'vendor_mobile_1', 'required'=>'required', 'maxlength'=>'14', 'class'=>'step3Text form-control']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::textGroup('vendor_website[]', 'Website', $jv->vendor?->website, ['id'=>'vendor_website_1', 'required'=>'required', 'maxlength'=>'100', 'class'=>'step3Text form-control']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::selectGroup('vendor_country_id[]', 'Country', $countries, $jv->vendor?->country_id, ['id'=>'country_2', 'required'=>'required', 'data-live-search'=>'true', 'onchange'=>'getStates(2)', 'class'=>'step3Select selectpicker']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::selectGroup('vendor_state_id[]', 'State', $states, $jv->vendor?->state_id, ['id'=>'state_2', 'data-live-search'=>'true', 'onchange'=>'getCities(2)']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{!! Form::selectGroup('vendor_city_id[]', 'City', $cities, $jv->vendor?->city_id, ['id'=>'city_2', 'data-live-search'=>'true']) !!}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{{ Form::selectGroup('vendorship[]', 'Vendorship', [0=>'No', 1=>'Yes'], $jv->vendor?->status, ['id'=>'vendor_vendorship_1']) }}
									</div>
									<div class="col-lg-3 col-md-3 col-sm-12">
										{{ Form::selectGroup('replied_vendor[]', 'Replied Vendor', [0=>'No', 1=>'Yes'], $jv->vendor?->replied_status, ['id'=>'vendor_replied_vendor_1']) }}
									</div>
									<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-group">
										{!! Form::textGroup('vendor_address[]', 'Address', $jv->vendor?->address, ['id'=>'vendor_address_1']) !!}
									</div>
								</div>
							</div>
                            @endforeach
						</div>

                        <h3>{!! __('Vendor Screening Details') !!}</h3>
						<div class="row">
							<div class="col-md-3 col-sm-6">
								<div class="form-group">
									{!! Form::textGroup('vendor_interviewer_name', 'Interviewer Name', $vendor_screening?->name,
									['id'=>'vendor_interviewer_name', 'maxlength'=>'100']) !!}
								</div>
							</div>
							<div class="col-md-3 col-sm-6">
								<div class="form-group">
									{!! Form::textGroup('vendor_interviewer_mobile_number', 'Interviewer Mobile Number', $vendor_screening?->mobile, ['id'=>'vendor_interviewer_mobile_number', 'maxlength'=>'14']) !!}
								</div>
							</div>
							<div class="col-md-3 col-sm-6">
								<div class="form-group">
									{!! Form::textGroup('vendor_interviewer_email_id', 'Interviewer Email Id', $vendor_screening?->email, ['id'=>'vendor_interviewer_email_id', 'pattern'=>'[a-z0-9._-]+@[a-z0-9.-]+\.[a-z.]{2,}$', 'data-pattern-error'=>'Also, include a TLD. (Example: .com, .co.in, .co.us ...)', 'maxlength'=>'50']) !!}
								</div>
							</div>
							{{-- <div class="col-md-3 col-sm-6 text-right">
								<button class="btn btn-sm btn-danger" type="button" onclick="removeVendor()"><i class="fa fa-plus"></i> Remove Vendor</button>
								<button class="btn btn-sm btn-primary" id="add_vendor" type="button" onclick="addVendor()"><i class="fa fa-plus"></i> Add Vendor</button>
							</div> --}}
						</div>
					</div>

                    {{-- Implementor Div --}}
					<div class="card">
						<h3 class="ml-3">Implementor Details</h3>
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::textGroup('implementor_name', 'Implementor company name', $job->implementor?->name, ['id'=>'name', 'maxlength'=>'100']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::textGroup('implementor_contact_name', 'Contact person', $job->implementor?->contact_name, ['id'=>'contact_name', 'maxlength'=>'100']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::textGroup('implementor_email', 'Implementor email', $job->implementor?->email, ['id'=>'email', 'pattern'=>'[a-z0-9._-]+@[a-z0-9.-]+\.[a-z.]{2,}$', 'data-pattern-error'=>'Also, include a TLD. (Example: .com, .co.in, .co.us ...)', 'maxlength'=>'50']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::textGroup('implementor_mobile', 'Implementor mobile', $job->implementor?->mobile, ['id'=>'mobile', 'maxlength'=>'14']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::textGroup('implementor_website', 'Website', $job->implementor?->website, ['id'=>'website']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::selectGroup('implementor_country_id', 'Country', $countries, $job->implementor?->country_id, ['id'=>'country_3', 'data-live-search'=>'true', 'onchange'=>'getStates(3)']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::selectGroup('implementor_state_id', 'State', $states, $job->implementor?->state_id, ['id'=>'state_3', 'data-live-search'=>'true', 'onchange'=>'getCities(3)']) !!}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                {!! Form::selectGroup('implementor_city_id', 'City', $cities, $job->implementor?->city_id, ['id'=>'city_3', 'data-live-search'=>'true']) !!}
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-group">
                                {!! Form::textGroup('implementor_address', 'Address', $job->implementor?->name, ['id'=>'address']) !!}
                            </div>
                        </div>
                        
                        <h3 class="ml-3">Implementer Screening Details</h3>
                        <div class="row">
                            <div class="col-md-3 col-sm-6">
                                <div class="form-group">
                                    {!! Form::textGroup('imp_interviewer_name', __('Interviewer Name'), $implementor_screening?->name, ['id'=>'imp_interviewer_name', 'maxlength'=>100]) !!}
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="form-group">
                                    {!! Form::textGroup('imp_interviewer_mobile_number', __('Interviewer Mobile Number'), $implementor_screening?->mobile, ['id'=>'imp_interviewer_mobile_number', 'maxlength'=>'14']) !!}
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="form-group">
                                    {!! Form::textGroup('imp_interviewer_email_id', __('Interviewer Email Id'), $implementor_screening?->email, ['id'=>'imp_interviewer_email_id', 'maxlength'=>'100']) !!}
                                </div>
                            </div>
                        </div>
					</div>
				</div>

				{{-- CLIENT DETAILS --}}
				<div class="tab-pane" id="step-3" role="tabpanel">
					<h3>{!! __('Client Details') !!}</h3>
					<div class="row">
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textGroup('client_name', 'Client company name', $client->name, ['id'=>'name', 'required'=>'required', 'maxlength'=>'100']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textGroup('client_email', 'Client email', $client->email, ['id'=>'email', 'required'=>'required', 'pattern'=>'[a-z0-9._-]+@[a-z0-9.-]+\.[a-z.]{2,}$', 'data-pattern-error'=>'Also, include a TLD. (Example: .com, .co.in, .co.us ...)', 'maxlength'=>'50']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textGroup('client_mobile', 'Client mobile', $client->mobile, ['id'=>'mobile', 'required'=>'required', 'maxlength'=>'14']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::textGroup('client_website', 'Website', $client->website, ['id'=>'website']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('client_country_id', 'Country', $countries, $client->country_id, ['id'=>'country_4', 'required'=>'required', 'data-live-search'=>'true', 'onchange'=>'getStates(4)']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('client_state_id', 'State', $states, $client->state_id, ['id'=>'state_4', 'data-live-search'=>'true', 'onchange'=>'getCities(4)']) !!}
						</div>
						<div class="col-lg-3 col-md-3 col-sm-12">
							{!! Form::selectGroup('client_city_id', 'City', $cities, $client->city_id, ['id'=>'city_4', 'data-live-search'=>'true']) !!}
						</div>
						<div class="col-lg-12 col-md-12 col-sm-6 col-xs-12 form-group">
							{!! Form::textareaGroup('client_address', 'Address', $client->address, ['id'=>'address']) !!}
						</div>
					</div>

					<h3>{!! __('Client Screening Details') !!}</h3>
					<div class="row">
						<div class="col-md-3 col-sm-6">
							<div class="form-group">
								{!! Form::textGroup('client_interviewer_name', __('Interviewer Name'), $client_screening?->name,
								['id'=>'client_interviewer_name']) !!}
							</div>
						</div>
						<div class="col-md-3 col-sm-6">
							<div class="form-group">
								{!! Form::textGroup('client_interviewer_mobile_number', __('Interviewer Mobile
								Number'), $client_screening?->mobile,
								['id'=>'client_interviewer_mobile_number', 'maxlength'=>'14']) !!}
							</div>
						</div>
						<div class="col-md-3 col-sm-6">
							<div class="form-group">
								{!! Form::textGroup('client_interviewer_email_id', __('Interviewer Email Id'),
								$client_screening?->email,
								['id'=>'client_interviewer_email_id', 'maxlength'=>'100']) !!}
							</div>
						</div>
					</div>
				</div>
			</div>
			{!! Form::close() !!}
		</div>
	</div>
</div>

{{ Form::hidden('count_id', 5, ['id'=>'count_id']) }}

@include('includes.validator')
@include('includes.country-state-city-script')
{{-- Smartwizard --}}
<script type="text/javascript" src="{{ asset('theme/plugins/jQuery-Smart-Wizard/js/jquery.smartWizard.js') }}"></script>
<script src="{{ asset('js/pages/submissions/edit-submission.js') }}"></script>
@stop