@extends('layouts.default')
@section('title', 'Apply consultants for job')
@section('header-links')
    @include('includes.headers.vendor_submissions')
@endsection

@section('new_button')
<div class="searchBox mr-2 ml-35">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm',
    'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{!! URL::to('/vs_consultants') !!}"
    class="btn btn-info btn-Rcircle-iconic waves-effect waves-light d-flex align-items-center"><i
        class="material-icons"> list </i>Consultant list</a>
@endsection

@section('content')

{{ Form::open(['url'=>'save_consultant_job', 'id'=>'saveForm']) }}
<div class="row">
    <div class="col-lg-12 col-md-12">
        {{ Form::hidden('consultant_id', $consultant->id) }}
        <table class="table table-striped table-bordered table-filter">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Location</th>
                    <th>Employment Type</th>
                    <th>Experience</th>
                    <th>Pay Rate</th>
                    <th>Client Name</th>
                    <th>Job Status</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($applied as $li)
                <tr class="applied">
                    <td data-toggle="tooltip" title="{{ ucwords($li->title) }}">{{ ucwords(Str::limit($li->title, 15)) }}</td>
                    <td>{{ ucwords($li->country?->name) }}</td>
                    <td>{{ ucwords(str_replace('_', ' ' , $li->employment_type)) }}</td>
                    <td>{{ $li->min_experience }} - {{ $li->max_experience }}</td>
                    <td>{{ $li->min_payrate }} - {{ $li->max_payrate }}</td>
                    <td>{{ $li->client?->name }}</td>
                    <td>{{ ucwords($li->status) }}</td>
                    <td>{{ ucwords('Applied') }}</td>
                    <td></td>
                </tr>             
                @endforeach

                @foreach ($notapplied as $li)
                <tr class="applied">
                    <td data-toggle="tooltip" title="{{ ucwords($li->title) }}">{{ ucwords(Str::limit($li->title, 15)) }}</td>
                    <td>{{ ucwords($li->country?->name) }}</td>
                    <td>{{ ucwords(str_replace('_', ' ' , $li->employment_type)) }}</td>
                    <td>{{ $li->min_experience }} - {{ $li->max_experience }}</td>
                    <td>{{ $li->min_payrate }} - {{ $li->max_payrate }}</td>
                    <td>{{ $li->client?->name }}</td>
                    <td>{{ ucwords($li->status) }}</td>
                    <td>{{ ucwords('Not Applied') }}</td>
                    <td>
                        @form_checkbox('job_id[]', $li->id)
                    </td>
                </tr>             
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="col-md-12" style="display: inline-flex;">
        <div class="col-md-3"></div>
        <div class="col-md-4"></div>
        <div class="col-md-3">
            {{ Form::numberGroup('payrate', 'Payrate', null, ['id'=>'payrate', 'required'=>'required']) }}
        </div>
        <div class="col-md-2 text-right">
            <button class="btn btn-sm btn-primary pull-right" onclick="applyJob()">Click to Apply</button>
        </div>
    </div>
</div>
{{ Form::close() }}
@stop