@extends('layouts.default')
@section('title', 'Vendor Companies List')
@section('header-links')
    @include('includes.headers.vendor_companies')
@endsection
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
    <a  href="{!! URL::to('/vendor_companies/create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create College"><i class="material-icons left"> add </i>Create vendor company</a>
@endsection
@section('content')
<div class="">
<table class="table table-striped table-show table-bordered table-filter dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th>Name</th>
            <td>Created By</td>          
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($list as $k=>$li)
        <tr>            
            <td>{{ ucwords($li->name) }}</td>
            <td>{{ ucwords($li->creater?->name) }}</td>
            <td>
                <a href="/vendor_companies/{{$li->id}}/edit" class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
            </td>
        </tr>
        @endforeach

        @if(count($list) == 0)
        <tr>
            <td class="text-center" colspan=3>No data</td>
        </tr>
        @endif
    </tbody>
</table>
</div>
@stop