@extends('layouts.default')
@section('title','Users Login Details')
@section('new_button')
<div class="searchBox mr-2">
	{!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
	<span class="search-icn"><i class="material-icons">search</i></span>
	<span class="form-controlBrd width-80"></span>
</div>
@endsection
@section('content')
<!-- page content -->
<div class="right_col" role="main">
	<div class="row">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<table class="table table-show table-striped table-bordered table-show table-filter dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
				<thead>
					<tr>
						<th>User Name</th>
						<th>Login-IP</th>
						<th>Login-Time</th>
						<th>Logout-IP</th>
						<th>Logout-Time</th>
					</tr>
				</thead>
				<tbody>
					@foreach($list as $li)
					<tr>
						<td>{{ ucwords($li->user->name) }}</td>
						<td>{{ $li->checkin_ip }}</td>
						<td>  {{ Date::parse($li->checkin_time)->format(env('APP_DATE')).' '.Date::parse($li->checkin_time)->format('H:i:s') }}</td>
						<td>{{ $li->checkout_ip }}</td>
						<td>@if($li->checkout_time != '') {{ Date::parse($li->checkout_time)->format(env('APP_DATE')).' '.Date::parse($li->checkout_time)->format('H:i:s') }}@endif</td>
					</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@stop