@extends('layouts.default')
@section('title', ucwords(Auth::user()->name).' Profile')
{{-- @section('new_button')
<a class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" href="{{ url('profile/'.encrypt($user->user_id).'/edit') }}"> <i class="material-icons left">edit</i> Edit Profile </a>
@endsection --}}
@section('content')
@php
    $profile = $user->profile;
@endphp
<div class="profilePage">
    <div class="profileBanner">
        <div class="profileBannerImg"><img src="{{ asset('/theme/images/img.jpeg') }}" alt="{{ asset('/theme/images/img.jpeg') }}"></div>
        <div class="profileBanner-Overlay"></div>
    </div>
    <div class="profile-Info">
        <div class="profilePic">
            <form id="uploadImageForm" action="{{ url('profile') }}" method="post" enctype="multipart/form-data">
                <div id="crop-avatar">
                    <label for="profile_img" style="cursor: pointer">
                    <img class="profilePic-Image" src="{{ asset('/profile_images/dummy.png') }}" alt="Avatar" title="Click to change the Avatar">
                    </label>
                </div>
                <i class="material-icons">edit</i>
                {{-- <i class="fa fa-info-circle"> Click on the Image to change the Avatar</i> --}}
                <input type="file" id="profile_img" name="profile_img" style="display: none;">
                {{ csrf_field() }}
            </form>
        </div>
        <div class="profile-InfoContainer">
            <div class="profileInfoBlock profileNameBlock ">
                <div class="profileName">{{ ucwords($user->name) }}</div>
                <div class="profileNameCaption"> {{ $user->display_name }}</div>
            </div>
            <div class="profileInfoBlock">
                <div class="profileNameLabel"><i class="material-icons">mail_outline</i></div>
                <div class="profilevalueLabel"> {{ $user->email }}</div>
            </div>
            <div class="profileInfoBlock">
                <div class="profileNameLabel"><i class="material-icons">call</i></div>
                <div class="profilevalueLabel"> {{ $user->mobile }}</div>
            </div>
            <div class="profileInfoBlock">
                <div class="profileNameLabel"><i class="material-icons">location_on</i></div>
                <div class="profilevalueLabel"> {{ isset($user->city?->name)?ucwords($user->city?->name).', ':'' }}{{ isset($user->state?->name)?ucwords($user->state?->name).', ':'' }}{{ isset($user->country?->name)?ucwords($user->country?->name):'' }}</div>
            </div>
        </div>
    </div>
</div>
<h2 class="mt-4 mb-3">{{ ucwords(Auth::user()->name)}} Report <small>Activity report</small></h2>
<div class="card">
    <h4>Latest Consultants joined in Job  {{ date('Y') }}</h4>
    <div id="" style="width:100%; height:330px;">
        <table class="table table-show table-striped table-bordered dt-responsive nowrap jambo_table table-filter" cellspacing="0" id="abcd">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Technologies</th>
                    <th>Visa Type</th>
                    <th>Status</th>
                    <th>Creater</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($list as $consultant)
                    @php
                        $techs = '';
                        foreach ($consultant->technologies as $value) {
                            $techs = $techs.' '.$technologies[$value->technology_id];
                        }
                    @endphp
                    <tr>
                        <td>{{ Date::parse($consultant->created_at)->format(env('APP_DATE'))  }}</td>
                        <td>
                            <a href="{{ url('consultants/'.$consultant->id) }}"
                                style="text-decoration: underline;">{{ ucwords($consultant->name) }}</a>
                        </td>
                        <td>{{ $consultant->mobile }}</td>
                        <td>{{ $consultant->email }}</td>
                        <td title="{{ $techs }}">
                            {{ Str::limit($techs, 15) }}
                        </td>
                        <td>{{ ucwords($consultant->visa_status) }}</td>
                        <td>{{ $statuses[$consultant->status] }}</td>
                        <td>
                            @if(isset($consultant->creater?->name)) 
                            {{ ucwords($consultant->creater?->name) }}
                            @endif
                        </td>
                        <td>
                            <a title="Edit" href="/consultants/{{$consultant->id}}/edit"
                                class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                            <a title="Send Mail" onclick="get_mail('{{ $consultant->email }}')"
                                class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons"> mail </i></a>
                            <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                                    onclick="addComment({{ $consultant->id }})"> <i class="material-icons"> comment </i> </button>
                        </td>
                    </tr>
                @endforeach
                @if(count($list) == 0)
                <tr>
                    <td colspan="7" class="text-center">No Data</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
<div class="card">
    <h4>Change Password</h4>
    {{ Form::open(array('url' => 'change_password', 'id' => 'change_password_form', 'class' => 'form-horizontal form-label-left', 'data-toggle' => 'validator', 'role' => 'form', 'autocomplete' => 'off')) }}
    <div class="row">
        <div class="col-lg-3 col-md-4 col-sm-6">
            <div class="form-group">
                <input type="password" id="new_password" name="new_password" class="form-control" required maxlength="50"
                    required>
                <label class="form-label">New Password<i class="mandatory">*</i></label>
                <span class="form-controlBrd"></span>
                <div class="help-block with-errors"></div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-sm-6">
            <div class="form-group">
                <input type="password" id="confirm_password" name="confirm_password" class="form-control" required
                    maxlength="50" required>
                <label class="form-label">Confirm Password<i class="mandatory">*</i></label>
                <span class="form-controlBrd"></span>
                <div class="help-block with-errors"></div>
            </div>
        </div>
    
    </div>
    <div class="form-group no-margin text-right">
        <div class="text-right">
            <a class="btn mr-3 btn-default waves-effect waves-gray" href="{{ url('/') }}">Cancel</a>
            <button type="submit" class="btn btn-primary waves-effect waves-light" name="change_password"
                id="change_password" value="1">Submit</button>
        </div>
    </div>
    {{ csrf_field() }}
    {{ Form::close() }}
</div>
<script type="text/javascript">
    $(document).ready(function(){
    	$("#profile_img").change(function(){
    		$("#uploadImageForm").submit();
    	});
    
    	if($('#student_details').length){
    		Morris.Bar({
    	  		element: 'student_details',
    		  	data: '',
    			xkey: 'period',
    			ykeys: ['employees'],
    			labels: ['Joined Employees'],
    			barRatio: 0.4,
    			barColors: ['#26B99A', '#34495E', '#ACADAC', '#3498DB'],
    			xLabelAngle: 35,
    			hideHover: 'auto',
    			resize: true
    		});
    	}
    });
</script>
@stop