@extends('layouts.default')
@section('title', 'Create new user')
@section('new_button')
<a href="{{ url('users') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light">
	Users List
</a>
@endsection
@section('content')
<style>
	h4 {
		text-decoration: underline;
	}
</style>
<div class=" card col-md-12">
	{!! Form::model($user, ['url'=>['users', $user->id], 'method'=>'PUT', 'id'=>'createForm']) !!}
	<h4>Marketing Information</h4>
	<div class="row">
        <div class="col-md-3">
            {!! Form::textGroup('name', 'Name', $user->name, ['required'=>'required']) !!}
        </div>
        <div class="col-md-3">
            {!! Form::emailGroup('email', 'Email', $user->email, ['required'=>'required', 'readonly']) !!}
        </div>
		<div class="col-lg-3 col-md-4 col-sm-6">
			<div class="form-group">
				<input type="text" class="form-control" id="mobile" name="mobile"
						pattern="^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$"
						data-pattern-error="Format. Example:(011) 123-4567" required maxlength="14" value="{{ $user->mobile }}">
				<label class="form-label">{{ 'Mobile Number' }}<span class="RED-Star">*</span></label>
				<span class="form-controlBrd"></span>
				<div class="help-block with-errors"></div>
			</div>
		</div>
        <div class="col-md-3">
            {!! Form::fileGroup('profile_pic', 'Profile pic') !!}
        </div>
        <div class="col-md-3">
		{{ Form::selectGroup('country_id', 'Country', $countries, $user->country_id, ['data-live-search'=>'true', 'onchange'=>'getStates(1)', 'id'=>'country_1']) }}
        </div>
        <div class="col-md-3">
		{{ Form::selectGroup('state_id', 'State', $states, $user->state_id, ['data-live-search'=>'true', 'onchange'=>'getCities(1)', 'id'=>'state_1']) }}
        </div>
        <div class="col-md-3">
		{{ Form::selectGroup('city_id', 'City', $cities, $user->city_id, ['data-live-search'=>'true', 'id'=>'city_1']) }}
        </div>
	</div>

	{{-- Personal Info --}}
	<h4 class="mt-5">Personal Information</h4>
	<div class="row">
        <div class="col-md-3">
		{{ Form::textGroup('mark_name', 'Name', $user->profile->name, []) }}
        </div>

        <div class="col-md-3">
		{{ Form::textGroup('mark_email', 'Email', $user->profile->email, []) }}
        </div>

		<div class="col-lg-3 col-md-4 col-sm-6">
			<div class="form-group">
				<input type="text" class="form-control" id="mark_mobile" name="mark_mobile"
					pattern="^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$"
					data-pattern-error="Format. Example:(011) 123-4567" required maxlength="14" value="{{ $user->profile->mobile }}">
				<label class="form-label">Mobile <span class="RED-Star">*</span></label>
				<span class="form-controlBrd"></span>
				<div class="help-block with-errors"></div>
			</div>
		</div>
        
        <div class="col-md-3">
            {{ Form::selectGroup('mark_country_id', 'Country', $countries, $user->profile->country_id, ['data-live-search'=>'true', 'id'=>'country_2', 'onchange'=>'getStates(2)']) }}
        </div>

        <div class="col-md-3">
		{{ Form::selectGroup('mark_state_id', 'State', $states, $user->profile->state_id, ['data-live-search'=>'true', 'id'=>'state_2', 'onchange'=>'getCities(2)']) }}
        </div>

        <div class="col-md-3">
		{{ Form::selectGroup('mark_city_id', 'City', $cities, $user->profile->city_id, ['data-live-search'=>'true', 'id'=>'city_2']) }}
        </div>
	</div>

	{{-- Role & Department --}}
	<h4 class="mt-5">User Information</h4>
	<div class="row">
        <div class="col-md-3">
		    {!! Form::selectGroup('company_id', 'Country', $companies, null, ['class'=>'selectpicker','data-live-search'=>'true' ,'required'=>'required', 'id'=>'companySelect']) !!}
        </div>
        <div class="col-md-3">
		    {!! Form::selectGroup('department_id', 'Department', $departments, null, ['class'=>'selectpicker','data-live-search'=>'true', 'title'=>'Select Department']) !!}
        </div>
        <div class="col-md-3">
            <small>Select Role</small>
            <select name="role_id" id="" class="selectpicker">
                @foreach ($roles as $rid=>$role)
                <option value="{{ $rid }}" @if($rid == $role_id) selected @endif>{{ ucwords($role) }}</option>
                @endforeach
            </select>
        </div>
		<div class="col-md-3 col-lg-3 col-sm-12">
			<small>Reporting Person {{ redStar() }}</small>
			<select name="parent_id" class="selectpicker" id="parentSelect" data-live-search="true"
				title="Select Reporting Person" id="parent_id" required>
				@foreach($users as $uid=>$child)
                    @php
                        $urs_role = App\Models\User::find($uid)->getRoleNames()[0];
                    @endphp
                    <optgroup label="Role: {{ $urs_role }} ">
                        <option value="{{ $uid }}" @if($uid == $user->parent_id) selected @endif>{{ ucwords($child) }}</u></option>
                    </optgroup>
				@endforeach
			</select>
		</div>
	</div>
	<div class="col-md-12">
		<div class="form-group no-margin text-right">
			<a href="{{ url('/') }}" class="btn btn-default waves-effect waves-light"><span
					class="fa fa-times-circle"></span> &nbsp; Cancel</a>
			{!! Form::submit('Save', ['type' => 'submit', 'class' =>
			'btn btn-primary waves-effect waves-light']) !!}
		</div>
	</div>

	{!! Form::close() !!}
</div>

<script>
	$("#mobile").mask("(000) 000-0000");
	$("#mark_mobile").mask("(000) 000-0000");


    // Get States By Country
    function getStates(id) {
        var country = $("#country_" + id).val();
        $("#state_" + id).empty().selectpicker('refresh');
        $("#city_" + id).empty().selectpicker('refresh');
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/get_states',
            data: 'country_id=' + country,
            success: function(result) {
                $("#state_" + id).append(result);
                $("#state_" + id).selectpicker('refresh');
            }
        });
    }

    // Get Citites By State
    function getCities(id) {
        var state = $("#state_" + id).val();
        $("#city_" + id).empty().selectpicker('refresh');
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/get_cities',
            data: 'state_id=' + state,
            success: function(result) {
                $("#city_" + id).append(result);
                $("#city_" + id).selectpicker('refresh');
            }
        });
    }
	
	$(function() {
		$("form[id='createForm']").validate({
			// Specify validation rules
			rules: {
				name: "required",
				email: {
					required: true,
					email: true
				},
				role_id: "required",
			},
			// Specify validation error messages
			messages: {
				name: "Please enter your name",
				email: "Please enter a valid email address",
				role_id: "Please select user role",
			},
			// Make sure the form is submitted to the destination defined
			submitHandler: function(form) {
				form.submit();
			}
		});
	});
</script>
<style>
	.dropdown-header > span {
		text-decoration: underline !important;
	}
</style>
@endsection