@extends('layouts.default')
@section('content')
<style type="text/css">

  input[type=number]::-webkit-inner-spin-button, 
  input[type=number]::-webkit-outer-spin-button { 
  -webkit-appearance: none; 
  }
  a,
  table a {
      cursor: pointer;
  }
  input[type=number] {
    -moz-appearance: textfield;
    color: #000;
  }

 
input {
    height: 85px;
    line-height: 15px;
    /* width: 100%; */
}
.tablemiddel {
    
    padding: 6px 20px 6px 0px !important;
}
table { width: 3em }
 
.schTbHead-Text {
    margin-bottom: 10px !important;
    top: 10px;
    position: relative;
}
.schTbHead-Text h4 {
    margin: 0 0px;
    position: relative;
    color: #0c6dff;
    top: -7px;
}
  
.table td {
  
    text-align: center !important;
}
</style>
<div class="page-title">
     <h3>Time Sheets </h3>
</div>

<div class="card" role="main">
  <h5  class="card-header">Client Details</h5 >
  <div class="card-body">
      <div class="row">
          <div class="col-sm-3">
            <div class="form-group pb-0">
             <div class="text-themeGray">Vendor Name:</div>
             <divclass="font15">{{ isset($pay_rates->vendor_name)?$pay_rates->vendor_name:'-' }}  </div>
           </div>
          
          <div class="col-sm-3">
             <div class="form-group pb-0">
             <div class="text-themeGray">Vendor Email:</div>
             <divclass="font15">{{ isset($pay_rates->vendor_email)?$pay_rates->vendor_email:'-' }}</div>
              </div>
          
          <div class="col-sm-3">
          <div class="form-group pb-0">
              <div class="text-themeGray">Vendor Mobile:</div>
              <div class="col-md-6 col-sm-6 col-xs-12">{{ isset($pay_rates->vendor_mobile)?$pay_rates->vendor_mobile:'-' }}
              </div>
           </div>
          </div>
          <div class="col-sm-3">
            <div class="form-group pb-0">
                <div class="text-themeGray">Client Mobile:</div>
                <div class="col-md-6 col-sm-6 col-xs-12">{{ isset($pay_rates->client_name)?$pay_rates->client_name:'-' }}</div>
              </div>
          </div>
      </div>
 </div>
</div>

<div class="card">
  <div class="col-md-12 col-sm-12 col-xs-12 ">
      <form id="weeks_wise_working_hours" method="POST" action="{{ url('/weeks_wise_working_hours') }}" enctype="multipart/form-data">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12 text-center">
              <div class="schTbHead-Text"> 
                  <button class="schTbHead-TextBtn"   type="button" id="previousWeek"> <i class="material-icons">keyboard_arrow_left</i> </button>
                  
                  <h4   class="presentWeek" style="line-height: 1.0;"  id="presentWeek" ></h4>
                  <button class="schTbHead-TextBtn pl-0"  type="button" id="nextWeek"> <i class="material-icons"> keyboard_arrow_right </i> </button>
              </div> 
              <span id="weekly_timecard_unsaved_msg" style=" display: none;" >
                <strong>You have unsaved changes</strong>
              </span>
              <span id="weekly_timecard_saved_msg" style="display: none; ">
                <strong>Changes Saved Successfully</strong>
              </span>   
          </div>
        </div>
        <div class="table-responsive">
          <table class="mytable table table-bordered " >
            <thead>
              <tr>
                <th>Day/Date </th>
                <th>
                  <label class="label label-default mylabel">Mon</label>
                  <span id="day1" class="mylabel"  name="day1" ></span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Tue</label>
                  <span id="day2" class="mylabel"  name="day2"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Wed</label>
                  <span id="day3" class="mylabel"  name="day3"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Thu</label>
                  <span id="day4" class="mylabel"  name="day4"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Fri</label>
                  <span id="day5" class="mylabel"  name="day5"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Sat</label>
                  <span id="day6" class="mylabel"  name="day6"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Sun</label>
                  <span id="day7" class="mylabel"  name="day7"></span>
                </th>
                <th class="tablemiddel ">
                  Total <br>
                  Hours
                </th>
              </tr>
            </thead>
            <tbody>
              <tr>

                <td class="tablemiddel">REG Hours </td>
                <td> 
                  <input type="number" class="grid  mylabel ver" placeholder="0" min="00" id="monday" max="08" name="monday"  step="any">
                </td>
                <td > 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="tuesday" id="tuesday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="wednesday" id="wednesday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="thursday" id="thursday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="friday" id="friday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="saturday" id="saturday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="sunday" id="sunday" step="any">
                </td>
                <td class="tablemiddel editdisable span8" id="total_work_hours"> 
                  00
                </td>
              </tr>
              <tr>

                <td class="tablemiddel"> OT Hours </td>
                <td> 
                  <input type="number" class="grid  mylabel ver" placeholder="0" min="00" max="08" name="monday_ot" id="monday_ot" step="any">
                </td>
                <td > 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="tuesday_ot" id="tuesday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="wednesday_ot" id="wednesday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="thursday_ot" id="thursday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="friday_ot" id="friday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="saturday_ot" id="saturday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="08" name="sunday_ot" id="sunday_ot" step="any">
                </td>
                <td class="tablemiddel editdisable span9" id="total_ot_hours"> 
                  00
                </td>
              </tr>
              <tr class ="span7">
                <td class="tablemiddel"> Total Hours</td>
                <td class="tablemiddel editdisable" id="mon_total"> 00
                </td>
                <td class="tablemiddel editdisable" id="tue_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable" id="wed_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable" id="thu_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable" id="fri_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable" id="sat_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable" id="sun_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable total_hours text-center" id="total_hours" name="total_hours">
                  00
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        <div >
          <div class="form-groupTextArea form-groupTextArea60  ">
            <textarea class="form-ControlTextArea form-ControlTextArea60"  name="work_report" id="work_report"></textarea>
           <label  class="form-label">Summury Of Weekly Work Report (Please Write atleast Two Sentences On The Project Worked)</label>
           <span class="form-controlBrd"></span>
          </div>
        </div>

        <div class="row">
          <div class="labelwidth100">
          {{ Form::fileGroup('client_docs', 'Client Approved Timesheet') }} 
          </div>
          <div class="col-lg-3 col-md-4 col-sm-6 ">
            <div class="form-group">
              <a id="DownloadTimeSheet" >
                <button type="button" class="btn btn-primary waves-effect waves-light" id="client_docs_view" style="display: none"> Download Timesheet</button>
              </a>
              </div>
          </div>
        </div>

        <div class="col-lg-3 col-md-4 col-sm-6 text-right" id="approved_button" style="display: none">
          <img src="https://openclipart.org/download/172030/Merlin2525-Approved-Business-Stamp-1.svg" width="100px" height="100px">
        </div>

        <div class="form-group no-margin text-right" id="submit_button">
          <button type="submit"  class="btn btn-primary waves-effect waves-light" name="raise_time_sheet" value="1" >Submit
          </button>
        </div>

        {{ csrf_field() }}
        <input type="hidden" name="presentWeekNumber" id="presentWeekNumber" value="">
        <input type="hidden" name="presentYear" id="presentYear" value="">
        <input type="hidden" name="actual_week" id="actual_week" value="">
        <input type="hidden" name="actual_year" id="actual_year" value="">
        <input type="hidden" name="employee_payrate_id" id="employee_payrate_id" value=" {{-- $pay_rates->id --}} ">

        <!-- REG HOURS OLD -->
        <input type="hidden" name="get_mon_value_reg" id="get_mon_value_reg" value="">
        <input type="hidden" name="get_tue_value_reg" id="get_tue_value_reg" value="">
        <input type="hidden" name="get_wed_value_reg" id="get_wed_value_reg" value="">
        <input type="hidden" name="get_thu_value_reg" id="get_thu_value_reg" value="">
        <input type="hidden" name="get_fri_value_reg" id="get_fri_value_reg" value="">
        <input type="hidden" name="get_sat_value_reg" id="get_sat_value_reg" value="">
        <input type="hidden" name="get_sun_value_reg" id="get_sun_value_reg" value=""> 
        <!-- OT HOURS OLD -->
        <input type="hidden" name="get_mon_value_ot" id="get_mon_value_ot" value="">
        <input type="hidden" name="get_tue_value_ot" id="get_tue_value_ot" value="">
        <input type="hidden" name="get_wed_value_ot" id="get_wed_value_ot" value="">
        <input type="hidden" name="get_thu_value_ot" id="get_thu_value_ot" value="">
        <input type="hidden" name="get_fri_value_ot" id="get_fri_value_ot" value="">
        <input type="hidden" name="get_sat_value_ot" id="get_sat_value_ot" value="">
        <input type="hidden" name="get_sun_value_ot" id="get_sun_value_ot" value="">

        @if(Entrust::hasRole('student'))
        <input type="hidden" name="employee_id" id="employee_id" value="{{ Auth::user()->id }}">
        @endif

      </form>
  </div>
</div> 

<h3>Approvals Report</h3>

<div class="row"> 
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="pmd-tabs pmd-tabs-bg horizantTabs" role="tabpanel" data-example-id="togglable-tabs">
      <ul id="myTab" class="nav nav-tabs" role="tablist">
        <li role="presentation" class=" nav-item"><a class="nav-link waves-effect waves-gray active" href="#tab_content2" role="tab"  data-toggle="tab" >Week Hours</a>
        </li>
        <li role="presentation" class="nav-item"><a class="nav-link waves-effect waves-gray" href="#tab_content3" role="tab"  data-toggle="tab" >Year Hours</a>
        </li>
      </ul>
      <div id="myTabContent" class="pmd-card-body horizantTabsBodyContainer">
        <div class="tab-content ">
          <div role="tabpanel" class="tab-pane tab-margin active View-TimeSheet" id="tab_content2" aria-labelledby="logged-tab">
            <table class="table table-bordered" cellspacing="0" width="100%">
              <thead>
                <tr >
              
                  <th>Month</th>
                  <th>Week 1</th>
                  <th>Week 2</th>
                  <th>Week 3</th>
                  <th>Week 4</th>
                  <th>Week 5</th>
                  <th>Week 6</th>
                  <th>Total Hours</th>
                </tr>
              </thead>
              <tbody class="scheduleTable">
                @foreach($timesheet_weekly_total as $k=>$timesheet_weekly_totals)
                <tr>
                  <td class="new_event_class">
                      <span class="SchTbtmBrd">
                        <span class="label label-default view_event"> {{ date('M-Y',strtotime('14-'.$timesheet_weekly_totals->month_value.'-'.$timesheet_weekly_totals->year_value)) }}</span>
                      </span>
                  </td>
                  <td>
                  <a  onclick="getWeekwiseDataModel(1,{!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">
                      {{ isset($timesheet_weekly_totals->week1)?$timesheet_weekly_totals->week1:'-' }}
                  </a>
                  </td>
                  <td><a  onclick="getWeekwiseDataModel(2,{!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">{{ isset($timesheet_weekly_totals->week2)?$timesheet_weekly_totals->week2:'-' }}
                  </a>
                  </td>
                  
                  <td><a onclick="getWeekwiseDataModel(3,{!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">{{ isset($timesheet_weekly_totals->week3)?$timesheet_weekly_totals->week3:'-' }}
                  </a></td>
                  <td> <a  onclick="getWeekwiseDataModel(4,{!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">{{ isset($timesheet_weekly_totals->week4)?$timesheet_weekly_totals->week4:'-' }}</a>
                  </td>
                  
                  <td><a onclick="getWeekwiseDataModel(5,{!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">{{ isset($timesheet_weekly_totals->week5)?$timesheet_weekly_totals->week5:'-' }}</a>
                  </td>
                  
                  <td><a  onclick="getWeekwiseDataModel(6,{!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">{{ isset($timesheet_weekly_totals->week6)?$timesheet_weekly_totals->week6:'-' }}</a>
                  </td>
                  
                  <td><a  onclick="getMonthwiseDataModel({!! $timesheet_weekly_totals->month_value !!},{!! $timesheet_weekly_totals->year_value !!})">{{ ($timesheet_weekly_totals->total_reg_hours)+($timesheet_weekly_totals->total_ot_hours) }}
                    </a>
                  </td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          <div role="tabpanel" class="tab-pane tab-margin View-TimeSheet" id="tab_content3" aria-labelledby="year-tab">
            <table class="table table-bordered" id="sum_table">
              <thead>
                <tr>
                  <th>Summary
                   <small>Month-Year</small>
                  </th>
                  @for($i=1;$i<32;$i++)
                  <th class="tablemiddel">{{ $i }} </th>
                  @endfor
                  <th> Total</th>
                </tr>
              </thead>
              <tbody class="scheduleTable"> 
                @foreach($time_sheet_yearly as $k=>$time_sheet_year)
               
                <tr >
                  <td class="new_event_class" rowspan="2">
                    <span class="SchTbtmBrd">
                       <span class="label label-default view_event">{{ date('M-Y',strtotime('10-'.$time_sheet_year->month_value.'-'.$time_sheet_year->year_value))  }}</span>
                    </span>
                  </td>
                  <td>{{ isset($time_sheet_year->day1)?json_decode($time_sheet_year->day1)->WH :'-'}}</td>
                  <td >{{ isset($time_sheet_year->day2)?json_decode($time_sheet_year->day2)->WH : '-' }}</td>
                  <td >{{ isset($time_sheet_year->day3)?json_decode($time_sheet_year->day3)->WH : '-' }}</td>
                  <td >{{ isset($time_sheet_year->day4)?json_decode($time_sheet_year->day4)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day5)?json_decode($time_sheet_year->day5)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day6)?json_decode($time_sheet_year->day6)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day7)?json_decode($time_sheet_year->day7)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day8)?json_decode($time_sheet_year->day8)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day9)?json_decode($time_sheet_year->day9)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day10)?json_decode($time_sheet_year->day10)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day11)?json_decode($time_sheet_year->day11)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day12)?json_decode($time_sheet_year->day12)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day13)?json_decode($time_sheet_year->day13)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day14)?json_decode($time_sheet_year->day14)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day15)?json_decode($time_sheet_year->day15)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day16)?json_decode($time_sheet_year->day16)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day17)?json_decode($time_sheet_year->day17)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day18)?json_decode($time_sheet_year->day18)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day19)?json_decode($time_sheet_year->day19)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day20)?json_decode($time_sheet_year->day20)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day21)?json_decode($time_sheet_year->day21)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day22)?json_decode($time_sheet_year->day22)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day23)?json_decode($time_sheet_year->day23)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day24)?json_decode($time_sheet_year->day24)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day25)?json_decode($time_sheet_year->day25)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day26)?json_decode($time_sheet_year->day26)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day27)?json_decode($time_sheet_year->day27)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day28)?json_decode($time_sheet_year->day28)->WH : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day29)?json_decode($time_sheet_year->day29)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day30)?json_decode($time_sheet_year->day30)->WH : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day31)?json_decode($time_sheet_year->day31)->WH : '-' }}</td>
                  <td  >
                  
                  </td>
                </tr>
                <tr>
                  
                  <td>{{ isset($time_sheet_year->day1)?json_decode($time_sheet_year->day1)->OT :'-'}}</td>
                  <td >{{ isset($time_sheet_year->day2)?json_decode($time_sheet_year->day2)->OT : '-' }}</td>
                  <td >{{ isset($time_sheet_year->day3)?json_decode($time_sheet_year->day3)->OT : '-' }}</td>
                  <td >{{ isset($time_sheet_year->day4)?json_decode($time_sheet_year->day4)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day5)?json_decode($time_sheet_year->day5)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day6)?json_decode($time_sheet_year->day6)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day7)?json_decode($time_sheet_year->day7)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day8)?json_decode($time_sheet_year->day8)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day9)?json_decode($time_sheet_year->day9)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day10)?json_decode($time_sheet_year->day10)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day11)?json_decode($time_sheet_year->day11)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day12)?json_decode($time_sheet_year->day12)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day13)?json_decode($time_sheet_year->day13)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day14)?json_decode($time_sheet_year->day14)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day15)?json_decode($time_sheet_year->day15)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day16)?json_decode($time_sheet_year->day16)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day17)?json_decode($time_sheet_year->day17)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day18)?json_decode($time_sheet_year->day18)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day19)?json_decode($time_sheet_year->day19)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day20)?json_decode($time_sheet_year->day20)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day21)?json_decode($time_sheet_year->day21)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day22)?json_decode($time_sheet_year->day22)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day23)?json_decode($time_sheet_year->day23)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day24)?json_decode($time_sheet_year->day24)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day25)?json_decode($time_sheet_year->day25)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day26)?json_decode($time_sheet_year->day26)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day27)?json_decode($time_sheet_year->day27)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day28)?json_decode($time_sheet_year->day28)->OT : '-' }}</td> 
                  <td>{{ isset($time_sheet_year->day29)?json_decode($time_sheet_year->day29)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day30)?json_decode($time_sheet_year->day30)->OT : '-' }}</td>
                  <td>{{ isset($time_sheet_year->day31)?json_decode($time_sheet_year->day31)->OT : '-' }}</td>
                  <td></td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<button type="button" id="WeeklyDataModelButton" class="btn btn-primary" data-toggle="modal" data-target="#WeeklyDataModel" style="display:none;">
</button>
 <!-- The Modal -->
<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="WeeklyDataModel">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title" id="month_year"></h4>
         {{--  <button type="button" class="close" data-dismiss="modal">&times;</button> --}}
      </div> 
      <div class="modal-body">
        <div class="editor-indent">
          <div id="monthly_table">
              
          </div>
          <table class="timesheet table table-bordered" >
            <thead>
              <tr  id="days_list">
               
              </tr>

            </thead>
              <tbody >
                  <tr id="array_list">
                  </tr>
                  <tr id="array_list1">
                  </tr> 
                  <tr id="array_list_total">
                  </tr>
              </tbody>
          </table>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script src="<?php echo url('/'); ?>/js/sortable/moment.js"></script>
<script type="text/javascript">
  $(document).ready(function(){
    
    // Year Display 
    var d = new Date();
    dd = d.getDate();
    var mm = d.getMonth()+1;
    var year = d.getFullYear(); 
     
    // Current Week Of The Month  Done By Danda Satish
    window.onload = lastdateInit;
    function lastdateInit(){
        var weekNumber_1  = moment().startOf('isoweek').week();
        //document.getElementById("presentWeekNumber").value = weekNumber_1;

        var year = moment().format('YYYY');
        var startOfWeek = moment().startOf('isoweek').toDate();
        var tue = moment(startOfWeek).add(1,'days').toDate(); 
        var wed = moment(startOfWeek).add(2,'days').toDate(); 
        var thu = moment(startOfWeek).add(3,'days').toDate(); 
        var fri = moment(startOfWeek).add(4,'days').toDate(); 
        var sat = moment(startOfWeek).add(5,'days').toDate(); 
        var endOfWeek = moment().endOf('isoweek').toDate();
     
    
        var monDay = moment(startOfWeek).format("DD-MMM-YY");
        var tueDay = moment(tue).format("DD-MMM-YY");
        var wedDay = moment(wed).format("DD-MMM-YY");
        var thuDay = moment(thu).format("DD-MMM-YY");
        var friDay = moment(fri).format("DD-MMM-YY");
        var satDay = moment(sat).format("DD-MMM-YY");
        var sunDay = moment(endOfWeek).format("DD-MMM-YY");
      
        document.getElementById("day1").innerHTML = monDay;
        document.getElementById("day2").innerHTML = tueDay;
        document.getElementById("day3").innerHTML = wedDay;
        document.getElementById("day4").innerHTML = thuDay;
        document.getElementById("day5").innerHTML = friDay;
        document.getElementById("day6").innerHTML = satDay;
        document.getElementById("day7").innerHTML = sunDay;
      
        var actual = moment().format('W');
        var start  = moment(dd, "DD-MM-YY").startOf('isoWeek').format("DD-MMM-YY");
        var end    = moment(dd, "DD-MM-YY").endOf('isoWeek').format("DD-MMM-YY");

        var day1 = document.getElementById("day1").innerHTML;
        var actual_week  = moment(day1, "DD-MMM-YY").startOf('isoWeek').week();
        var actual_year  = moment(day1, "DD-MMM-YY").startOf('isoWeek').year();

        document.getElementById('presentWeek').innerHTML = start +' To '+ end; 
        document.getElementById('presentWeekNumber').value = actual; 
        document.getElementById('presentYear').value = year;
        document.getElementById("actual_week").value = actual_week;
        document.getElementById("actual_year").value = actual_year;

        getWeekData(actual,year);
    }
    
    // Previous Week of The Month Done By Danda Satish
    $('#previousWeek').on('click',function(){

        var presentWeekNumber = document.getElementById('presentWeekNumber').value;


        var remove_week = +presentWeekNumber - 1;
       
        var year = moment().format('YYYY');
        var weekNumber = moment(year).add(+remove_week,'weeks').startOf('isoWeek');
       
        var tue = moment(weekNumber).add(1,'days').toDate(); 
        var wed = moment(weekNumber).add(2,'days').toDate(); 
        var thu = moment(weekNumber).add(3,'days').toDate(); 
        var fri = moment(weekNumber).add(4,'days').toDate(); 
        var sat = moment(weekNumber).add(5,'days').toDate();
        var startOfWeekEnd = moment(year).add(+remove_week,'weeks').endOf('isoWeek'); 
    
        var monDay = moment(weekNumber).format("DD-MMM-YY");
        var tueDay = moment(tue).format("DD-MMM-YY");
        var wedDay = moment(wed).format("DD-MMM-YY");
        var thuDay = moment(thu).format("DD-MMM-YY");
        var friDay = moment(fri).format("DD-MMM-YY");
        var satDay = moment(sat).format("DD-MMM-YY");
        var sunDay = moment(startOfWeekEnd).format("DD-MMM-YY");
    
        document.getElementById("day1").innerHTML = monDay;
        document.getElementById("day2").innerHTML = tueDay;
        document.getElementById("day3").innerHTML = wedDay;
        document.getElementById("day4").innerHTML = thuDay;
        document.getElementById("day5").innerHTML = friDay;
        document.getElementById("day6").innerHTML = satDay;
        document.getElementById("day7").innerHTML = sunDay;
        var day1   = document.getElementById("day1").innerHTML;
        var start  = moment(day1, "DD-MMM-YY").startOf('isoWeek').format("DD-MMM-YY");
        var end    = moment(day1, "DD-MMM-YY").endOf('isoWeek').format("DD-MMM-YY");
        
        var actual_week  = moment(day1, "DD-MMM-YY").startOf('isoWeek').week();
        var actual_year  = moment(day1, "DD-MMM-YY").startOf('isoWeek').year();

        document.getElementById('presentWeek').innerHTML = start +' To '+ end; 
        document.getElementById("presentWeekNumber").value = remove_week;
        document.getElementById('presentYear').value = year;
        document.getElementById("actual_week").value = actual_week;
        document.getElementById("actual_year").value = actual_year;
        $("#weekly_timecard_unsaved_msg").css('display','none');
        getWeekData(actual_week,actual_year);   

    });
   
    
    // Next Week of The Month Done By Danda Satish
    $('#nextWeek').on('click',function(){

      var presentWeekNumber = document.getElementById('presentWeekNumber').value;

      var presentWeek = moment().startOf('isoweek').week();
       if (presentWeek > presentWeekNumber) { 
        var year = moment().format('YYYY');
        var add_week = +presentWeekNumber + 1;

        var weekNumber = moment(year).add(+add_week, 'weeks').startOf('isoweek');
        var tue = moment(weekNumber).add(1,'days').toDate(); 
        var wed = moment(weekNumber).add(2,'days').toDate(); 
        var thu = moment(weekNumber).add(3,'days').toDate(); 
        var fri = moment(weekNumber).add(4,'days').toDate(); 
        var sat = moment(weekNumber).add(5,'days').toDate();
        var startOfWeekEnd = moment(year).add(+add_week, 'weeks').endOf('isoWeek'); 
    
        var monDay = moment(weekNumber).format("DD-MMM-YY");
        var tueDay = moment(tue).format("DD-MMM-YY");
        var wedDay = moment(wed).format("DD-MMM-YY");
        var thuDay = moment(thu).format("DD-MMM-YY");
        var friDay = moment(fri).format("DD-MMM-YY");
        var satDay = moment(sat).format("DD-MMM-YY");
        var sunDay = moment(startOfWeekEnd).format("DD-MMM-YY");
    
        document.getElementById("day1").innerHTML = monDay;
        document.getElementById("day2").innerHTML = tueDay;
        document.getElementById("day3").innerHTML = wedDay;
        document.getElementById("day4").innerHTML = thuDay;
        document.getElementById("day5").innerHTML = friDay;
        document.getElementById("day6").innerHTML = satDay;
        document.getElementById("day7").innerHTML = sunDay;
    
        var day1 = document.getElementById("day1").innerHTML;
        var start  = moment(day1, "DD-MMM-YY").startOf('isoWeek').format("DD-MMM-YY");
        var end    = moment(day1, "DD-MMM-YY").endOf('isoWeek').format("DD-MMM-YY");

        var actual_week  = moment(day1, "DD-MMM-YY").startOf('isoWeek').week();
        var actual_year  = moment(day1, "DD-MMM-YY").startOf('isoWeek').year();
        

        document.getElementById('presentWeek').innerHTML = start +' To '+ end; 
        document.getElementById("presentWeekNumber").value = add_week;
        document.getElementById('presentYear').value = year;
        document.getElementById("actual_week").value = actual_week;
        document.getElementById("actual_year").value = actual_year;
        $("#weekly_timecard_unsaved_msg").css('display','none');

         getWeekData(actual_week,actual_year);

      }else{

        return false;
      }
    });

      
    var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    for (i = new Date().getFullYear() ; i > new Date().getFullYear()-1; i--) {
      $.each(months, function (index, value) {
          $('#month').append($('<option />').val(index+1).html(value + "-" + i));
      });                
    }

     var frm = $('#weeks_wise_working_hours');
         
      frm.submit(function (e) {
          e.preventDefault();

          $("#weekly_timecard_unsaved_msg").css('display','none');
          actual_week = document.getElementById("actual_week").value;
         actual_year = document.getElementById("actual_year").value;
          

          var formData = new FormData(this);
          formData.append('day1', document.getElementById("day1").innerHTML);
          formData.append('day2', document.getElementById("day2").innerHTML);
          formData.append('day3', document.getElementById("day3").innerHTML);
          formData.append('day4', document.getElementById("day4").innerHTML);
          formData.append('day5', document.getElementById("day5").innerHTML);
          formData.append('day6', document.getElementById("day6").innerHTML);
          formData.append('day7', document.getElementById("day7").innerHTML);
          formData.append('total_hours', document.getElementById("total_hours").innerHTML);
          formData.append('total_work_hours',document.getElementById("total_work_hours").innerHTML);
          formData.append('total_ot_hours',document.getElementById("total_ot_hours").innerHTML);
          $.ajax({
              type: frm.attr('method'),
              url:  frm.attr('action'),
              data: formData ,
              processData: false,
              contentType: false,
              success: function (data) {
                $('#weekly_timecard_saved_msg').css('display','inline');
                $('#weekly_timecard_saved_msg').delay(3000).fadeOut(800);
                getWeekData(actual_week,actual_year);
                //window.location.reload();
              },
              error: function (data) {
                $("#weekly_timecard_unsaved_msg").css('display','inline');
                 
              },
          });
      });

      

      frm.on("change", ":input", function() {
        $("#weekly_timecard_unsaved_msg").css('display','inline');
      });


      $(".grid").each(function () {
          $(this).keyup(function () {
              calculateSum();
          });
      });

      $("#sum_table tr:not(:first)  td:nth-last-child(1)").text(function(){
      var t = 0;

      $(this).prevAll().each(function(){ 
          t += parseFloat( $(this).text(), 10 ) || 0;
      });
      return t;
      });

    function getWeekData(id,year){
      var employee_id = $('#employee_id').val();
      $.ajax({
        url:'<?php echo url('timeheet_weekly_data'); ?>',
        data:'id='+id+"&year="+year+"&employee_id="+employee_id,
        
        success: function(data){
          var data1     = $.parseJSON(data);
          if(data1){
            var total_wh = 0;
            if(data1.monday === null || typeof(data1.monday) === 'undefined'){
              $('#monday').val('').removeClass('current_cell');
              $('#monday_ot').val('').removeClass('current_cell');
              $('#mon_total').html('00');
              $('#get_mon_value_reg').val('0');
              $('#get_mon_value_ot').val('0');
            }else{
              var monday    = $.parseJSON(data1.monday);
              $('#monday').val(monday.WH).addClass('current_cell');
              $('#monday_ot').val(monday.OT).addClass('current_cell');
              $('#mon_total').html(+monday.WH + +monday.OT);
              $('#get_mon_value_reg').val(monday.WH);
              $('#get_mon_value_ot').val(monday.OT);
            }if(data1.tuesday === null || typeof(data1.tuesday) === 'undefined'){
              $('#tuesday').val('').removeClass('current_cell');
              $('#tuesday_ot').val('').removeClass('current_cell');
              $('#tue_total').html('00');
              $('#get_tue_value_reg').val('0');
              $('#get_tue_value_ot').val('0');
            }else{
              var tuesday   = $.parseJSON(data1.tuesday);
              $('#tuesday').val(tuesday.WH).addClass('current_cell');
              $('#tuesday_ot').val(tuesday.OT).addClass('current_cell');
              $('#tue_total').html(+tuesday.WH + +tuesday.OT);
              $('#get_tue_value_reg').val(tuesday.WH);
              $('#get_tue_value_ot').val(tuesday.OT);
            }if(data1.wednesday === null || typeof(data1.wednesday) === 'undefined'){
              $('#wednesday').val('').removeClass('current_cell');
              $('#wednesday_ot').val('').removeClass('current_cell');
              $('#wed_total').html('00');
              $('#get_wed_value_reg').val('0');
              $('#get_wed_value_ot').val('0');
            }else{
              var wednesday = $.parseJSON(data1.wednesday);
              $('#wednesday').val(wednesday.WH).addClass('current_cell');
              $('#wednesday_ot').val(wednesday.OT).addClass('current_cell');
              $('#wed_total').html(+wednesday.WH + +wednesday.OT);
              $('#get_wed_value_reg').val(wednesday.WH);
              $('#get_wed_value_ot').val(wednesday.OT);
            }if(data1.thursday === null || typeof(data1.thursday) === 'undefined'){
              $('#thursday').val('').removeClass('current_cell');
              $('#thursday_ot').val('').removeClass('current_cell');
              $('#thu_total').html('00');
              $('#get_thu_value_reg').val('0');
              $('#get_thu_value_ot').val('0');
            }else{
              var thursday  = $.parseJSON(data1.thursday);
              $('#thursday').val(thursday.WH).addClass('current_cell');
              $('#thursday_ot').val(thursday.OT).addClass('current_cell');
              $('#thu_total').html(+thursday.WH + +thursday.OT);
              $('#get_thu_value_reg').val(thursday.WH);
              $('#get_thu_value_ot').val(thursday.OT);
            }if(data1.friday === null || typeof(data1.friday) === 'undefined'){
              $('#friday').val('').removeClass('current_cell');
              $('#friday_ot').val('').removeClass('current_cell');
              $('#fri_total').html('00');
              $('#get_fri_value_reg').val('0');
              $('#get_fri_value_ot').val('0');
            }else{
              var friday    = $.parseJSON(data1.friday);
              $('#friday').val(friday.WH).addClass('current_cell');
              $('#friday_ot').val(friday.OT).addClass('current_cell');
              $('#fri_total').html(+friday.WH + +friday.OT);
              $('#get_fri_value_reg').val(friday.WH);
              $('#get_fri_value_ot').val(friday.OT);
            }if(data1.saturday === null || typeof(data1.saturday) === 'undefined'){
              $('#saturday').val('').removeClass('current_cell');
              $('#saturday_ot').val('').removeClass('current_cell');
              $('#sat_total').html('00');
              $('#get_sat_value_reg').val('0');
              $('#get_sat_value_ot').val('0');
            }else{
              var saturday  = $.parseJSON(data1.saturday);
             $('#saturday').val(saturday.WH).addClass('current_cell');
             $('#saturday_ot').val(saturday.OT).addClass('current_cell');
             $('#sat_total').html(+saturday.WH + +saturday.OT);
             $('#get_sat_value_reg').val(saturday.WH);
             $('#get_sat_value_ot').val(saturday.OT);
            }if(data1.sunday === null || typeof(data1.sunday) === 'undefined'){
              $('#sunday').val('').removeClass('current_cell');
              $('#sunday_ot').val('').removeClass('current_cell');
              $('#sun_total').html('00');
              $('#get_sun_value_reg').val('0');
              $('#get_sun_value_ot').val('0');
            }else{
              var sunday    = $.parseJSON(data1.sunday);
              $('#sunday').val(sunday.WH).addClass('current_cell');
              $('#sunday_ot').val(sunday.OT).addClass('current_cell');
              $('#sun_total').html(+sunday.WH + +sunday.OT);
              $('#get_sun_value_reg').val(sunday.WH);
              $('#get_sun_value_ot').val(sunday.OT);
            }if(data1.total_hours != null){
              $('#total_hours').html(data1.total_hours);
            }if(data1.total_hours == null){
              $('#total_hours').html('00');
            }if(data1.total_work_hours != null){
              $('#total_work_hours').html(data1.total_work_hours);
            }if(data1.total_work_hours == null){
              $('#total_work_hours').html('00');
            }if(data1.total_ot_hours != null){
              $('#total_ot_hours').html(data1.total_ot_hours);
            }if(data1.total_ot_hours == null){
              $('#total_ot_hours').html('00');
            }if(data1.work_report != null){
              $('#work_report').val(data1.work_report);  
            }if(data1.work_report == null){
              $('#work_report').val('');
            }if(data1.client_attachmnet != null ){
              $('#client_docs').hide();
              $('#client_docs_view').show();
              $('#client_docs_view').val(data1.client_attachmnet);
              $("#DownloadTimeSheet").attr('href', '{{ url('downloadClientSheet') }}/'+data1.client_attachmnet);
            }if(data1.client_attachmnet == ""){
              $('#client_docs').show();
              $('#client_docs_view').hide();
            }if(data1.approved_status == 1 || data1.approved_status == 0){
              $("input").each(function () {
                $(this).attr("disabled","disabled");
              });
             $('#work_report').attr("disabled","disabled");
             $('#submit_button').hide();
             $('#approved_button').show();
            }if(data1.approved_status != 1){
             $("input").each(function () {
              $(this).removeAttr("disabled");
              });
              $('#work_report').removeAttr("disabled");
              $('#submit_button').show();
              $('#approved_button').hide();
            }
          }else{
            $('#monday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#tuesday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#wednesday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#thursday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#friday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#saturday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#sunday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#monday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#tuesday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#wednesday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#thursday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#friday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#saturday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#sunday_ot').val('').removeAttr('disabled').css('cursor','auto')
                            .removeClass('current_cell');
            $('#total_hours').html('00');
            $('#work_report').val('');
            $('#mon_total').html('00');
            $('#tue_total').html('00');
            $('#wed_total').html('00');
            $('#thu_total').html('00');
            $('#fri_total').html('00');
            $('#sat_total').html('00');
            $('#sun_total').html('00');
            $('#get_mon_value_reg').val('0');
            $('#get_tue_value_reg').val('0');
            $('#get_wed_value_reg').val('0');
            $('#get_thu_value_reg').val('0');
            $('#get_fri_value_reg').val('0');
            $('#get_sat_value_reg').val('0');
            $('#get_sun_value_reg').val('0');
            $('#get_mon_value_ot').val('0');
            $('#get_tue_value_ot').val('0');
            $('#get_wed_value_ot').val('0');
            $('#get_thu_value_ot').val('0');
            $('#get_fri_value_ot').val('0');
            $('#get_sat_value_ot').val('0');
            $('#get_sun_value_ot').val('0');
            $('#total_work_hours').html('00');
            $('#total_ot_hours').html('00');
            $('#client_docs').show();
            $('#client_docs_view').hide();
            $('#DownloadTimeSheet').attr('href','#');
            $("input").each(function () {
              $(this).removeAttr("disabled");
            });
            $('#work_report').removeAttr("disabled");
            $('#submit_button').show();
            $('#approved_button').hide();
          }
        },
        error:function(){
          $('#monday').val('');
          $('#tuesday').val('');
          $('#wednesday').val('');
          $('#thursday').val('');
          $('#friday').val('');
          $('#saturday').val('');
          $('#sunday').val('');
          $('#monday_ot').val('');
          $('#tuesday_ot').val('');
          $('#wednesday_ot').val('');
          $('#thursday_ot').val('');
          $('#friday_ot').val('');
          $('#saturday_ot').val('');
          $('#sunday_ot').val('');
          $('#total_hours').html('00');
          $('#work_report').val('');
          $('#mon_total').html('00');
          $('#tue_total').html('00');
          $('#wed_total').html('00');
          $('#thu_total').html('00');
          $('#fri_total').html('00');
          $('#sat_total').html('00');
          $('#sun_total').html('00');
          $('#get_mon_value_reg').val('0');
          $('#get_tue_value_reg').val('0');
          $('#get_wed_value_reg').val('0');
          $('#get_thu_value_reg').val('0');
          $('#get_fri_value_reg').val('0');
          $('#get_sat_value_reg').val('0');
          $('#get_sun_value_reg').val('0');
          $('#get_mon_value_ot').val('0');
          $('#get_tue_value_ot').val('0');
          $('#get_wed_value_ot').val('0');
          $('#get_thu_value_ot').val('0');
          $('#get_fri_value_ot').val('0');
          $('#get_sat_value_ot').val('0');
          $('#get_sun_value_ot').val('0');
          $("input").each(function () {
              $(this).removeAttr("disabled");
          });
          $('#work_report').removeAttr("disabled");
          $('#submit_button').show();
          $('#approved_button').hide();
        },
      });
    }

  });

  $(document).on('keyup', 'input[type="number"]', function () {
        // var _this = $(this);
        // var min = parseInt(_this.attr('min')) || 1; // if min attribute is not defined, 1 is default
        // var max = parseInt(_this.attr('max')) || 24; // if max attribute is not defined, 24 is default
        // var val = parseInt(_this.val()) || (min - 1); // if input char is not a number the value will be (min - 1) so first condition will be true
        // if(val < min)
        //     _this.val( min );
        // if(val > max)
        //     _this.val( max );
    });



  function calculateSum() {
      var sum = 0;
      
      $(".grid").each(function () {
          if (!isNaN(this.value) && this.value.length != 0) {
              sum += parseFloat(this.value);
          }
      });
      
      var sumQ = [];
      for (var i=1; i<=7; i++) {
          sumQ[i] = 0;
          $('td:nth-child('+(i+1)+')').find(".grid").each(function () {
              if (!isNaN(this.value) && this.value.length != 0) {
                  var _this = $(this);
                  var min = parseInt(_this.attr('min')) || 1; 
                  var max = parseInt(_this.attr('max')) || 24;  
                  var val = parseInt(_this.val()) || (min - 1);  
                  if(val < min)
                      _this.val( min );
                  if(val > max)
                      _this.val( max );  
                  sumQ[i] += parseFloat(this.value);
              }
          });
          $(".span7").find('td').eq(i).html(sumQ[i]);

           calculateRowSum();
      }
      // Total Hours Count
      calculateTotal(); 
  }
  function calculateRowSum(){
    $('.mytable tr:has(td):not(:last)').each(function(){
      var sum = 0; 
      $(this).find('td').each(function(){
         sum += parseFloat($(this).find('.grid').val()) || 0;
      });
       $(this).find('td:last').html(sum);
    });
  }
  function calculateTotal(){
    var sumT = [];
        sumT[i] = 0;
        $('td').find('.grid').each(function () {
           var combat = $(this).val();
           if (!isNaN(combat) && combat.length !== 0) {
               sumT[i] += parseFloat(combat);
           }
        });
      $('.total_hours').html(sumT[i]);
  }
  function isNumberKey(evt){
    var charCode = (evt.which) ? evt.which : event.keyCode
    if (charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
  }
</script>

<script type="text/javascript">
 
 function getWeekwiseDataModel(week,month,year){
       $.ajax({
           url: '<?php echo url('/getDataWeekAjaxinMonth');?>',
           data:'week='+week+'&month='+month+'&year='+year,
           success: function(result){
               // $(".bs-example-modal-lg").modal({
               //     backdrop: 'static',
               //     keyboard: false
               // }); 
               $("#WeeklyDataModelButton").trigger('click');
               var d = new Date();
                formattedMonth = moment(result.month, 'MM').format('MMM');
                 var s = new Date(result.start);
                 var l = new Date(result.last);
                 start_date = s.getDate();
                 last_date = l.getDate();
               $('#month_year').html(formattedMonth + '-' + year);
              if (Object.keys(result.arrayName).length) {
                console.log(typeof(result.arrayName));
                var row = $('#days_list');
                var rowData = $('#array_list');
                var rowData1 = $('#array_list1');
                var rowDataTotal = $('#array_list_total');
                row.empty();
                rowData.empty();
                rowData1.empty();
                rowDataTotal.empty();
                $('#monthly_table').empty();
                row.append($('<th>').html(start_date + formattedMonth + '-' + last_date + formattedMonth));
                rowData.append($('<td>').html('REG'));
                rowData1.append($('<td>').html('OT'));
                rowDataTotal.append($('<td>').html('Total'));

                 keys = Object.keys(result.arrayName),
                  i, len = keys.length;

                keys.sort();

                for (i = 0; i < len; i++) {
                  k = keys[i];
                  row.append($('<th>').html(k)); 
                  var values = $.parseJSON(result.arrayName[k]);
                  rowData.append($('<td>').html(values.WH));  
                  rowData1.append($('<td>').html(values.OT));
                  rowDataTotal.append($('<td>').html(+values.WH + +values.OT));
                }

              /*  $.each(result.arrayName, function(key, value) {
               
                  row.append($('<th>').html(key)); 
                  var values = $.parseJSON(value);
                  rowData.append($('<td>').html(values.WH));  
                  rowData1.append($('<td>').html(values.OT));
                  rowDataTotal.append($('<td>').html(+values.WH + +values.OT));
                }); */              
              }
            },
          error:function(result){
            $(".bs-example-modal-lg").modal({
                   backdrop: 'static',
                   keyboard: false
            }); 
            $('#monthly_table').empty();
             var row = $('#days_list');
              var rowData = $('#array_list');
              var rowData1 = $('#array_list1');
              var rowDataTotal = $('#array_list_total');
              row.empty();
              rowData.empty();
              rowData1.empty();
              rowDataTotal.empty();
              rowData.append($('<h1>').html('NO Dates Found'));
          }
       });
   }
   function getMonthwiseDataModel(month,year){
      $('#monthly_table').empty(); 
       $.ajax({
           url: '<?php echo url('/getDataMonthAjaxinMonth');?>',
           data:'&month='+month+'&year='+year,
           success: function(result){
                   $(".bs-example-modal-lg").modal({
                   backdrop: 'static',
                   keyboard: false
            }); 
              var row = $('#days_list');
              var rowData = $('#array_list');
              var rowData1 = $('#array_list1');
              var rowDataTotal = $('#array_list_total');
              row.empty();
              rowData.empty();
              rowData1.empty();
              rowDataTotal.empty();    
              $('#monthly_table').html(result);    
            }
       });
   }
</script>
@stop

