@extends('layouts.default') 

@section('title','Assign Consultant Payrates')

@section('new_button')

<div class="searchBox mr-2">

   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}

    <span class="search-icn"><i class="material-icons">search</i></span>

    <span class="form-controlBrd"></span>

</div>

	<a href="{!! route('consultnatpayrates.create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Consultant Payrates"><i class="material-icons left">add</i>{{ __('Pay rates') }} </a>

@endsection

@section('content')



<!-- page content -->

<table class="table  table-show table-bordered table-filter">

	<thead>

		<tr>

			<th>Consultant</th>

			<th>Vendor Company</th>

			<th>Vendor Payrate - Reg</th>

			<th>Vendor Payrate - OT</th>

			<th>Payrate Type</th>

			<th>From Hours</th>

			<th>To Hours</th>

			<th>From Date</th>

			<th>To Date</th>

			<th>Consultant Payrate - Reg</th>

			<th>Consultant Payrate - OT</th>

			<th>Employer Payrate - Reg</th>

			<th>Employer Payrate - OT</th>

		</tr>

	</thead>



	<tbody>

		@foreach ($list as $li)

			<tr>

				<td>{{ $li->consultant?->name }}</td>

				<td>{{ $li->vendor?->name }}</td>

				<td>{{ $li->vendor_payrate_reg }}</td>

				<td>{{ $li->vendor_payrate_ot }}</td>

				<td>{{ $li->rate_type }}</td>

				<td>{{ $li->from }}</td>

				<td>{{ $li->to }}</td>

				<td>{{ Carbon\Carbon::parse($li->from_date)->format($date_format) }}</td>

				<td>{{ Carbon\Carbon::parse($li->to_date)->format($date_format) }}</td>

				@if($li->rate_type == 'fixed')

				<td>{{ $li->reg_rate }}</td>

				<td>{{ $li->ot_rate }}</td>

				<td></td>

				<td></td>

				@else

				<td>{{ $li->percent_reg }} {{ ($li->consultant_percentage_reg != '')?'('.$li->consultant_percentage_reg.'%)':'' }}</td>

				<td>{{ $li->percent_ot }} {{ ($li->consultant_percentage_ot != '')?'('.$li->consultant_percentage_ot.'%)':'' }}</td>

				<td>{{ $li->company_payrate_reg }} {{ ($li->company_payrate_reg != '')?'('.$li->company_percentage_reg.'%)':'' }}</td>

				<td>{{ $li->company_payrate_ot }} {{ ($li->company_payrate_reg != '')?'('.$li->company_percentage_ot.'%)':'' }}</td>

				@endif			

			</tr>

		@endforeach

		@if(count($list) == 0)
		
			<tr>
				<td class="text-center" colspan="13">No Data</td>
			</tr>

		@endif

	</tbody>

</table>

<!-- /page content -->



@endsection