@extends('layouts.default')
@section('title', $title)
@section('new_button')
@if($meeting->organised_by == auth()->user()->id && $meeting->status != 3)
<a href="/meetings/{{ $meeting->id }}/edit" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
            class="material-icons left"> create </i>Edit Meeting
    </a>
@endif
<a href="{!! route('meetings.index') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> list </i>My Meetings List
</a>
@endsection
@section('content')
<style>
    .right-bar {
        border-right: solid blue 1px;
    }
</style>

<!-- page content -->
<div class="card">
    <h3 style="text-decoration: underline;">Meeting Info</h3>
    <div class="row mb-3">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Organised By:-</strong> {{ ucfirst($meeting->organiser->name) }}
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Meeting Topic:-</strong> {{ ucfirst($meeting->subject) }}
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Meeting On:-</strong> {{ Date::parse($meeting->date)->format($date_format)  }}
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Meeting Timings & Duration:-</strong> {{ $meeting->time.':'.$meeting->time1 }} {{ ($meeting->time2==1)?'AM':'PM' }} {{ $meeting->duration }}min
        </div>
    </div>

    <h3 style="text-decoration: underline;">Participants</h3>
    <div class="row mb-3">
    @foreach ($mparticipants as $p)
        @if($p->user_id != auth()->user()->id)
        <div class="col-lg-4 col-md-4 col-sm-12 right-bar">
            <span class="pull-left">{{ ucwords($p->user->name) }} <input type="hidden" name="pids[]"
                    value="{{ $p->user_id }}" disabled /></span>
            <span class="pull-right"> {{ ($p->status == 1)?'Attended':'Not attended' }} <input type="checkbox" name="sts[]" value="{{ $p->user_id }}" @if($p->status == 1) checked @endif disabled /></span>
        </div>
        @endif
    @endforeach
    </div>

    <h3 style="text-decoration: underline;">Meeting Agenda</h3>
    <div class="row pl-3 mb-3">
        {!! $meeting->agenda !!}
    </div>

    <h3 style="text-decoration: underline;">Discussion Points</h3>
    <div class="row pl-3 mb-3">
        {!! $meeting->dpoints !!}
    </div>

    <h3 style="text-decoration: underline;">Issue Statements</h3>
    @foreach ($issues as $key=>$issue)
        @if($meeting->organised_by == auth()->user()->id)
        <h4>Issue Statement {{ $key+1 }}</h4>
        <div class="row pl-3">
            <div class="col-md-3 col-lg-3 col-sm-12">
                {{ ucwords($issue->user->name) }}
            </div>
            <div class="col-md-6 col-lg-6 col-sm-12">
                <div class="row"><strong>Issue Statement:-</strong> {{ ucfirst($issue->issue) }}</div>
                <div class="row"><strong>Solution Statement:-</strong> {{ ucfirst($issue->solution) }}</div>
            </div>
            <div class="vol-lg-3 col-md-3 col-sm-12">
                <strong>Status:-</strong> {{ ($issue->status==1)?'Yes':'No' }}
            </div>
        </div>
        @else
            @if($issue->user_id == auth()->user()->id)
            <h4>Issue Statement {{ $key+1 }}</h4>
            <div class="row pl-3">
                <div class="col-md-3 col-lg-3 col-sm-12">
                    {{ ucwords($issue->user->name) }}
                </div>
                <div class="col-md-6 col-lg-6 col-sm-12">
                    <div class="row"><strong>Issue Statement:-</strong> {{ ucfirst($issue->issue) }}</div>
                    <div class="row"><strong>Solution Statement:-</strong> {{ ucfirst($issue->solution) }}</div>
                </div>
                <div class="vol-lg-3 col-md-3 col-sm-12">
                    <strong>Status:-</strong> {{ ($issue->status==1)?'Yes':'No' }}
                </div>
            </div>
            @endif
        @endif
    @endforeach
</div>
<!-- /page content -->
@stop