@extends('layouts.default')
@section('title', 'Meetings List - '.count($list))
@section('header-links')
    @include('includes.headers.meetings')
@endsection
@section('new_button')
<a title="Meeting Analytics" href="{{ route('meetings.analytics') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> analytics </i> Meeting Analytics
</a>
<a href="{!! route('meetings.create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> add </i> New Meeting
</a>
@endsection
<style>
    .table tbody tr td:last-child {
        white-space: nowrap;
    }

    .green{
        color: green !important;
    }

    .red{
        color: red !important;
    }
</style>
@section('content')
<!-- page content -->
<script src="https://cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>

<div class="right_col" role="main">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <table class="table table-show table-striped table-bordered table-responsive dt-responsive nowrap jambo_table table-filter"
                cellspacing="0" id="abcd">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Time & Duration</th>
                        <th>Topic</th>
                        <th>Venue</th>
                        <th>Conduct By</th>
                        <th>Participants</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($list as $li)
                        <tr>
                            <td>{{ Date::parse($li->date)->format(env('APP_DATE'))  }}</td>
                            <td>{{ $li->time }}:{{ $li->time1 }} {{ ($li->time2==1)?'AM':'PM' }} @if($li->duration!='') , {{ $li->duration  }}min @endif</td>
                            <td title="{{ ucwords($li->subject) }}"><a title="View Details" href="{{ url('/meetings') }}/{{ $li->id }}">{{ ucwords($li->subject) }}</a></td>
                            <td>
                                @if($li->venue == 1)
                                    Conference Room
                                @else
                                    Online
                                @endif
                            </td>
                            <td>{{ ucwords($li->organiser->name) }}</td>
                            <td>                                
                                <div class="dropdown">
                                    <button class="btn btn-xs btn-default dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown"
                                        aria-haspopup="true" aria-expanded="false">
                                        Participants
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @foreach ($li->participants as $p)
                                        @php
                                            if($p->status == 1) {
                                                $clr = 'green';
                                            } else {
                                                $clr = 'red';
                                            }
                                        @endphp
                                        <a class="dropdown-item {{ $clr }}">{{ $p->user->name }}</a>
                                        @endforeach
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($li->status == 1)
                                    <a class="btn btn-xs btn-info">Scheduled</a>
                                @elseif($li->status == 2)
                                    <a class="btn btn-xs btn-warning">Mail Sent</a>
                                @else
                                    <a class="btn btn-xs btn-success">Completed</a>
                                @endif
                            </td>
                            <td>    
                                <a title="View Details" href="{{ url('meetings') }}/{{ $li->id }}"
                                    class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">visibility</i></a>   
                                @if($li->organised_by == auth()->user()->id)
                                <a title="Copy Meeting" onclick="return confirm('Are you sure? You want to copy the same meeting')" href="{{ route('meetings.copy', ['id'=>$li->id]) }}"
                                    class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">copy_all</i></a>
                                @endif                         
                                @if($li->status == 1)
                                    @if($li->organised_by == auth()->user()->id)
                                    <a title="Edit" href="{{ url('meetings') }}/{{ $li->id }}/edit"
                                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                    @endif                                    
                                @elseif($li->status == 2)
                                    @if($li->organised_by == auth()->user()->id)
                                    <a title="Edit" href="{{ url('meetings') }}/{{ $li->id }}/edit"
                                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                    @endif                                    
                                @elseif($li->status == 3)
                                    <a title="Meeting Completed"
                                        class="btn btn-outline-success btn-circle-iconic btn34"> <i class="material-icons" disabled>check</i></a>                                    
                                @elseif($li->status != 3 && $li->organised_by == auth()->user()->id)
                                    <a title="Edit" href="{{ url('meetings') }}/{{ $li->id }}/edit"
                                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    @if(count($list) == 0)
                    <tr>
                        <td colspan="8" class="text-center">No Data</td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
@stop