@extends('layouts.default')
@section('title', 'Schedule meeting')
@section('header-links')
    @include('includes.headers.meetings')
@endsection
@section('new_button')
<a href="{!! route('meetings.index') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> list </i>My Meetings List
</a>
@endsection
@section('content')
<style>
    .rdiv {
        border: 1px #CCC solid;
        padding-top: 10px;
        
        box-shadow:
            inset 0px 11px 8px -10px #CCC,
            inset 0px -11px 8px -10px #CCC;
    }
</style>
<!-- page content -->
<div class="card">
    {{ Form::open(['route'=>'meetings.store', 'method'=>'POST', 'role'=>'form', 'id'=>'createForm']) }}
    <legend>Meeting Info</legend>
    <div class="row">
        <div class="col-md-3">
            {{ Form::textGroup('subject', 'Meeting Topic', null, ['id'=>'subject', 'required'=>'required']) }}
        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            {{ Form::selectGroup('venue', 'Select Venue', $venues, 1, ['class'=>'selectpicker']) }}
        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            {{ Form::textGroup('number', 'Meeting No.', 'MOM-0'.($number), ['id'=>'number', 'required'=>'required', 'readonly'] ) }}
        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            {{ Form::textGroup('organised_by', 'Organised By', ucwords(auth()->user()->name), ['id'=>'organise', 'readonly']) }}
        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            {{ Form::textGroup('date', 'Date', '',['id' => 'todaydate', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'required'=>'required', 'placeholder'=>'yyyy-mm-dd'],'') }}
        </div>
        
        <div class="col-md-3 col-lg-3 col-sm-12">
            <small>Time {{ redStar() }} (Hours & Minutes)</small>
            <div class="row">
                <div class="col-md-4 col-lg-4 col-sm-12">
                    @php
                    $hours = 12;
                    @endphp
                    <select name="time1" id="" class="selectpicker">
                        @for ($i = 1; $i <= $hours; $i++)
                            <option value="{{ $i }}" @if($i==12) selected @endif>{{ $i }}</option>                            
                        @endfor
                    </select>
                </div>
                <div class="col-md-4 col-lg-4 col-sm-12">
                    @php
                    $mins = 59;
                    @endphp
                    <select name="time2" id="" class="selectpicker">
                        @for ($i = 0; $i <= $mins; $i++) 
                            <option value="{{ $i }}">{{ $i }}</option>
                        @endfor
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-4 col-lg-4 col-sm-12">
            <div class="row">
                <div class="col-md-6 col-lg-6 col-sm-12 pt-4">
                    {{ Form::radio('time3', 1) }} AM
                    {{ Form::radio('time3', 2, true) }} PM
                </div>
                <div class="col-md-6 col-lg-6 col-sm-12">
                    <small>Select Duration (Min)</small>
                    {{ Form::selectRange('duration', 1, 200, 30, ['class'=>'selectpicker', 'title'=>'Select Venue']) }}
                </div>
            </div>
            
        </div>
    </div>

    <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
        <h3>Recurring</h3>
        <div class="row">
            <div class="col-md-4 pt-4">
                <input type="checkbox" name="weeks[]" value="1" /> Mon
                <input type="checkbox" name="weeks[]" value="2" /> Tue
                <input type="checkbox" name="weeks[]" value="3" /> Wed
                <input type="checkbox" name="weeks[]" value="4" /> Thu
                <input type="checkbox" name="weeks[]" value="5" /> Fri
                <input type="checkbox" name="weeks[]" value="6" /> Sat
                <input type="checkbox" name="weeks[]" value="7" /> Sun
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('rdate', 'Recurring End Date', 'calendar',['id' => 'rdate', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'placeholder'=>'yyyy-mm-dd'],'', 'col-md-12') }}
            </div>
        </div>
    </div>
    
    <div class="col-md-12 col-lg-12 col-sm-12 pl-0 mt-2">
        <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
            <div class="col-md-3 col-lg-3 col-sm-12 pl-0" id="parts">
                <small>Select Participants</small>
                {{ Form::select('participants[]', $participants, null, ['class'=>'selectpicker', 'multiple', 'title'=>'Select Participants', 'id'=>'partsSelect', 'data-live-search'=>'true']) }}
            </div>
        </div>
        <div class="col-md-12 col-lg-12 col-sm-12 p-0 mt-3 mb-3 pt-2">
            <h6><u>Participants:</u></h6>
            <div class='row' id="usersDiv"> <div class="col-lg-3 col-md-3 col-sm-3">No one selected</div></div>
        </div>
    </div>

    <div class="row">
        <h3 class="pl-3 mt-4">Meeting Agenda</h3>
        <div class="form-groupTextArea col-md-12">
            {!! Form::textarea('agenda', '', ['class' => 'form-ControlTextArea', 'id'=>'agenda']) !!}
        </div>
        <h3 class="pl-3 mt-2">Discussion Points</h3>
        <div class="form-groupTextArea col-md-12">
            {!! Form::textarea('dpoints', '', ['class' => 'form-ControlTextArea', 'id'=>'dpoints']) !!}
        </div>
    </div>

    <div class="row pl-3 pr-3">
        <h3 class="pl-0 mt-4">Issues Statements</h3>
        <div id="issuesDiv" class="col-md-12 col-sm-12 col-lg-12 ml-0 pl-0 pr-0">
            <div class="col-md-12 col-lg-12 card" style="display: inline-flex;">
                <div class="col-md-12 col-lg-12 col-sm-12" style="display: inline-flex;">
                    <div class="col-md-3 col-lg-3 col-sm-12 pl-0" style="display: inline-flex;">
                        <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
                            <div class="col-md-12 col-lg-12 col-sm-12 pl-0 mb-4">
                                {{ Form::selectGroup('rparticipants[]', 'Participant', $participants, null, ['class'=>'selectpicker rpselect', 'id'=>'select1', 'onchange'=>'changeRadio(1)', 'data-live-search'=>'true']) }}
                            </div>
                            <div class="form-group"> <input class="form-control consultant1" name="" type="text" value="">
                                <label for="" class="form-label">Consultant Name</label> <span class="form-controlBrd"></span> 
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-12 pl-0">
                        <div class="form-group"> <input class="form-control has-value issue1" name="" type="text" value="">
                            <label for="" class="form-label lblissue1">Issue Statement</label> <span
                                class="form-controlBrd"></span> </div>
                        <div class="form-group"> <input class="form-control has-value solution1" name="" type="text" value="">
                            <label for="]" class="form-label lblsolution1">Solution Statement</label> <span
                                class="form-controlBrd"></span> </div>
                    </div>
                    <div class="col-md-2 col-lg-2 col-sm-12 mt-3"> 
                        <label for="">Resolved ?</label>
                        <p> <input name="" type="radio" value="1" class="1"> Yes</p>
                        <p> <input name="" type="radio" value="0" class="1" selected> No</p>
                    </div>
                </div>
            </div>
        </div>
        <div id="issuesDiv" class="col-md-12 col-sm-12 col-lg-12 ml-0 pl-0 pr-0"></div>
        <div class="col-lg-12 col-md-12 col-sm-12 pr-0">
            {{ Form::button('Add Row', ['class'=>'btn btn-primary pull-right', 'onclick'=>'addRow()']) }}
        </div>
    </div>

    <div class="form-group no-margin text-right mt-3">
        <a href="{{ url('/home') }}" class="btn mr-3 btn-default waves-effect waves-gray">Cancel</a>
        <button type="submit" class="btn btn-primary waves-effect waves-light" name="draft" value="1">Save</button>
        <button type="submit" class="btn btn-primary waves-effect waves-light" name="send_mail" value="1">Save <small>and Send Mail</small></button>
    </div>
    {{ csrf_field() }}
    </form>

</div>
<!-- /page content -->

@include('includes.datepicker')

<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>
{{ Form::hidden('fcontrol', '', ['id'=>'fcontrol']) }}
<script>
    var config = {};
    config.toolbarGroups = [
    { name: 'basicstyles', groups: [ 'basicstyles'] },
    { name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align'] },
    { name: 'styles' },
    { name: 'colors' },
    ];
    
	CKEDITOR.replace( 'agenda', config);
    CKEDITOR.replace('dpoints', config);
    
    var today = new Date();
    $('#todaydate').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
    $('#todaydate').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        clearBtn: true,
        endDate: today,
        minDate: today,
    });
    $('#rdate').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
    $('#rdate').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        clearBtn: true,
        endDate: today,
        minDate: today,
    });
    $('#timepicker').timepicker();

    $("#partsSelect").on('change', function() {
        var participants = $("#partsSelect").val();
        $.ajax({
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '{{ route('participants') }}',
            type: 'post',
            data: 'ids='+participants,
            success: function(result) {
                $("#usersDiv").html('');
                $(result).each(function( index, value ) {
                    var item = '<div class="col-md-3 col-lg-3 col-sm-3" style="border-right: solid blue 1px;"><span class="pull-left">'+value['name']+'<input type="hidden" name="pids[]" value="'+value['id']+'" /></span> <span class="pull-right"><b id="sts'+value['id']+'">Not Attended </b> <input type="checkbox" name="sts[]" value="'+value['id']+'" onchange="statusChange('+value['id']+')" id="chk'+value['id']+'" /></span></div>';
                    $("#usersDiv").append(item);
                });
            }
        });
    });

    function statusChange(id) {
        if($("#chk"+id).prop("checked") == true){
            $("#sts"+id).html('Attended');
        }
        else if($("#chk"+id).prop("checked") == false){
            $("#sts"+id).html('Not Attended');
        }
    }

    /* Adding New Row */
    function addRow() {
    var newDivId = Math.floor(Math.random() * 100);
    var newpart = '<select title="Select Participant" class="selectpicker rpselect" id="select'+newDivId+'" name="rparticipants[]" onchange="changeRadio('+newDivId+')">@foreach($participants as $c=>$part)<option value="{{ $c }}">{{ $part }} </option>@endforeach </select>';
    var newstd = '<div class="form-group"> <input class="form-control has-value consultant'+newDivId+'" name="" type="text" value=""> <label for="" class="form-label">Consultant Name</label> <span class="form-controlBrd"></span> </div>';
    
    var newRow  ='<div class="col-md-12 col-lg-12 card" style="display: inline-flex;" id="div'+newDivId+'">';
        newRow +='<div class="col-md-12 col-lg-12 col-sm-12" style="display: inline-flex;">';
        newRow +='<div class="col-md-3 col-lg-3 col-sm-12 pl-0" style="display: inline-flex;">';
        newRow +='<div class="col-md-12 col-lg-12 col-sm-12 pl-0">';
        newRow +='    <div class="col-md-12 col-lg-12 col-sm-12 pl-0 mb-4">';
        newRow +='      <small> Select Participant</small>';
        newRow +=       newpart;
        newRow +='    </div>';
        newRow +='    <div class="col-md-12 col-lg-12 col-sm-12 pl-0">';
        newRow +=       newstd;
        newRow +='    </div>';
        newRow +='</div>';
        newRow +='</div>';
        newRow +='    <div class="col-md-6 col-lg-6 col-sm-12 pl-0">';
        newRow +='       <div class="form-group">';
        newRow +='           <input class="form-control has-value issue'+newDivId+'" name="" type="text" value="">';
        newRow +='           <label for="" class="form-label lblissue'+newDivId+'">Issue Statement</label>';
        newRow +='           <span class="form-controlBrd"></span>';
        newRow +='       </div>';
        newRow +='       <div class="form-group">';
        newRow +='           <input class="form-control has-value solution'+newDivId+'" name="" type="text" value="">';
        newRow +='           <label for="]" class="form-label lblsolution'+newDivId+'">Solution Statement</label>';
        newRow +='           <span class="form-controlBrd"></span>';
        newRow +='       </div>';
        newRow +='    </div>';
        newRow +='    <div class="col-md-2 col-lg-2 col-sm-12 mt-3">';
        newRow +='          <label>Resolved ?</label>';
        newRow +='      <p> <input name="" type="radio" value="1" class="'+newDivId+'" /> Yes </p>';
        newRow +='      <p> <input name="" type="radio" value="0" class="'+newDivId+'" selected /> No </p>';
        newRow +='    </div>';
        newRow +='    <div class="col-md-1 col-lg-1 col-sm-12 mt-3">';
        newRow +=       '<button class="btn btn-xs btn-outline-info pull-right" onclick="removeDiv('+newDivId+')">Remove Row</button>'; 
        newRow +='    </div>';
        newRow +='</div>';
        newRow +='</div>';

        $("#issuesDiv").append(newRow);
        $(".selectpicker").selectpicker('refresh');
    }

    function removeDiv(id) {
        $("#div"+id).remove();
    }

    function changeRadio(rps) {
        var rid = $("#select"+rps).val();
        $("."+rps).prop('name', 'sts'+rid);
        $(".consultant"+rps).prop('name', 'consultant'+rid);
        $(".lablconsultant"+rps).prop('for', 'consultant'+rid);

        $(".issue"+rps).prop('name', 'issue'+rid);
        $(".lablissue"+rps).prop('for', 'issue'+rid);

        $(".solution"+rps).prop('name', 'solution'+rid);
        $(".lblsolution"+rps).prop('for', 'solution'+rid);
    }
    
    $("#createForm input").click(function() {
    $("#fcontrol").val(1);
    });
    // Event listener for the  
    // 'beforeunload' event 
    window.addEventListener('beforeunload', function (e) { 
        // Check if any of the input 
        // fields are filled 
        fcontrol = $("#fcontrol").val();
        if (fcontrol != '') { 

            // Cancel the event and 
            // show alert that the unsaved 
            // changes would be lost 
            e.preventDefault(); 
            e.returnValue = ''; 
        } 
    }); 
</script>
@stop