@extends('layouts.default')
@section('title', 'Meeting analytics')
@section('new_button')
<a href="{!! route('meetings.create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> add </i> New Meeting
</a>
<a href="{!! route('meetings.index') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> list </i> My Meeting
</a>
@endsection
<style>
    .table tbody tr td:last-child {
        white-space: nowrap;
    }

    .green {
        color: green !important;
    }

    .red {
        color: red !important;
    }
</style>
@section('content')
<!-- page content -->
<script src="https://cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>
<link rel="stylesheet" type="text/css" href="{{ asset('accounts/css/daterangepicker.css') }}" />

<table
    class="table table-show table-striped table-bordered table-responsive dt-responsive nowrap jambo_table table-filter"
    cellspacing="0" id="abcd">
    <thead>
        <tr>
            <th>Date</th>
            <th>Organised By</th>
            <th>Raised By</th>
            <th>Consultant</th>
            <th>Issue Statement</th>
            <th>Solution Statement</th>
            <th>Resolved ?</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($list as $key=>$issue)
        <tr>
            <td>{{ Date::parse($issue->meeting->date)->format($date_format) }}</td>
            <td>{{ ucfirst($issue->meeting->organiser->name) }}</td>
            <td>{{ ucfirst($issue->user->name) }}</td>
            <td>{{ ucfirst($issue->student) }}</td>
            <td>
                <p title="{{ ucfirst($issue->issue) }}">{{ ucfirst($issue->issue) }}</p>
            </td>
            <td>
                <p title="{{ ucfirst($issue->solution) }}">{{ ucfirst($issue->solution) }}</p>
            </td>
            <td>
                @if($issue->status == 1)
                Yes
                @endif

                @if($issue->status == 2)
                No
                @endif
                
                @if($issue->status == '')
                None 
                @endif

            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@stop