@extends('layouts.campaign')
@section('title','Upload CSV (Only Email Column) for direct unsubscribe')

@section('content')

  <div class="card">    
    <div class="col-sm-12">
      {!! Form::open(['url'=>'campaign_unsubscribes_import', 'files'=>true]) !!}
      <div class="row">
        <div class="col-md-4">
            {{ Form::fileGroup('files', trans('Select File')) }}
        </div>
        <div class="col-md-4">
          {!! Form::submit('Upload', ['class'=>'btn btn-primary btn-Rcircle-iconic waves-effect waves-light', 'onclick'=>'confirm("Are you sure ?")']) !!}
        </div>
      </div>
      {!! Form::close() !!}     
    </div>
  </div>
  <div class="row">
    <div class="col-lg-3 col-md-3">
      <small>Select Filter</small>
      {!! Form::select('typeSelect', ['subscribed'=>'Subscribed', 'unsubscribed'=>'Un Subscribed'], null, ['id'=>'changeSelection', 'class'=>'selectpicker']) !!}
    </div>
    <div class="col-lg-9 col-md-9 text-right">
      <button class="btn btn-sm btn-outline-success action-btn1" id="" type="button" onclick="subscribe()"> <i class="fa fa-trash"></i> Re-Subscribe </button>
      <button class="btn btn-sm btn-outline-danger action-btn1" id="" type="button" onclick="unsubscribe()"> <i class="fa fa-trash"></i> Un-Subscribe </button>
    </div>
  </div>
  <table class="table table-striped table-bordered nowrap dataTable">
    <thead>
      <tr>
        <th>Email</th>
        <th>Reason</th>
        <th>Ip</th>
        <th>Type</th>
        <th>
          <label class="custom-control overflow-checkbox">
            <input type="checkbox" class="overflow-control-input" id="selectAll">
            <span class="overflow-control-indicator"></span> Select All
          </label>
        </th>
      </tr>
    </thead>
    <tbody>
      @foreach($list as $li) 
      @php 
        if($li->type == 0){ 
          $cls = 'unsubscribed all'; 
          $txt = '<span class="badge badge-danger">Un-Sub</span>';
          $ckCls = 'unsub allCk';
        } else { 
          $cls = 'subscribed all'; 
          $txt = '<span class="badge badge-success">Sub</span>'; 
          $ckCls = 'sub allCk';
        } 
      @endphp
      <tr class="{{ $cls }}">
        <td>{{ $li->email }}</td>
        <td>{{ $li->reason }}</td>
        <td>{{ $li->ip }}</td>
        <td>
          {!! $txt !!}
        </td>
        <td>
          <label class="custom-control overflow-checkbox">
            <input type="checkbox" class="overflow-control-input {{ $ckCls }}" value="{{ $li->email }}">
            <span class="overflow-control-indicator"></span>
          </label>
        </td>
      </tr>
      @endforeach
      <tr>
        <td class="text-center" colspan="5">No more data</td>
      </tr>
    </tbody>
  </table>
<script src="{{ asset('js/pages/campaigns/unsubscribed-list.js') }}"></script>
@stop

