@extends('layouts.campaign')

@section('title', 'Edit Template')
@section('new_button')

<a  href="{!! URL::to('/campaign_templates') !!}" class="btn btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">
remove_red_eye
</i> Template List</a>
<a  href="{!! URL::to('/campaign_templates/create') !!}" class="btn ml-3 btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">
add
</i> Create Template</a>
@endsection
@section('content')

<div class="card">
    {!! Form::model($campaignTemplate, ['url' => ['/campaign_templates', $campaignTemplate->id], 'method' => 'PATCH', 'style'=>'width: 100% !important;']) !!}
    <div class="row">
        {!! Form::hidden('template_id', $campaignTemplate->id) !!}
        <div class="form-group">
            <div class="col-sm-12 col-md-12 col-lg-12">
                {!! Form::textGroup('title', 'Title', null, ['required'=>'required']) !!}
            </div>

            <div class="col-sm-12 col-md-12 col-lg-12">
                {!! Form::textareaGroup('content', 'Template Content', null, ['id'=>'template', 'required'=>'required']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-sm-12 col-md-12 col-lg-12">
                {!! Form::submit('UPDATE', ['class'=>'btn btn-primary']) !!}
            </div>
        </div>
    </div>
    {!! Form::close() !!}
</div>

	
<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>

 <script>
   CKEDITOR.replace( 'template' );
 </script>
   
@endsection