@extends('layouts.campaign')
@section('title', 'Email List')
@if(isAdmin())
  @section('new_button')
    <a href="{{ url('/campaign_reports') }}" class="btn btn-primary btn-Rcircle-iconic waves-effect waves-light">Team Reports</a>
  @endsection
@endif
@section('content')

<style>
.red-dot {
    height: 10px;
    width: 10px;
    background-color: red;
    border-radius: 50%;
    display: inline-block;
}
.green-dot {
    height: 10px;
    width: 10px;
    background-color: green;
    border-radius: 50%;
    display: inline-block;
}
.red {
  color: red;
}
.green {
  color: green;
}
.ash-back {
  background-color: #D8D8D9; 
  font-weight: bold;
}
</style>

<div class="card">
  {!! Form::open(['url'=>'/campaign_email_reports', 'method'=>'POST', 'autocomplete'=>'off']) !!}
  <div class="row">
    <div class="col-md-3 form-group">
      <small>Type</small>
      {!! Form::select('state', [''=>'Select Status', 'sent'=>'Email Sent', 'rejected'=>'Email Rejected'], null, ['class'=>'selectpicker', 'required']) !!}
    </div>
    <div class="col-md-3">
      {{ Form::label('From Date') }}
      {!! Form::text('from_date', NULL, ['id'=>'fromdate']) !!}
    </div>
    <div class="col-md-3">
      {{ Form::label('To Date') }}
      {!! Form::text('to_date', NULL, ['id'=>'todate']) !!}
    </div>
    <div class="col-md-3 form-group">
      {!! Form::submit('Filter', ['class'=>'btn btn-sm btn-primary pull-right', 'style'=>"margin-top: 0px;"]) !!}
    </div>
  </div>
  {!! Form::close() !!}
</div>

<table class="table table-hover dt-responsive" id="example" style="font-size: 11px;">
  <thead class="ash-back">
    <tr>
      <th>Status</th>
      <th>Sender</th>
      <th>Email</th>
      <th>Subject</th>
      <th>Opens</th>
      <th>Clicks</th>
      <th>Content</th>
    </tr>
  </thead>
  <tbody>
    @php 
      $new_date = date('Y-m-d'); 
    @endphp 
    @if( is_array($list) && count($list) > 0) 
      @foreach($list as $i => $li) 
        @if(Date::parse($li->ts)->format('Y-m-d') != $new_date) 
          @php 
            $new_date = Date::parse($li->ts)->format($date_format); 
          @endphp
          <tr class="text-center ash-back">
            <td colspan="7">
              <strong>{{ Date::parse($li->ts)->format($date_format) }}</strong>
            </td>
          </tr>
        @endif
          <tr>
            @if($li->state === 'sent')
            <td>
              <span class="green-dot"></span>
              <span class="green">{{ ucfirst($li->state) }} </span>
              <p>{{ Date::parse($li->ts)->format($date_format) }} {{ Date::parse($li->ts)->format('H:i A') }}</p>
            </td>
            @else
            <td>
              <span class="red-dot"></span>
              <span class="red">{{ ucfirst($li->state) }} </span>
              <p>{{ Date::parse($li->ts)->format($date_format) }} {{ Date::parse($li->ts)->format('H:i A') }}</p>
            </td>
            @endif
            <td>{{ $li->sender }}</td>
            <td id="email{{ $i+1 }}">{{ $li->email }}</td>
            <td title="{{ $li->subject }}">{{ str_limit($li->subject, 20) }}</td>
            <td>{{ $li->opens }}</td>
            <td>{{ $li->clicks }}</td>
            <td>
              @if($li->state === 'sent')
              <a href="{{ url('/campaign/mail-view') }}/{{ $li->_id }}" target="_blank" size="{{ $li->_id }}" id="content{{ $i+1 }}">View Content</a> 
              @endif
              <button title="Resend" type="button" class="btn btn-sm" onclick="resendMail({{ $i+1 }})">Resend</button>
            </td>
          </tr>
      @endforeach 
    @else
    <tr class="text-center">
      <td colspan="7" class="text-center">No Data Found</td>
    </tr>
    @endif
  </tbody>
</table>
@include('includes.datepicker')
<script src="{{ asset('js/pages/campaigns/email-list-view.js') }}"></script>
@stop