@extends('layouts.campaign')

@section('title', 'Create List')
@section('new_button')
<a  href="{!! URL::to('/campaign/list') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">
remove_red_eye
</i> View List</a>
@endsection
@section('content')

<div class="card">

	{!! Form::open(['url'=>'/campaign_lists', 'style'=>'width: 100% !important;']) !!}
	<div class="row">
        <div class="col-md-4">
            {!! Form::textGroup('title', 'List Name', NULL, ['required']) !!}		
        </div>
        <div class="col-md-4">
            {!! Form::textGroup('from_name', 'Default From Name', NULL, ['required']) !!}		
        </div>
        <div class="col-md-4">
            {!! Form::textGroup('from_email', 'Default From Email', NULL, ['required']) !!}		
        </div>
        <div class="col-md-4">		
            {!! Form::textGroup('phone', 'Default Phone', NULL, ['onkeydown'=>'return isNumberKey(event)', 'maxlength'=>'12']) !!}
        </div>
        <div class="col-md-4">		
            {!! Form::textGroup('company', 'Company / Organization', NULL, []) !!}
        </div>
        <div class="col-md-4">
            {!! Form::textareaGroup('address', 'Address', NULL, ['class'=>'form-control', 'rows'=>'1']) !!}
        </div>
        <div class="col-md-4">		
            {!! Form::textGroup('city', 'City', NULL, []) !!}
        </div>
        <div class="col-md-4">		
            {!! Form::textGroup('zipcode', 'Zip / Postal Code', NULL, []) !!}
        </div>
    </div>
	<div class="col-md-12">		
		<div class="col-sm-12  text-right">
			{!! Form::submit('CREATE', ['class'=>'btn btn-primary']) !!}
		</div>
	</div>
	{!! Form::close() !!}
</div>
	
 @endsection