@extends('layouts.campaign')
@section('content')
  <div class="row">
      <div class="col-md-3 col-sm-12 col-xs-12">
        <div class="card ">
          <div class="card-body">
            <h4 class="card-title">Total List Groups</h4>
            <p class="card-text">Lists we have.</p>
            <a href="{{ route('campaign_lists.index') }}" class="btn btn-sm btn-primary">{{ number_format($lists) }}</a>
          </div>
        </div>
      </div>
      <div class="col-md-3 col-sm-12 col-xs-12">
        <div class="card ">
          <div class="card-body">
            <h4 class="card-title">Total Templates</h4>
            <p class="card-text">Templates we have.</p>
            <a href="{{ route('campaign_templates.index') }}" class="btn btn-sm btn-primary">{{ number_format($templates) }}</a>
          </div>
        </div>
      </div>
      <div class="col-md-3 col-sm-12 col-xs-12">
        <div class="card ">
          <div class="card-body">
            <h4 class="card-title">Total Campaigns</h4>
            <p class="card-text">Lists we have.</p>
            <a href="{{ route('campaigns.index') }}" class="btn btn-sm btn-primary">{{ number_format($campaigns) }}</a>
          </div>
        </div>
      </div>
      <div class="col-md-3 col-sm-12 col-xs-12">
        <div class="card ">
          <div class="card-body">
            <h4 class="card-title">Subscribers</h4>
            <p class="card-text">Subscribers we have.</p>
            <a href="{{ route('campaign_contacts.index') }}" class="btn btn-sm btn-primary">{{ number_format($subscribers) }}</a>
          </div>
        </div>
      </div>      
  </div>
  <div class="row">
    <div class="card ml-3 col-2 text-center">
      <div class="card-body">
        <div class="width100P d-flex">
          <span class=" icon-MailSent"></span>
          <div class="d-flex flex-column">
            <h4 class="card-title">Mail Sent</h4>
            <span>{{ isset($sender->sent)?number_format($sender->sent):0 }}</span>
          </div>
        </div>
      </div>
    </div>    
    <div class="card ml-3 col-2 text-center">
      <div class="card-body">
        <div class="width100P d-flex">
          <span class=" icon-MailBounce"></span>
          <div class="d-flex flex-column">
            <h4 class="card-title">Mails Bounced</h4>
            <span>{{ (isset($sender->hard_bounces) && isset($sender->soft_bounces))?number_format($sender->hard_bounces + $sender->soft_bounces):0 }}</span>
          </div>
        </div>
      </div>
    </div>    
    <div class="card ml-3 col-2 text-center">
      <div class="card-body">
        <div class="width100P d-flex">
          <span class=" icon-MailReject "></span>
          <div class="d-flex flex-column">
            <h4 class="card-title">Mails Rejects</h4>
            <span>{{ isset($sender->rejects)?number_format($sender->rejects):0 }}</span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="row">
    <div class="col-md-2 text-center pl-0">
      <p><strong>{{ ucwords('Total') }}</strong></p>
      <div class="col-md-6" style="max-width: 100%;">
        <div class="card text-center">
          <div class="card-body">
            <p class="card-title">Sent</p>
            <span class="badge label-primary">{{ isset($sender->sent)?number_format($sender->sent):0 }}</span>
            <p class="card-title">Bounced</p>
            <span class="badge label-primary">{{ (isset($sender->hard_bounces) && isset($sender->soft_bounces))?number_format($sender->hard_bounces + $sender->soft_bounces):0 }}</span>
            <p class="card-title">Rejects</p>
            <span class="badge label-primary">{{ isset($sender->rejects)?number_format($sender->rejects):0 }}</span>
          </div>
        </div>
      </div>
    </div>
    @if(isset($sender->stats))
    @foreach($sender->stats as $key=>$stat)
    <div class="col-md-2 text-center">
      <p><strong>{{ ucwords($key) }}</strong></p>
      <div class="col-md-6" style="max-width: 100%;">
        <div class="card text-center">
          <div class="card-body">
            <p class="card-title">Sent</p>
            <span class="badge label-primary">{{ number_format($stat->sent) }}</span>
            <p class="card-title">Bounced</p>
            <span class="badge label-primary">{{ number_format($stat->hard_bounces + $stat->soft_bounces) }}</span>
            <p class="card-title">Rejects</p>
            <span class="badge label-primary">{{ number_format($stat->rejects) }}</span>
          </div>
        </div>
      </div>  
    </div>
    @endforeach
    @endif     
  </div>
   
    <div class="row">
        <div class="col-lg-12 col-md-12">
         <div class="card">
          <div class='graph-wrapper'>
          <h4 class="text-center">Senders Stats Graph</h4>
          <div class='graph' id='statsGraph'></div>
            </div>
            </div>
        </div>
    </div>
    @include('includes.knowledge')
  <style>
    .morris-hover.morris-default-style{
      position: absolute;
    }
  </style>
  <script>
    $(function() {
      var lineVar = Morris.Line({
        element: 'statsGraph',
        data: [
        { day: 0, sent: 0, rejects: 0, bounces: 0, opens: 0, clicks: 0 },
        ],
        xkey: 'day',
        parseTime: false,
        ykeys: ['sent','rejects', 'bounces', 'opens', 'clicks'],
        labels: ['Sent','Rejects', 'Bounces', 'Opens', 'Clicks'],
      });

      $.ajax({
        url: '/campaign/stats_graph',
        data: 'user_id=',
        success: function(result) {
          var newData = [];
          var num = result['number'];
          for (let index = 1; index <= num; index++) {
            if(result['list'][index]) {
              newData.push({'day':index, 'sent':result['list'][index]['sent'], 'rejects':result['list'][index]['rejects'], 'bounces':result['list'][index]['bounces'], 'opens':result['list'][index]['opens'], 'clicks':result['list'][index]['clicks']});
            } else {
              newData.push({'day': index, 'sent': 0, 'rejects': 0, 'bounces': 0, 'opens': 0, 'clicks': 0});          
            }
          }

          lineVar.setData(newData);
        }
      });
    });
  </script>
@stop