@extends('layouts.campaign') 
@section('title', 'Edit Campaign') 
@section('content')

<div class="card">
    {!! Form::model($campaign, ['url'=>['/campaigns', $campaign->id], 'style'=>'width: 100% !important;', 'autocomplete'=>'off', 'method'=>'PUT']) !!}

    <div class="row">
        <div class="col-md-7">
					{{ Form::textGroup('title', 'Campaign Title', NULL,['required']) }}
				</div>
				<div class="col-lg-7 col-md-7 col-sm-6">
					<small>{!! __('Select List Data') !!}</small>
					{!! Form::select('list_id', [''=>'Select List'] + $titles + [0=>'None of the above'], null, ['class'=>'selectpicker', 'required'=>'required', 'data-live-search'=>'true']) !!}
				</div>
				<div class="col-lg-7 col-md-7 col-sm-6">
					{!! Form::emailGroup('from_add', 'From Email', auth()->user()->email, ['required'=>'required']) !!}
				</div>
				<div class="col-lg-7 col-md-7 col-sm-6">
					{!! Form::textGroup('subject', 'Subject', NULL, ['required'=>'required']) !!}
				</div>
				<div class="col-lg-7 col-md-7 col-sm-6">
					<small>{{ __('Select Template') }}</small>
					{!! Form::select('template_id', [''=>'Select Template'] + $templates + ['new'=>'Create Template'], null, ['class'=>'selectpicker', 'id'=>'template_select', 'required', 'data-live-search'=>'true']) !!}
				</div>

				<div class="col-md-5" id="titleDiv" style="display: none;">
					{!! Form::label('Template Title') !!}
					<p id="templateTitleP"></p>
				</div>

        <div class=" col-md-12" id="new_template_div">
            <div class="form-groupTextArea">
                {!! Form::label('',null,['id'=> 'label_id']) !!} 
                {!! Form::textarea('content', $campaign?->template?->content, ['class'=>'form-ControlTextArea', 'id'=>'content']) !!}
            </div>
        </div>

        <div class="col-md-12" style="display: flex;">
            <div class="col-6">
                <div class="form-group" style="display: none;" id="title_template">
                    <input class="form-control" placeholder="" name="template_title" type="text" id="templateTitle">
                    <label for="template_title" class="form-label">Template Title</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>

            <div class="col-6" id="new_save_template" style="display: none;">

                <label class="custom-control overflow-checkbox pull-right">
							<input type="checkbox" class="overflow-control-input" id="new_save_template_check" name="as_new">
							<span class="overflow-control-indicator"></span><span class="overflow-control-description">Save it as New Template</span>
						</label>
            </div>
        </div>
        <div class="col-md-12 form-group no-margin text-right">
            <button class="btn btn-warning" type="reset">Reset</button>
            <button type="submit" class="btn btn-primary waves-effect waves-light" name="create_campaign" onclick="return confirm('Are you sure?')" value="1">Update</button>
            <button type="submit" class="btn btn-primary waves-effect waves-light" name="create_campaign" onclick="return confirm('Are you sure?')" value="2">Send</button>
        </div>
    </div>
    {!! Form::close() !!}
</div>

	
<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>

<script>
    CKEDITOR.replace( 'content' );

      	$("#template_select").on('change', function() {
      		if($(this).val() != '') {
      			if($(this).val() == 'new') {
		      		$("#new_template_div").show();
		      		$('#label_id').html('New Template');
		      		$('#new_save_template').show();
					$('#new_save_buttons').show();
		      		CKEDITOR.instances.content.setData('');
		      	}else{
		      		$("#new_template_div").show();
		      		$('#new_save_template').hide();
					$('#new_save_buttons').hide();
		      		$.ajax({
	  		      			url: '/campaign/template/'+$(this).val(),
	  		      			dataType: 'html',
	  		      			data: '',
	  		      			success: function(result) {
	  		      				$('#label_id').html('Template');
	  		      				
	  		      				CKEDITOR.instances.content.setData(result);
	  		      			}
	  		      		});
		      	}	
      		}else{
      			$("#new_template_div").show();
      			CKEDITOR.instances.content.setData('');
      		}	      	
      	});


      	$('#new_save_template_check').on('change',function(){
      		if($(this).prop("checked") == true){
      			$('#title_template').show();
      		}else{
      			$('#title_template').hide();
				  $("#titleDiv").hide('fast');
      		}
      	});

		function raiseTitle() {
			var ttle = $("#templateTitle").val();
			$("#titleDiv").show('fast');
			$("#templateTitleP").html(ttle);
		}
</script>

@stop