@extends('layouts.campaign')
@section('title', 'Create Campaign')
@section('new_button')
	<a href="{!! URL::to('/campaigns') !!}" class="btn btn-primary btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">
	remove_red_eye
	</i>View Campaign List</a>
@endsection
@section('content') 

<div class="card">
	{!! Form::open(['url'=>'/campaigns', 'style'=>'width: 100% !important;', 'autocomplete'=>'off']) !!}
		<div class="row">
			<div class="col-md-7">
				<div>
					{{ Form::textGroup('title','Campaign Title', NULL,['required']) }}
				</div>
				<div class="mt-3 mb-3">
					<small>{!! 'Select List Data' !!}</small>
					{!! Form::select('list_id', [''=>'Select List'] + $titles + [0=>'None of the above'], null,
					['class'=>'selectpicker', 'required'=>'required', 'data-live-search'=>'true']) !!}
				</div>
				<div>
					{!! Form::emailGroup('from_add', 'From', auth()->user()->email, ['required'=>'required']) !!}
				</div>
				<div>
					{!! Form::textGroup('subject', 'Subject', NULL, ['required'=>'required']) !!}
				</div>
				<div>
					<small>{{ 'Select Template' }}</small>
					{!! Form::select('template_id', [''=>'Select Template'] + $templates + ['new'=>'Create Template'], null,
					['class'=>'selectpicker', 'id'=>'template_select', 'required', 'data-live-search'=>'true']) !!}
				</div>
				
				<div class="col-md-5" id="titleDiv" style="display: none;">
					{!! Form::label('Template Title') !!}
					<p id="templateTitleP"></p>
				</div>
			</div>
			<div class="col-lg-5 col-md-5">
				<div class="text-center">
					<img src="{{ url('public/acs/custom/images/email.png') }}" />
				</div>
			</div>
			<div class=" col-md-12" id="new_template_div" style="display: none">
				<div class="form-groupTextArea">
					{!! Form::label('',null,['id'=> 'label_id']) !!}
					{!! Form::textarea('content', null, ['class'=>'form-ControlTextArea', 'id'=>'content']) !!}
				</div>
			</div>
			
			<div class="col-md-12" style="display: flex;">
				<div class="col-6">
					<div class="form-group" style="display: none;" id="title_template">
						<input class="form-control" placeholder="" name="template_title" type="text" id="templateTitle"
							onkeypress="raiseTitle()">
						<label for="template_title" class="form-label">Template Title</label>
						<span class="form-controlBrd"></span>
					</div>
				</div>
			
				<div class="col-6" id="new_save_template" style="display: none;">
			
					<label class="custom-control overflow-checkbox pull-right">
						<input type="checkbox" class="overflow-control-input" id="new_save_template_check" name="as_new">
						<span class="overflow-control-indicator"></span><span class="overflow-control-description">Save it as New
							Template</span>
					</label>
				</div>
			</div>
			
			<div class="col-md-7 form-group text-right pt-3">
				<i id="new_save_buttons">
					<button type="submit" class="btn btn-primary waves-effect waves-light"  name="create_campaign" value="2">Save As Draft</button>
					<button type="submit" class="btn btn-primary waves-effect waves-light " name="create_campaign" value="0">Save & Send</button>
				</i>
				<button type="submit" class="btn btn-primary waves-effect waves-light"  name="create_campaign" value="1">Send</button>
			</div>
		</div>
	{!! Form::close() !!}
</div>
	
<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>
{{-- Page Script --}}
<script src="{{ asset('js/pages/campaigns/campaign-create.js') }}"></script>
@stop