{{-- USER ID --}}
{{ Form::hidden('myId', auth()->user()->id, ['id'=>'myId']) }}
{{ Form::hidden('myName', ucwords(auth()->user()->name), ['id'=>'myName']) }}
{{ Form::hidden('myCname', companySelect()[auth()->user()->company_id], ['id'=>'myCname']) }}
<style>
    span.live-icon{
    display: inline-block;
    position: relative;
    top: calc(50% - 5px);
    background-color: red;
    width: 10px;
    height: 10px;
    margin-left: 20px;
    border: 1px solid rgba(black, .1);
    border-radius: 50%;
    z-index: 1;
    &:before{
      content: '';
      display: block;
      position: absolute;
      background-color: rgba(red,.6);
      width: 100%;
      height: 100%;
      border-radius: 50%;
      animation: live 2s ease-in-out infinite;
      z-index: -1;
    }
  }

  @keyframes live {
    0% {
        transform: scale(1,1);
    }
    100% {
        transform: scale(3.5,3.5);
        background-color: rgba(red,0);
    }
    }

    .modal-dialog {
		position: relative !important;
		display: flex !important;
		align-items: center !important;
		justify-content: center !important;
		max-width: 500rem;
		margin: 0 auto;
		height: auto;
		padding: 50px 0 50px 0;
	}
</style>
<div class="container-fluid ex">
    <nav class="navbar navbar-expand-md pt-0 pb-0">
        <span id="slide"><i class="material-icons" onclick="changeSlide()">menu</i></span>
        <a class="navbar-brand" href="{{ url('/home') }}">
            <div class="logobar"><img src="{{ url('theme/images/logobar.png') }}" height="35px;" alt=""/></div>
            <div class="small-logo"><img src="{{ url('theme/images/logo-small.png') }}" height="35px;" alt=""/></div>
        </a>
        <div class="dropdown dropdown-favrite drop-fav-responsive pr-15 width-310">
            <button class="dropbtn waves-effect waves-light"  id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="float-left"><i class="material-icons orangeText"> star</i></span>
                <span class="fvrt-menu float-right ml-2 mt-1"> Quick Access</span>
            </button>

            <div class="dropdown-menu drop-fav" id="favouriteMenu">
                @foreach ($favourites as $slug=>$fav)
                    <div class="fav-item">
                        <a class="dropdown-item"  href="{{ url($slug) }}">{{ $fav }}</a>
                            <span class="pin-active-fav" 
                                id="{{ array_search($slug, $favouriteLinks) }}"                                
                                onclick="favouriteMenuPin('{{ $slug }}', '{{ $fav }}', $(this))">
                            <span class="icon24 unpin" id="unpin"></span>
                        </span>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="searchBox application-search">
            {{ Form::open(['url'=>'/main_search']) }}
            <input name="search_text" class="app-search" type="text" placeholder="Search">
            <button type="submit"> <i class="material-icons">search</i> </button>
            {{ Form::close() }}
        </div>
        <div class="ml-auto MainNavBarContainer" >                
            <ul  class="navbar-nav  MainNavBar">                
                <li class="nav-icon to-do">
                    <a href="#" type="button" class="btn btn_liv0e btn-xs" data-toggle="modal" data-target="#liveData">Live <span class="live-icon"></span></a>
                </li>
                @if(!$appuser->hasRole('student'))               
                <li role="presentation" class="dropdown notify" id="meetingCount">
                    <a href="javascript:;" class=" borderShadowNone dropdown-toggle waves-effect waves-light info-number" data-toggle="dropdown" aria-expanded="false">
                        <i class="material-icons text-blue" style="right:0px;">event</i>
                        <div class="notifiAnim" v-if="meetingCount != 0"></div>
                    </a>
                    <ul id="menu1" class="dropdown-menu list-unstyled msg_list" role="menu">
                        <li>
                        @foreach(myMeetings() as $meeting)
                        <li class="divider"></li>
                        <li class="unread">
                            <a title="View Details" href="{{ url('meetings') }}/{{ $meeting->id }}"
                                class=""> {{ Illuminate\Support\Str::limit($meeting->subject, '10') }}</a>
                        </li>
                        @endforeach
                        </li>
                    </ul>
                </li>
                @endif
                <li class="nav-icon to-do"><i class="material-icons text-blue">check_box</i><span class="icon-desc">TO DO</span></li>
                <li class="nav-icon restore"><i class="material-icons text-blue">restore</i><span class="icon-desc">RECENT</span></li>
                <li class="nav-icon">
                    <div class="dropdown dropdown-default dropdown-profileMenu dropdown-favrite">
                        <a href="javascript:;" class=" waves-effect waves-light user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false" style="padding-left:0px;">
                        <img class="pImage" src="{{ url('theme/images/logo-small.png') }}" type="logo" / alt="">
                        <span class="profileMenuName deskShow" style="top:0px;">{{ ucwords(Auth::User()->name) }}</span>
                        <i class="material-icons">keyboard_arrow_down</i>
                        </a>
                        <div class="text-left">
                        <span class="compny-name">{{ ucwords($my_company) }}</span>
                        </div>
                        <ul class="dropdown-menu drop-fav admn-menu" style="top:32px !important;">
                            <li><span class="profileMenuName ResShow">{{ ucwords(Auth::User()->name).' ('.Auth::User()->roles->first()->display_name.')' }}</span></li>
                            @if(!$appuser->hasRole('student'))
                            <li><a class=" waves-effect waves-light" href="{!!url('profile')!!}"> My Profile <i class="fa fa-user pull-right"></i></a></li>
                            @else
                            <li><a class=" waves-effect waves-light" href="{!! url('studentProfile') !!}/{{ auth()->user()->id }}"> My Profile <i class="fa fa-user pull-right"></i></a>
                            </li>
                            <li><a class=" waves-effect waves-light" href="{!! url('studentProfiles') !!}/{{ auth()->user()->id }}"> New Profile <i class="fa fa-user pull-right"></i></a>
                            </li>
                            @endif
                            @if(!$appuser->hasRole(['opt_recruiter', 'benchsales', 'student', 'vendor', 'client']))
                            <li><a class=" waves-effect waves-light" href="{!!url('configuration')!!}"><i class="fa fa-sign-out pull-right"></i> Configurations </a></li>
                            @endif
                            <li>
                                <a class="waves-effect waves-light" href="{{ route('logout') }}"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        {{ __('Logout') }}
                                    </a>

                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                            </li>
                            
                        </ul>
                    </div>
                </li>                
            </ul>
        </div>

        {{-- Live Data --}}
        <div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" id="liveData">
            <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-6" style="border: 1px solid black;">
                            <h4 class="text-center">OPT Live Analytics</h4>
                            <div id="opt-live-cards">
                                <opt-live-cards :totalopt="totalopt" :totalconsultants="totalconsultants" :totaltraining="totaltraining" :totalmarketing="totalmarketing"></opt-live-cards>
                            </div>
        
                            <div class="row">
                                <div class="col" id="opt-polararea">
                                    <opt-polar-area :labels="labels" :chartdata="chartdata"></opt-polar-area>
                                </div>
        
                                <div class="col" id="opt-bar-charts">
                                    <opt-bar-charts :labels="labels" :cdata="cdata"></opt-bar-charts>
                                </div>
        
                                {{-- <div class="col" id="opt-line-charts">
                                    <opt-line-charts :cdata="cdata" :labels="labels"></opt-line-charts>
                                </div> --}}
                            </div>
                        </div>
                        <div class="col-sm-6" style="border: 1px solid black;">
                            <h4 class="text-center">Benchsales Live Analytics</h4>

                            <div id="bench-live-cards">
                                <bench-live-cards :totalbench="totalbench" :totalinjob="totalinjob" :totalmarketing="totalmarketing" :totalsubmissions="totalsubmissions"></bench-live-cards>
                            </div>
        
                            <div class="row">
                                <div class="col" id="bench-polararea">
                                    <bench-polar-area :labels="labels" :chartdata="chartdata"></bench-polar-area>
                                </div>
        
                                {{-- <div class="col" id="bench-bar-charts">
                                    <bench-bar-charts :labels="labels" :cdata="cdata"></bench-bar-charts>
                                </div> --}}
        
                                <div class="col" id="bench-line-charts">
                                    <bench-line-charts :cdata="cdata" :labels="labels"></bench-line-charts>
                                </div>
                            </div>
                        </div>   
                        <div class="col-sm-6" style="border: 1px solid black;">
                            <h4 class="text-center">Accounts Live Analytics</h4>
                            <div id="accounts-live-cards">
                                <accounts-live-cards :invoices="invoices" :bills="bills" :profit="profit"></accounts-live-cards>
                            </div>

                            <div class="row">        
                                <div class="col" id="accounts-bar-charts">
                                    <accounts-bar-charts :labels="labels" :cdata="cdata"></accounts-bar-charts>
                                </div>

                                <div class="col" id="accounts-polararea">
                                    <accounts-polar-area :labels="labels" :chartdata="chartdata"></accounts-polar-area>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6" style="border: 1px solid black;">
                            <h4 class="text-center">HR Live Analytics</h4>
                            
                        </div>                        
                    </div>
                </div>
            </div>
            </div>	
        </div>
        <div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" id="liveData">
            <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-body">
                    
                </div>
            </div>
            </div>	
        </div>
        {{-- End Live Data --}}
    </nav>
</div>