@extends('layouts.default')
@section('new_button')
<a  href="{!! URL::to('/jobs') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i class="material-icons left"> remove_red_eye </i> Job list </a>
@endsection
@section('content')
<style type="text/css">
	table > tbody > tr > td{
	padding: 5px !important;
	}
	.control-label{
        float:left;
        font-size: 16px;
        font-weight: 800;
    }
	fieldset{
        width:100%;
        margin-top: 1.5rem;
    }
    legend {
        text-decoration: underline;
    }
</style>

<div class="card">
    {{-- Job details --}}
    <fieldset>
        <legend>Job Details</legend>
        <div class="row">
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Title :- </label>
                <div class="vendor-info">{{ ucfirst($job->title) }}</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info">{{ ucwords($job->country?->name) }}</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Experience :- </label>
                <div class="vendor-info">{{ $job->min_experience }}Y - {{ $job->max_experience }}Y</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Payrate :- </label>
                <div class="vendor-info">{{ $job->min_payrate }} - {{ $job->max_payrate }}</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Interview Mode :- </label>
                <div class="vendor-info">
                    {{ config('custom.interview_modes')[$job->interview_mode]}}
                </div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Employment Type :- </label>
                <div class="vendor-info">{{ config('custom.employment_types')[$job->employment_type]}}</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Job Status :- </label>
                <div class="vendor-info">
                    @if($job->status == 0)
                    Open
                    @elseif ($job->status == 1)
                    Closed
                    @elseif ($job->status == 2)
                    Pending
                    @else
                    ...
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label" style="width:145px;">Internal message :- </label>
                <div class="vendor-info">{{ ucfirst($job->internal_message) }}</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label" style="width:145px;">Job Description :- </label>
                <div class="vendor-info" data-toggle="tooltip" title="{{ ucfirst(strip_tags($job->description)) }}">{{ ucfirst(Str::limit(strip_tags($job->description, 20))) }}</div>
            </div>
        </div>
    </fieldset>

    <!-- Vendor Details -->
    <fieldset>
        <legend>Vendor Details</legend>
        @foreach($job->vendor as $vendor)
        <div class="row">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Name :- </label>
                <div class="">{{ ucfirst($vendor->vendor?->name) }}</div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info">{{ $vendor->vendor?->country?->name }}</div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Website :- </label>
                <div class="vendor-info">{{ $vendor->vendor?->website }}</div>
            </div>
        </div>
        @endforeach
    </fieldset>
    
    <!-- Implementer Details -->
    <fieldset>
        <legend>Implementer Details</legend>
        <div class="row">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Name :- </label>
                <div class="vendor-info">{{ ucfirst($job->implementor?->name) }}</div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info">{{ $job->implementor?->country?->name }}</div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Website :- </label>
                <div class="vendor-info">{{ $job->implementor?->website }}</div>
            </div>
        </div>
    </fieldset>
    
    <!-- Client Details -->
    <fieldset>
        <legend>Client Details</legend>
        <div class="row">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Name :- </label>
                <div class="vendor-info">{{ ucfirst($job->client?->name) }}</div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info">{{ $job->client?->country?->name }}</div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Website :- </label>
                <div class="vendor-info">{{ $job->client?->website }}</div>
            </div>
        </div>
    </fieldset>
</div>

{{-- Shared --}}
<h3><b>Shared Profiles</b></h3>
<div class="card">
    <form action="{{ url('/save_scheduled') }}" method="post" id="saveSchedule">
    @csrf
    <table class="table table-striped table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Name</th>
                <th>Mobile</th>
                <th>Email</th>
                <th>Visa Type</th>
                <th>Location Specific</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @if(count($shared) > 0)
                @foreach($shared as $k=>$share)
                <tr>
                    <td>{{ $share->consultant?->name }}</td>
                    <td>{{ $share->consultant?->mobile }}</td>
                    <td>{{ $share->consultant?->email }}</td>
                    <td>{{ $share->consultant?->visa_status }}</td>
                    <td> {{ $share->consultant?->country?->name }} </td>
                    <td>{{ ucwords($share->status) }}</td>
                    <td>
                        <input type="checkbox" name="share_id[]" value="{{ $share->id }}" class="students" id="">
                    </td>
                </tr>
                @endforeach
            @else
            <tr style="text-align:center;">
                <td colspan='10'>No Student(s) Found...</td>
            </tr>
            @endif
        </tbody>
    </table>
    <div class="row" style="margin-top: 10px">
        <div class="btn-group col-md-12">
            <button class="btn btn-primary btn-sm pull-right" type="button" id="" onclick="$('#saveSchedule').submit()" value="1">Mark as scheduled</button>
        </div>
    </div>
    </form>
</div>

{{-- Scheduled --}}
<h3><b>Schedule Interviews</b></h3>
<div class="card">
    <form action="{{ url('/save_attended') }}" method="post">
        <table class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Visa Type</th>
                    <th>Location Specific</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @if(count($scheduled) > 0)
                    @foreach($scheduled as $k=>$schedule)
                    <tr>
                        <td>{{ $schedule->consultant?->name }}</td>
                        <td>{{ $schedule->consultant?->mobile }}</td>
                        <td>{{ $schedule->consultant?->email }}</td>
                        <td>{{ $schedule->consultant?->visa_status }}</td>
                        <td> {{ $schedule->consultant?->country?->name }} </td>
                        <td>{{ ucwords($schedule->status) }}</td>
                        <td>
                            <input type="checkbox" name="share_id[]" value="{{ $schedule->id }}" class="students" id="">
                        </td>
                    </tr>
                    @endforeach
                @else
                <tr style="text-align:center;">
                    <td colspan='10'>No Student(s) Found...</td>
                </tr>
                @endif
            </tbody>
        </table>
        <div class="row">
            <div class="btn-group col-md-12">
                <button class="btn btn-primary btn-sm pull-right" type="submit" name="update_scheduled" id="scheduled" value="update_scheduled">Mark as attended</button>
            </div>
        </div>
        {{ csrf_field() }}
    </form>
</div>

{{-- Attended --}}
<h3><b>Mark as Attended</b></h3>
<div class="card">
    <form action="{{ url('/save_selected') }}" method="post">
        <table class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Visa Type</th>
                    <th>Location Specific</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @if(count($attended) > 0)
                    @foreach($attended as $k=>$attend)
                    <tr>
                        <td>{{ $attend->consultant?->name }}</td>
                        <td>{{ $attend->consultant?->mobile }}</td>
                        <td>{{ $attend->consultant?->email }}</td>
                        <td>{{ $attend->consultant?->visa_status }}</td>
                        <td> {{ $attend->consultant?->country?->name }} </td>
                        <td>{{ ucwords($attend->status) }}</td>
                        <td>
                            <input type="checkbox" name="share_id[]" value="{{ $attend->id }}" class="students" id="">
                        </td>
                    </tr>
                    @endforeach
                @else
                <tr style="text-align:center;">
                    <td colspan='10'>No Student(s) Found...</td>
                </tr>
                @endif
            </tbody>
        </table>
        <div class="row">
            <div class="btn-group col-md-12">
                <button class="btn btn-primary btn-sm pull-right" type="submit" name="update_attended" id="attended">Mark as selected</button>
            </div>
        </div>
        {{ csrf_field() }}
    </form>
</div>

{{-- Selected --}}
<h3><b>Mark as Selected</b></h3>
<div class="card">
    <form action="{{ url('/save_joined') }}" method="post">
        <table class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Visa Type</th>
                    <th>Location Specific</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @if(count($selected) > 0)
                    @foreach($selected as $k=>$select)
                    <tr>
                        <td>{{ $select->consultant?->name }}</td>
                        <td>{{ $select->consultant?->mobile }}</td>
                        <td>{{ $select->consultant?->email }}</td>
                        <td>{{ $select->consultant?->visa_status }}</td>
                        <td> {{ $select->consultant?->country?->name }} </td>
                        <td>{{ ucwords($select->status) }}</td>
                        <td>
                            <input type="checkbox" name="share_id[]" value="{{ $select->id }}" class="students" id="">
                        </td>
                    </tr>
                    @endforeach
                @else
                <tr style="text-align:center;">
                    <td colspan='10'>No Student(s) Found...</td>
                </tr>
                @endif
            </tbody>
        </table>
        <div class="row">
            <div class="btn-group col-md-12">
                <button class="btn btn-primary btn-sm pull-right" type="submit" name="update_selected" id="selected">Mark as joined</button>
            </div>
        </div>
        {{ csrf_field() }}
    </form>
</div>

{{-- Joined --}}
<h3><b>Mark as Joined</b></h3>
<div class="card">
    <table class="table table-striped table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Name</th>
                <th>Mobile</th>
                <th>Email</th>
                <th>Visa Type</th>
                <th>Location Specific</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @if(count($joined) > 0)
                @foreach($joined as $k=>$join)
                <tr>
                    <td>{{ $join->consultant?->name }}</td>
                    <td>{{ $join->consultant?->mobile }}</td>
                    <td>{{ $join->consultant?->email }}</td>
                    <td>{{ $join->consultant?->visa_status }}</td>
                    <td> {{ $join->consultant?->country?->name }} </td>
                    <td>{{ ucwords($join->status) }}</td>
                </tr>
                @endforeach
            @else
            <tr style="text-align:center;">
                <td colspan='10'>No Student(s) Found...</td>
            </tr>
            @endif
        </tbody>
    </table>
    {{ csrf_field() }}
</div>

<script type="text/javascript">
	$(document).ready(function(){
		$('.scheduled_date').datepicker({
			format: 'dd-mm-yyyy',
			todayHighlight: true,
			clearBtn: true
		});
	
		$(".scheduled_date").keypress(function(e){
			e.preventDefault();
		});
	
		$('.attended_date').datepicker({
			format: 'dd-mm-yyyy',
			todayHighlight: true,
			clearBtn: true
		});
	
		$(".attended_date").keypress(function(e){
			e.preventDefault();
		});
	
		$('.selected_date').datepicker({
			format: 'dd-mm-yyyy',
			todayHighlight: true,
			clearBtn: true
		});
	
		$(".selected_date").keypress(function(e){
			e.preventDefault();
		});
	
	});
	function Checkradiobutton(){
		if(document.getElementById('schedule_radio').checked){
			document.getElementById('scheduled_date').disabled=true;
		}
	}
</script>
<script type="text/javascript">
	$(document).ready(function(){
		$('#download_resume').click(function () {
			$(".students").each(function(){
				if($(this).is(':checked')){
					var id = $(this).val();
					//var std_name = $(".students_name").val();
					var editor = '#editor'+id;
					var doc = new jsPDF();
					var specialElementHandlers = {
					    'editor': function (element, renderer) {
					        return true;
					    }
					};
					doc.fromHTML($("#resume_content"+id).val(), 15, 15, {
				        'width': 170,
			          	'elementHandlers': specialElementHandlers
				    });
			    	doc.save('Resume_'+id+'.pdf');
			    	doc = new jsPDF();
				}
	
			});
	
		});
	});
</script>
@stop