@extends('layouts.default')
@section('title','Jobs List')
@section('header-links')
    @include('includes.headers.jobs')
@endsection
@section('new_button')
<div class="searchBox mr-2">
	{!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
	<span class="search-icn"><i class="material-icons">search</i></span>
	<span class="form-controlBrd"></span>
</div>
<a href="{{ url('/jobs/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">add</i>Create job</a>
@endsection
@section('content')
<!-- page content -->
<div class="table-responsive">
	<table class="table table-striped table-filter table-show table-bordered dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
		<thead>
			<tr>
				<th>Title</th>
				<th>Location</th>
				<th>Employment Type</th>
				<th>Experience</th>
				<th>Pay Rate</th>
				<th>Client Name</th>
				<th>Status</th>
				<th>Shared</th>
				<th>Scheduled</th>
				<th>Attended</th>
				<th>Selected</th>
				<th>Joined</th>
				<th>Action</th>
			</tr>
		</thead>
		<tbody>
			@foreach($list as $k=>$li)
			<?php
				if($li->status == 0){
					$status = 'Open';
				}elseif ($li->status == 1) {
					$status = 'Closed';
				}elseif ($li->status == 2) {
					$status = 'Pending';
				}else{
					$status = '';
				}
            ?>
			<tr>
				<td data-toggle="tooltip" title="{{ ucwords($li->title) }}">{{ ucwords(Str::limit($li->title, 15)) }}</td>
				<td>{{ ucwords($li->country?->name) }}</td>
				<td>{{ ucwords(str_replace('_', ' ' , $li->employment_type)) }}</td>
				<td>{{ $li->min_experience }} - {{ $li->max_experience }}</td>
				<td>{{ $li->min_payrate }} - {{ $li->max_payrate }}</td>
				<td>{{ $li->client?->name }}</td>
				<td>{{ $status }}</td>
				<td>{{ $li->shared }}</td>
				<td>{{ $li->scheduled }}</td>
				<td>{{ $li->attended }}</td>
				<td>{{ $li->selected }}</td>
				<td>{{ $li->joined }}</td>
				<td style="white-space: nowrap;">
					<a href="{{ url('jobs/'.$li->id) }}/edit" class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
					<a href="{{ url('jobs/'.$li->id) }}" class="btn btn-outline-info btn-circle-iconic btn34"><i class="material-icons"> remove_red_eye </i></a>
				</td>
			</tr>
			@endforeach
		</tbody>
	</table>
</div>
@stop