@extends('layouts.default')
@section('title', 'Incentive Structures List')
@section('header-links')
    @include('includes.headers.incentives')
@endsection
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
    <a  href="{!! URL::to('/incentive_structures/create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create College"><i class="material-icons left">
add </i>Create Incentive Structure</a>
@endsection
@section('content')
<div class="">
<table class="table table-striped table-show table-bordered table-filter dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
    <thead>
        <tr>          
            <th>Title</th>
            <th>Marketing</th>
            <th>Recurring</th>
            <th>In Job</th>
            <th>Marketing</th>
            <th>Join Bonus</th>
            <th>Recurring</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($list as $k=>$li)
        <tr>
            <td>{{ ucwords($li->title) }}</td>
            <td>{{ number_format($li->marketing) }}</td>
            <td>{{ ($li->marketing_recurr==0)?'No recurring':'Recurring' }}</td>
            <td>{{ number_format($li->in_job) }}</td>
            <td>{{ ($li->in_job_recurr==0)?'No recurring':'Recurring' }}</td>
            <td>{{ number_format($li->job_bonus) }}</td>
            <td>{{ ($li->job_bonus_recurr==0)?'No recurring':'Recurring' }}</td>
            <td>
                <a title="Edit" href="/incentive_structures/{{$li->id}}/edit" class="btn btn-outline-info btn-circle-iconic btn34" title="edit"> <i class="material-icons">create</i></a>
            </td>
        </tr>
        @endforeach

        @if(count($list) == 0)
        <tr>
            <td class="text-center" colspan=5>No data</td>
        </tr>
        @endif
    </tbody>
</table>
</div>
@stop