@extends('layouts.default')
@section('title', 'Incentive Requests List')
@section('header-links')
    @include('includes.headers.incentives')
@endsection
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
    <a  href="{!! URL::to('/create_incentive') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create College"><i class="material-icons left">
add </i>Create Incentive</a>
@endsection
@section('content')
<div class="">
<table class="table table-striped table-show table-bordered table-filter dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
    <thead>
        <tr>          
            <th>User</th>
            <th>Consultant</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        @if(count($list) > 1)
        @foreach($list as $k=>$li)
        <tr>
            <td>{!! $li->user?->name !!}</td>
            <td>{!! $li->consultant?->name !!}</td>
            <td>{!! $incentiveTypes[$li->type] !!}</td>
            <td>{{ number_format($li->amount, 2) }}</td>
            <td>
                {!! Form::select('status', $statuses, $li->status, ['class'=>'selectpicker', 'onchange'=>'statusChange($(this), '.$li->id.')']) !!}
            </td>
        </tr>
        @endforeach
        @else
        <tr>
            <td class="text-center" colspan=5>No data</td>
        </tr>
        @endif
    </tbody>
</table>
</div>

<script>
    function statusChange(el, id) {
        var status = el.val();
        var id = id;

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'post',
            url: '/change_incentive_status',
            data: 'status='+status+'&id='+id,
            success: function(result) {
                if(result == 1) {
                    alert('success');
                } else {
                    alert('Something is wrong');
                }
            }
        })
    }
</script>
@stop