@extends('layouts.default')
@section('title', 'Create Incentive Structure')
@section('header-links')
    @include('includes.headers.incentives')
@endsection
@section('new_button')
	<a  href="{!! URL::to('/incentive_structures') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left"> list
</i>Incentive Structure List</a>
@endsection

@section('content')
<div class="card">
	{!! Form::open(['url'=>'/save_incentive_request', 'id'=>'incentive_structure_form', 'autocomplete'=>'off', 'data-toggle'=>'validator']) !!}
	    <div class="row">
            <div class="col-md-3">
                {!! Form::selectGroup('user_id', 'Select User', $users, null, ['id'=>'userSelect']) !!}
            </div>
            <div class="col-md-3">
                {!! Form::selectGroup('consultant_id', 'Select Consultant', [], null, ['id'=>'consultantSelect']) !!}
            </div>
            <div class="col-md-3">
                {!! Form::selectGroup('type', 'Select Incentive Type', $incentiveTypes, null, ['id'=>'typeSelect']) !!}
            </div>
            <div class="col-md-3">
                {!! Form::numberGroup('amount', 'Amount', null, ['id'=>'amount', 'maxlength'=>'6']) !!}
            </div>
        </div>
        <div class="form-group no-margin text-right">
            <div class="col-md-2 pl-0">
                {!! Form::saveButton('Save') !!}
            </div>
        </div>
	{!! Form::close() !!}
</div>

<script>
    $("#userSelect").on('change', function() {
        var uid = $(this).val();
        $('#consultantSelect').empty().selectpicker('refresh')
        
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/get_user_consultants',
            data: 'uid='+uid,
            success: function(result) {
                $.each(result, function( index, value ) {
                $('#consultantSelect').append($("<option></option>") .attr("value", index) .text(value));
                });
                $('#consultantSelect').selectpicker('refresh');
            }
        });
    });
</script>
@stop