@extends('layouts.default')
@section('title', 'Create Incentive Structure')
@section('header-links')
    @include('includes.headers.incentives')
@endsection
@section('new_button')
	<a  href="{!! URL::to('/incentive_structures') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left"> remove_red_eye
</i>Incentive Structure List</a>
@endsection

@section('content')
<div class="card">
	{!! Form::open(['url'=>'/save_structure_assign', 'id'=>'incentive_structure_form', 'autocomplete'=>'off', 'data-toggle'=>'validator']) !!}
	    <div class="row">
            <div class="col-md-6">
                {!! Form::selectGroup('structure_id', 'Structure', $structures, null, ['id'=>'structureSelect', 'onchange'=>'getStructure($(this))']) !!}
            </div>
            <div class="col-md-6">
                {!! Form::selectGroup('user_id', 'User', $users, null, ['id'=>'userSelect']) !!}
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6 col-md-6" id="structureDiv">

            </div>
            <div class="col-lg-6 col-md-6">

            </div>
        </div>
        <div class="form-group no-margin text-right">
            <div class="col-md-3">
                {!! Form::saveButton('Save') !!}
            </div>
        </div>
	{!! Form::close() !!}
</div>

<script>
    function getStructure(struct) {
        var sid = struct.val();
        $.ajax({
            url: '/get_structure_details/'+sid,
            success: function(result) {
                $('#structureDiv').html(result);
            }
        })
    }
</script>
@stop