@extends('layouts.default')
@section('title','User List')
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>

<a href="{{ url('hr/employees/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light">
	<i class="material-icons left">add </i> 
	Add New
</a> 
@endsection
@section('content')
<link rel="stylesheet" href="{{ asset('css/pages/users/index.css') }}">
<table class="table table-bordered table-filter table-show">
	<thead>
		<tr>
			<th>Name</th>
			<th>Email</th>
			<th>Phone</th>
			<th>Actions</th>
		</tr>
        <tbody>
            @foreach($list as $li)
            <tr>
                <td>{{ ucwords($li->name) }}</td>
                <td>{{ $li->email }}</td>
                <td>{{ $li->mobile }}</td>
                <td style="display:inline-flex;">
                    <a title="Edit" href="{{ url('/users') }}/{{ $li->id }}/edit"
                        class="btn btn-outline-warning btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                    {{ Form::open(['url'=>'user_change_status', 'mehtod'=>'post']) }}
                    {{ Form::hidden('user_id', $li->id) }}
                    @if($li->active == 1)
                    <button class="btn btn-outline-success btn-circle-iconic btn34" title="Deactivate" name="deactivate"
                        value="1" type="submit"><i class="material-icons">check</i></button>
                    @else
                    <button class="btn btn-outline-danger btn-circle-iconic btn34" title="Activate" name="activate"
                        value="1" type="submit"><i class="material-icons">check</i></button>
                    @endif
                    {{ Form::close() }}
                </td>
            </tr>
            @endforeach

            @if(count($list) == 0)
            <tr>
                <td colspan="5" class="text-center">No Data</td>
            </tr>
            @endif
        </tbody>
	</thead>
</table>
@endsection