@extends('layouts.default')
@section('title','In Job Consultants')
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
@endsection
@section('content')
<link rel="stylesheet" href="{{ asset('css/pages/users/index.css') }}">
<table class="table table-show table-striped table-bordered dt-responsive nowrap jambo_table table-filter" cellspacing="0" id="abcd">
    <thead>
        <tr>
            <th>Date</th>
            <th>Name</th>
            <th>Mobile</th>
            <th>Email</th>
            <th>Creater</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($list as $consultant)
            @php
                $techs = '';
                foreach ($consultant->technologies as $value) {
                    $techs = $techs.' '.$technologies[$value->technology_id];
                }
            @endphp
            <tr>
                <td>{{ Date::parse($consultant->created_at)->format(env('APP_DATE'))  }}</td>
                <td>
                    <a href="{{ url('consultants/'.$consultant->id) }}"
                        style="text-decoration: underline;">{{ ucwords($consultant->name) }}</a>
                </td>
                <td>{{ $consultant->mobile }}</td>
                <td>{{ $consultant->email }}</td>
                <td>
                    @if(isset($consultant->creater?->name)) 
                    {{ ucwords($consultant->creater?->name) }}
                    @endif
                </td>
                <td>
                    <button title="Add Comment" class="btn btn-outline-primary btn-xs" type="button"
                            onclick="makeUser({{ $consultant->id }})"> Creat User Logins </button>
                </td>
            </tr>
        @endforeach
        @if(count($list) == 0)
        <tr>
            <td colspan="5" class="text-center">No Data</td>
        </tr>
        @endif
    </tbody>
</table>

<script>
    function makeUser(cid) {
        $.ajax({
            url: 'hr/employees/store',
            type: 'POST',
            succee: function(result) {

            }
        });
    }
</script>
@endsection