@extends('layouts.default')
@section('title', 'Dashboard')

@section('content')
<style>
	.height-overflow {
	height: 300px !important;
	overflow: auto !important;
	}
    .list-group {
	overflow-y: scroll;
	height: 427px;
	}
	.list-grouppersonal {
	overflow-y: scroll;
	/* height: 427px; */
	}
	.card-header .badge {
	position: relative;
	top: -10px;
	}
    .count {
	position: absolute;
	width: 10px;
	height: 20px;
	line-height: 20px;
	color: white;
	font-weight: bold;
	}
	.mapael .mapTooltip {
	position: absolute;
	background-color: #474c4b;
	moz-opacity: 0.70;
	opacity: 0.70;
	filter: alpha(opacity=70);
	border-radius: 10px;
	padding: 10px;
	z-index: 1000;
	max-width: 200px;
	display: none;
	color: #fff;
	}
	.map circle {
	color: black;
	transform-origin: 50% 50%;
	}
</style>

<div class="row clearfix">
    {{-- People --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">{{ number_format($employees) }}</div>
					<p>People</p>
				</div>
			</a>
		</div>
	</div>

    {{-- Company Departments --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">{{ number_format($departments) }}</div>
					<p>Departments</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- App Users --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">{{ number_format($users) }}</div>
					<p>App Users</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Attendance --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Attendance</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Leave --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Leave</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Reports --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Reports</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Settings --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Settings</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Training --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Training</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Documents --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Documents</p>
				</div>
			</a>
		</div>
	</div>
    
    {{-- Performance --}}
	<div class="col-lg-3">
		<div class="card-DboardStats">
			<div class="icon60">
				<span class="icon24 icon-Consultants-Dashboard"></span>
			</div>
			<a class="div10 10total" href="#" onclick="gotoList('all')">
				<div class="card-DboardStats-Count">
					<div class="card-DboardStats-CountNum" id="card1">100</div>
					<p>Performance</p>
				</div>
			</a>
		</div>
	</div>
</div>

{{-- Chats --}}
<div class="row clearfix" id="app">
	<div class="col-lg-4 col-sm-12">
		@include('chat.dashboard_chat')
	</div>
	<div class="col-lg-8 col-md-8 col-sm-12 mb-3">
		@include('chat.personal_chat')
	</div>
</div>

{{-- Weather widgets --}}
<div class="row clearfix">
	<!-- start of weather widget -->
	<div class="col-lg-6 ">
		<div class="col-md-12 col-lg-12 m-0 p-0">
			<div class="col-md-12 col-sm-12 col-xs-12 pl-0" style="height: 315px !important;">
				<a class="weatherwidget-io" href="https://forecast7.com/en/39d77n86d16/new-york/?unit=us"
					data-label_1="NEW YORK" data-label_2="WEATHER" data-theme="original">NEW YORK WEATHER</a>
				<div id="awtd1504522389802" class="aw-widget-36hour" data-locationkey="349727" data-unit="f"
					data-language="en-us" data-useip="false" data-uid="awtd1504522389802" data-editlocation="true"
					style="height: 417px; "></div>
				<script>
					!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src='https://weatherwidget.io/js/widget.min.js';fjs.parentNode.insertBefore(js,fjs);}}(document,'script','weatherwidget-io-js');
				</script>
			</div>
		</div>
		<div class="col-md-12 card mt-3">
			@include('includes.weather-time')
		</div>
		<div class="col-md-12 mt-2 card">
			@include('includes.timezone')
		</div>
	</div>
	{{-- Client & Consultant Location --}}
	<div class="col-lg-6 ">
		<div class="card" style="height: 100%;">
			<div class="row">
				<div class="col-sm-8">
					<h3>States Wise <span id="list_type"> Clients </span> Map</h3>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						{!! Form::select('map_data_type', ['clients'=>'Client', 'consultants' => 'Consultant'],
						'consultants', ['class'=>'selectpicker', 'style'=>'width:100%;','id'=>'map_data_type', 'onchange'=>'mapLoadData($(this).val())']) !!}
						<div class="help-block with-errors"></div>
					</div>
				</div>
			</div>
			<div class="mapcontainer mapcontainer_refresh mt-3">
				<div class="map"><span>Alternative content for the map</span></div>
			</div>
		</div>
	</div>
	<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 ">
		<div class="row">
			<a href="https://www.accuweather.com/en/br/indianopolis/2725881/current-weather/2725881"
				class="aw-widget-legal">
			</a>
			<div id="awtd1504522389802" class="aw-widget-36hour" data-locationkey="2725881" data-unit="f"
				data-language="en-us" data-useip="false" data-uid="awtd1504522389802" data-editlocation="true"
				style="height: 420px;"></div>
			<script type="text/javascript" src="https://oap.accuweather.com/launch.js"></script>
		</div>
	</div>
	<!-- end of weather widget -->
</div>

<!-- New Mail Modal -->
@include('includes.new-mail')
{{-- Ends New Mail --}}

{{-- Add Comment --}}
@include('includes.new-comment')
{{-- Ends Add Comment --}}

{{-- Includes --}}
@include('includes.date-range-script')
@include('includes.morris-graph')
@include('includes.datepicker')

{{-- Call Status --}}
<!-- Button trigger modal -->
<button type="button" class="btn btn-primary hidden" data-toggle="modal" data-target="#callStatusMd" id="statusModalBtn"></button>
  
  <!-- Modal -->
  <div class="modal fade" id="callStatusMd" tabindex="-1" role="dialog" aria-labelledby="callStatusMdTitle" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
	  <div class="modal-content">
		<div class="modal-header">
		  <h5 class="modal-title" id="exampleModalLongTitle">Modal title</h5>
		  <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closeBtn">
			<span aria-hidden="true">&times;</span>
		  </button>
		</div>
		<div class="modal-body">
			{{ Form::textGroup('callback_date', 'Callback Date', '', ['id' => 'callback_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}

			{{ Form::hidden('cl_status', null, ['id'=>'cl_status']) }}
			{{ Form::hidden('lead_id', null, ['id'=>'lead_id']) }}
			{{ Form::hidden('lead_id', null, ['id'=>'selectId']) }}
		</div>
	  </div>
	</div>
  </div>
{{-- Ends Call Status --}}

{{-- MAP --}}
<script src="{{ asset('theme/plugins/map/maph.js') }}"></script>
<script src="{{ asset('theme/plugins/map/us_aea.js') }}"></script>

<script>
	function modifyData(id) {
	    var type = $("#type"+id).val();
	    $(".div"+id).hide();
	    $("."+id+type).show();
	}
	
	// Visa consultants count on change
	    $("#visa_status_1").change(function(){
	        var status = $(this).val();
			var mdate = $("#dataRange").val();
			
			var sts = status.replace('_', ' ').replace(/\b[a-z]/g, function(letter) {
					return letter.toUpperCase();
				});
				
	        if(status!='total'){
	            $(this).parent("span").siblings("a").remove();
	            $.ajax({
	                url: '/visa_consultant_count',
					data: 'status='+status+'&mdates='+mdate,
	                success: function(result){
	                    var getResult = JSON.parse(result);
	                    var count = getResult.count;
	                    var percentage = getResult.percentage;
	                    var color = percentage>0?'green':'red';
	                    var sort = percentage>0?'asc':'desc';
	                    
	                	var content = '<a href="visa_consultant_list/'+status+'"><div class="card-DboardStats-Count"><div class="card-DboardStats-CountNum">'+count+'</div><p>'+sts+'</p></div>';
						
						$("#span").html(content);
	                }
	            });
	        } else {
				var ttl = $("#total_consultants_hidden").val();

				var content = '<a href="consultant_list/all"><div class="card-DboardStats-Count"><div class="card-DboardStats-CountNum">'+ttl+'</div><p>Total Visas</p></div>';

				$("#span").html(content);
			}
	    });
	
	// Graph Function
	    var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
	
	    var chart = Morris.Area({
	        element: 'consultants_graph',
	        resize: true,
	        data: {!! $consultant_graph_count !!},
	        xkey: 'month',
	        ykeys: ['count'],
	        labels: ['Consultants'],
	        lineColors:['#26B99A', '#34495E', '#ACADAC', '#3498DB'],
	        xLabelFormat: function(x){
	            var month = months[x.getMonth()];
	            return month;
	        },
	        dateFormat: function(x){
	            var month = months[new Date(x).getMonth()];
	            return month;
	        },
	    });
	
	    $(".get_graph_data").change(function(){
	        var type = $("#consultants_type").val();
	        var year = $("#consultants_joined_year").val();
	        $.ajax({
	            url: '/consultants_graph',
	            data: 'type='+type+'&year='+year,
	            success: function(result){
	                document.getElementById('consultants_graph').innerHTML = "";
	                Morris.Area({
	                    element: 'consultants_graph',
	                    resize: true,
	                    data: JSON.parse(result),
	                    xkey: 'month',
	                    ykeys: ['count'],
	                    labels: ['Joined Consultants'],
	                    lineColors:['#26B99A', '#34495E', '#ACADAC', '#3498DB'],
	                    xLabelFormat: function(x){
	                        var month = months[x.getMonth()];
	                        return month;
	                    },
	                    dateFormat: function(x){
	                        var month = months[new Date(x).getMonth()];
	                        return month;
	                    },
	                });
	            }
	        });
	    });
	
	// Datapicker
		var today = new Date();
		$('#datepicker1').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#datepicker1').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
			clearBtn: true,
			endDate: today
		});
	
		$('#callback_date').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#callback_date').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
			clearBtn: true,
			endDate: today
		});
	
	// TimePicker
		$('input.timepicker123').timepicker({
			timeFormat: 'HH:mm:ss',
			minTime: '11:45:00', // 11:45:00 AM,
			maxHour: 20,
			maxMinutes: 30,
			startTime: new Date(0,0,0,15,0,0), // 3:00:00 PM - noon
			interval: 15 // 15 minutes
		});
	
	
	// MAP    
		mapLoadData('consultants');

		function mapLoadData(dataType){
			var vectorData =  {"HI" : {text : { content :'HI' }}, "AK" : {text : { content :'AK' }}, "FL" : {text : { content :'FL' }}, "NH" : {text : { content :'NH' }}, "MI" : {text : { content :'MI' }}, "VT" : {text : { content :'VT' }}, "ME" : {text : { content :'ME' }}, "RI" : {text : { content :'RI' }}, "NY" : {text : { content :'NY' }}, "PA" : {text : { content :'PA' }}, "NJ" : {text : { content :'NJ' }}, "DE" : {text : { content :'DE' }}, "MD" : {text : { content :'MD' }}, "VA" : {text : { content :'VA' }}, "WV" : {text : { content :'WV' }}, "OH" : {text : { content :'OH' }}, "IN" : {text : { content :'IN' }}, "IL" : {text : { content :'IL' }}, "CT" : {text : { content :'CT' }}, "WI" : {text : { content :'WI' }}, "NC" : {text : { content :'NC' }}, "DC" : {text : { content :'DC' }}, "MA" : {text : { content :'MA' }}, "TN" : {text : { content :'TN' }}, "AR" : {text : { content :'AR' }}, "MO" : {text : { content :'MO' }}, "GA" : {text : { content :'GA' }}, "SC" : {text : { content :'SC' }}, "KY" : {text : { content :'KY' }}, "AL" : {text : { content :'AL' }}, "LA" : {text : { content :'LA' }}, "MS" : {text : { content :'MS' }}, "IA" : {text : { content :'IA' }}, "MN" : {text : { content :'MN' }}, "OK" : {text : { content :'OK' }}, "TX" : {text : { content :'TX' }}, "NM" : {text : { content :'NM' }}, "KS" : {text : { content :'KS' }}, "NE" : {text : { content :'NE' }}, "SD" : {text : { content :'SD' }}, "ND" : {text : { content :'ND' }}, "WY" : {text : { content :'WY' }}, "MT" : {text : { content :'MT' }}, "CO" : {text : { content :'CO' }}, "ID" : {text : { content :'ID' }}, "UT" : {text : { content :'UT' }}, "AZ" : {text : { content :'AZ' }}, "NV" : {text : { content :'NV' }}, "OR" : {text : { content :'OR' }}, "WA" : {text : { content :'WA' }}, "CA" : {text : { content :'CA' }}, }
			
			if(dataType == 'clients'){
				$('#list_type').html('Clients');
			}else{
				$('#list_type').html('Consultants');
			}
		
			$(".mapcontainer").mapael({
				map: {
					name: "usa_states",
					defaultArea: {					
						attrs: {
							fill: "#ffffff",
							stroke: "#212529",
							"stroke-width": 2
						}
					}
				},
				areas: vectorData,					
			});
		
			$.ajax({
				headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url:'{{ url('vector_map') }}',
				type: 'POST',
				data: 'dataType='+dataType,
				success:function(data){
				var updatedOptions = {'areas': {} , 'plots' : {}};
					$.each(data,function(i,item){
						if(i){
						if(item[0].clients_count != 0 && typeof item[0].clients_count != 'undefined'){
							fillArea = '#0c6dff';
							hrefLink = "{{ url('clientslist_by_map') }}"+'/'+item[0].id;
						}else if(item[0].consultants_count != 0 && typeof item[0].consultants_count != 'undefined'){
							fillArea = '#0c6dff';
							hrefLink = "{{ url('consultants_by_state') }}"+'/'+item[0].id;
						}else if(item[0].implementor_count != 0 && typeof item[0].implementor_count != 'undefined'){
							fillArea = '#0c6dff';
							hrefLink = "{{ url('implementorlist_by_map') }}"+'/'+item[0].id;
						}else{
							fillArea = '#ffffff';
							hrefLink = "#";
						}
						if(typeof item[0].clients_count != 'undefined'){
							updatedOptions.areas[i] = {
								text: { content: "0", attrs: {"font-size": 15} }, 
								tooltip: {
									content: "<span style=\"font-weight:bold;\">"+item[0].name+"<br \/>Clients :"+item[0].clients_count+"<\/span>"
								},
								href: hrefLink,
								attrs: {
								fill: fillArea
								},
							size: 5
							};
						}else if(typeof item[0].implementor_count != 'undefined'){
							updatedOptions.areas[i] = {
								text: { content: "0", attrs: {"font-size": 15} }, 
								tooltip: {
									content: "<span style=\"font-weight:bold;\">"+item[0].name+"<br \/>Implementers :"+item[0].implementor_count+"<\/span>"
								},
								href: hrefLink,
								attrs: {
								fill: fillArea
								},
							size: 5
							};
						}else{
							updatedOptions.areas[i] = {
								text: { content: "0", attrs: {"font-size": 15} }, 
								tooltip: {
									content: "<span style=\"font-weight:bold;\">"+item[0].name+"<br \/>Consultants :"+item[0].consultants_count+"<\/span>"
								},
								href: hrefLink,
								attrs: {
								fill: fillArea
								},
							size: 5
							};
						}
						}
					});
				
					$.each(data,function(i,item){
						if(i){
						if(item[0].clients_count != 0 && typeof item[0].clients_count != 'undefined'){
							var html = $("text[data-id="+i+"]").html();
							var value = html.split("</tspan>",2);
							$("text[data-id="+i+"]").html(value[0] + ' </br>' + '<tspan font-size="1em">' +item[0].clients_count  +'</tspan>'+'</tspan>');
		
						}else if(item[0].consultant_count != 0 && typeof item[0].consultant_count != 'undefined'){
							var html = $("text[data-id="+i+"]").html();
							var value = html.split("</tspan>",2);
		
							$("text[data-id="+i+"]").html(value[0] +  item[0].consultant_count +'</tspan>');
						}else{
							//var html = $("text[data-id="+i+"]").html();
							//$("text[data-id="+i+"]").remove();
						}
						}
					});
					$(".mapcontainer_refresh").trigger('update', [{
						mapOptions: updatedOptions,
						animDuration: 1000
					}]);
					
				},
				error:function(){
		
				}
			});
		}
	
	// Personal Chat
		function sendEmail(e){
			var id = $(e).attr('id');
		if(id){
			$(".emailBtn").prop('disabled', true);
			$.ajax({
				url:'/chatHistory/'+id,
				success:function(e){
					$(".emailBtn").prop('disabled', false);
					$(e).attr('id').hide();
					},error:function(e){
						$(".emailBtn").prop('disabled', false);
					}
				});
			}
		}
	
	
	// Change call status
		function changeCallStatus(lid, ld) {
			var lead_id = lid;
			var status = ld.value;

			$("#lead_id").val(lead_id);
			$("#cl_status").val(status);
			$("#selectId").val(lid);

			if(status == 'call_me_later') {
				$("#statusModalBtn").click();
			} else {
				updatecallstatus();
			}
		}

		$("#callback_date").on('change', function() {
			if(confirm('Click ok to save changes') == true){
				updatecallstatus();
			} else {
				var siid = $("#selectId").val();
				$('#closeBtn').trigger('click');
				$("#cl_status").val('');
				$("#lead_id").val('');
				$("#selectid").val('');
				$("#callback_date").val('');

				$("#select"+siid).val('default').selectpicker("refresh");
				return false;
			}
		})

		function updatecallstatus() {
			var lead_id = $("#lead_id").val();
			var status = $("#cl_status").val();		
			var callback_date = $("#callback_date").val();	
			var siid = $("#selectId").val();	

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: '/update_call',
				data: 'lead_id='+lead_id+'&status='+status+'&callback_date='+callback_date,
				success: function(result) {
					if(result == 1) {
						$("#cl_status").val('');
						$("#lead_id").val('');
						$("#selectid").val('');
						$("#callback_date").val('');

						$("#tr"+siid).remove();
						$('#closeBtn').trigger('click');
					}
				}
			})
		}

	// Card data
		var start = moment().startOf('month');
		var end = moment().endOf('month');

		$(function() {
			function dRange(start,end) {
				$('#dataRange').val(start.format('L') + ' - ' + end.format('L'));
				if(start != 1) {
					getCardData();
				}
			}

			$('#data-range').daterangepicker({
				startDate: start,
				endDate: end,
				ranges: {
					'Today': [moment(), moment()],
					'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
					'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
					'Last 7 Days': [moment().subtract(6, 'days'), moment()],
					'Last 30 Days': [moment().subtract(29, 'days'), moment()],
					'This Month': [moment().startOf('month'), moment().endOf('month')],
					'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
					'This Quarter': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
					'Previous Quarter': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
					'This Year': [moment().startOf('year'), moment().endOf('year')],
					'Previous Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]	
				}
			}, dRange);

			dRange(start, end);
		});
	
	// card function
		function getCardData() {
			var dates = $("#dataRange").val();
			$.ajax({
				url: '/get_card_data',
				data: 'dates='+dates,
				success: function(result) {
					$("#card1").html(result['card1']);
					$("#card2").html(result['card2']);
					$("#card3").html(result['card3']);
					$("#card4").html(result['card4']);
					$("#card5").html(result['card5']);
					$("#card6").html(result['card6']);
					$("#card7").html(result['card7']);
				}
			})
		}
	
	// Loading Call leads
	$(document).ready(function() {
		loadMore1();
		loadMore2();
	})
	function loadMore1() {
		var pageId = $("#load_more1").val();
		var nextPage = +pageId + +1;
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: '/dashboard_call_leads?page='+nextPage,
			success: function(result) {
				if(result != 1) {
					$("#loadMoreDiv1").prepend(result);
					$(".selectpicker").selectpicker('refresh');
					$("#load_more1").val(nextPage);
				} else {
					console.log('No more');
				}
			}
		})
	}

	function loadMore2() {
		var pageId = $("#load_more2").val();
		var nextPage = +pageId + +1;
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: '/dashboard_consultants_lists?page='+nextPage,
			success: function(result) {
				if(result != 1) {
					$("#loadMoreDiv2").prepend(result);
					$(".selectpicker").selectpicker('refresh');
					$("#load_more2").val(nextPage);
				} else {
					console.log('No more');
				}
			}
		})
	}

	function getTimezones() {
		$.ajax({
            headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
            url: '/get_timezone_dates',
            success: function(result) {
                $("#timezoneDiv").html('');
                $("#timezoneDiv").html(result);
            }
        })
	}

	var intervalId = window.setInterval(function(){
		getTimezones();
	}, 60000);
</script>
@stop