@extends('layouts.default')
@section('title', 'Guest House List')
@section('header-links')
    @include('includes.headers.guesthouses')
@endsection
@section('new_button')
    <div class="searchBox mr-2">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!} <span class="search-icn"><i class="material-icons">search</i></span>
        <span class="form-controlBrd"></span>
    </div>
  <a  href="{!! URL::to('/guesthouse/create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Guest House"><i class="material-icons left"> add </i>Create Guest House</a>
@endsection
@section('content')
<div class="row m-0"> 
<table class="table table-striped table-show table-bordered dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0">
  <thead>
    <tr>     
      <th>Guest House Name</th>
      <th>Capacity</th>
      <th>No.of Students</th>
      <th>Location</th>
      <th>Created By</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
      @foreach($list as $li)
      <tr>
         <td>{{ ucwords($li->name) }}</td>
         <td>{{ $li->capacity }}</td>
         <td><a href="{{url('guest_filled_students/'.$li->id)}}">{{ $li->consultant_count }}</a></td>
         <td title="{{ $li->city?->name.', '.$li->state?->name.', '.$li->country?->name }}">
            {{ Str::limit($li->city?->name.', '.$li->state?->name.', '.$li->country?->name, 15) }}
         </td>
         <td>{{ ucwords($li->creater?->name) }}</td>                      
         <td>
          <a title="Edit" href="guesthouse/{{$li->id}}/edit" class="btn btn-outline-info btn-circle-iconic btn34" title="edit"> <i class="material-icons">create</i></a>
         </td>
      </tr>
    @endforeach
    @if(count($list) == 0)
    <tr>
        <td class="text-center" colspan=5>No data</td>
    </tr>
    @endif
  </tbody>
</table>       
</div>
@stop