@extends('layouts.default')
@section('title', 'Create Guest House')
@section('header-links')
    @include('includes.headers.guesthouses')
@endsection
@section('new_button')
	<a  href="{!! URL::to('/guesthouse') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left"> remove_red_eye
</i>Guest House List</a>
@endsection

@section('content')
<div class="card">
	{!! Form::open(['url'=>'/guesthouse', 'id'=>'create_guesthouse_form', 'autocomplete'=>'off', 'data-toggle'=>'validator']) !!}
	    <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-12">
			{!! Form::textGroup('name', 'Guest House Name', null, ['id'=>'name', 'maxlength'=>'100', 'required'=>'required']) !!}
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
			{!! Form::textGroup('capacity', 'Capacity', null, ['id'=>'capacity', 'required'=>'required']) !!}
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
			{!! Form::selectGroup('country_id', 'Country', $countries, null, ['id'=>'country_1', 'data-live-search'=>'true', 'required'=>'required', 'onchange'=>'getStates(1)']) !!}
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
			{!! Form::selectGroup('state_id', 'State', $states, null, ['id'=>'state_1', 'data-live-search'=>'true', 'onchange'=>'getCities(1)']) !!}
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
			{!! Form::selectGroup('city_id', 'City', $cities, null, ['id'=>'city_1', 'data-live-search'=>'true']) !!}
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
			{!! Form::textareaGroup('address', 'Address', null, ['id'=>'address']) !!}
            </div>
		</div>
        <div class="form-group no-margin text-right">
            {!! Form::saveButton('Save') !!}
        </div>
	{!! Form::close() !!}
</div>

@include('includes.country-state-city-script')
@stop