@extends('layouts.default')
@section('title', 'Allocated List')
@section('header-links')
    @include('includes.headers.guesthouses')
@endsection
@section('new_button')
    <div class="searchBox mr-2">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!} <span class="search-icn"><i class="material-icons">search</i></span>
        <span class="form-controlBrd"></span>
    </div>
  <a  href="{!! URL::to('/guesthouse/create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Guest House"><i class="material-icons left"> add </i>Create Guest House</a>
@endsection
@section('content')
<div class="row m-0"> 
<table class="table table-striped table-show table-bordered dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0">
  <thead>
    <tr>     
      <th>Consultant</th>
      <th>Email</th>
      <th>Mobile</th>
      <th>Guest House</th>
      <th>Start - End</th>
      <th>Duration</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
      @foreach($list as $li)
      @php
          $start = ($li->allocated_on != '')?date(env('APP_DATE'), strtotime($li->allocated_on)):'';
          $end = ($li->leaves_on != '')?date(env('APP_DATE'), strtotime($li->leaves_on)):'';

          if($end != '') {
                $duration = dateDifference($li->allocated_on, $li->leaves_on);
          } else {
                $duration = 'Staying';
          }
      @endphp
      <tr>
         <td>{{ ucwords($li->consultant->name) }}</td>
         <td>{{ $li->consultant->email }}</td>
         <td>{{ $li->consultant->mobile }}</td>
         <td>{{ $li->guesthouse->name }}</td>
         <td>{{ $start }} - {{ $end }}</td>
         <td>{{ $duration }}</td>
         <td></td>
      </tr>
    @endforeach
    @if(count($list) == 0)
    <tr>
        <td class="text-center" colspan=5>No data</td>
    </tr>
    @endif
  </tbody>
</table>       
</div>
@stop