@foreach($consultants as $consultant)
@php
    $techs = '';
    foreach ($consultant->technologies as $value) {
        $techs = $techs.' '.$technologies[$value->technology_id];
    }
@endphp
<tr>
    <td>{!! $consultant->created !!}</td>
    <td>
        <a href="{{ url('consultants/'.$consultant->id) }}"
            style="text-decoration: underline;">{{ ucwords($consultant->name) }}</a>
    </td>
    <td>{{ $consultant->mobile }}</td>
    <td>{{ $consultant->email }}</td>
    <td title="{{ $techs }}">
        {{ Str::limit($techs, 15) }}
    </td>
    <td>{{ $visas[$consultant->visa_status] }}</td>
    <td>{{ $statuses[$consultant->status] }}</td>
    <td>@if(isset($consultant->creater->name)) {{ ucwords($consultant->creater->name) }}
        @endif
    </td>
    <td>
        <a title="Edit" href="/consultants/{{$consultant->id}}/edit"
            class="btn btn-outline-info btn-circle-iconic btn34"> <i
            class="material-icons">create</i></a>
        <a title="Send Mail" onclick="get_mail('{{ $consultant->email }}')"
            class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons">
        mail </i></a>
        <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                onclick="addComment({{ $consultant->id }})"> <i class="material-icons"> comment </i></button>
    </td>
</tr>
@endforeach