@extends('layouts.default')
@section('title','Resume Search')
@section('content')
<!-- page content -->
<div class="right_col" role="main">
	<div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="x_panel">
                <div class="x_content">
                    <form id="" class="form-horizontal form-label-left" method="post" action="{{ url('/resume_search') }}" data-toggle="validator" role="form"  autocomplete="off">
                        <div class="card">
                            <div class="row">
                                <div class="col-lg-3 col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="resume_content" name="key_skills" required>
                                        <label class="form-label">Enter Skills<span class="RED-Star">*</span></label>
                                        <span class="form-controlBrd"></span>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-6">
                                    <div class="ln_solid"></div>
                                    <div class="form-group justify-content-start">
                                        <div class="col-md-12 col-sm-12 col-xs-12 text-left position-relative" style="top:5px;">
                                            <button type="submit" name="search" value="1" class="btn btn-primary  waves-effect waves-light" >Search</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{ csrf_field() }}
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12">
        @if($list != null && isset($list))
	    <table class="table table-striped table-bordered dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Skills</th>
                    <th>Resume</th>
                </tr>
            </thead>
            <tbody>
                @foreach($list as $li)
                <tr>
                    <td>{{ $li->consultant->name }}</td>
                    <td>{{ $li->consultant->mobile }}</td>
                    <td>{{ $li->consultant->email }}</td>
                    <td>{{ ucwords($li->skills) }}</td>
                    <td>
                        <a href="{{ url('download_resume') }}/{{ $li->id }}" class="btn btn-primary btn-xs">download</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif
        </div>
    </div>
</div>
@stop