@extends('layouts.default')
@section('title', 'Consultants list')
@section('header-links')
    @include('includes.headers.consultants')
@endsection
@section('new_button')
<style>
    .table tbody tr td:last-child {
        white-space: nowrap;
    }

    .height-overflow {
        height: 300px;
        overflow: auto;
        overflow-y: scroll;
    }
</style>
<div class="searchBox mr-2 ml-35">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm',
    'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{!! route('consultants.create') !!}"
    class="btn btn-info btn-Rcircle-iconic waves-effect waves-light d-flex align-items-center"><i
        class="material-icons"> add </i> Create Consultant</a>

@endsection
@section('dt_picker')
<div class="col-md-3 col-lg-3 col-sm-12 pull-left">
    <div class="btn btn-default btn-sm date-range-pic">  
        <div id="data-range" class="range-padding">
            <i class="material-icons dateRangeIcon" style="font-size:10px;top:0px;"> calendar_today </i>&nbsp;
            <input type="text" class="text-black" id="dataRange" value="{{ isset($list_dates)?$list_dates:'ALL' }}" style="font-size:12px;">
        </div>
    </div>    
</div>
@endsection
@section('content')
<!-- page content -->
<script src="https://cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>
<link rel="stylesheet" type="text/css" href="{{ asset('accounts/css/daterangepicker.css') }}" />

<div class="right_col" role="main">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12" id="ajaxData">
            <table class="table table-show table-striped table-bordered dt-responsive nowrap jambo_table table-filter" cellspacing="0" id="abcd">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Email</th>
                        <th>Technologies</th>
                        <th>Visa Type</th>
                        <th>Status</th>
                        <th>Creater</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($list as $consultant)
                        @php
                            $techs = '';
                            foreach ($consultant->technologies as $value) {
                                $techs = $techs.' '.$technologies[$value->technology_id];
                            }
                        @endphp
                        <tr>
                            <td>{{ Date::parse($consultant->created_at)->format(env('APP_DATE'))  }}</td>
                            <td>
                                <a href="{{ url('consultants/'.$consultant->id) }}"
                                    style="text-decoration: underline;">{{ ucwords($consultant->name) }}</a>
                            </td>
                            <td>{{ $consultant->mobile }}</td>
                            <td>{{ $consultant->email }}</td>
                            <td title="{{ $techs }}">
                                {{ Str::limit($techs, 15) }}
                            </td>
                            <td>{{ ucwords($consultant->visa_status) }}</td>
                            <td>{{ $statuses[$consultant->status] }}</td>
                            <td>
                                @if(isset($consultant->creater?->name)) 
                                {{ ucwords($consultant->creater?->name) }}
                                @endif
                            </td>
                            <td>
                                <a title="Edit" href="/consultants/{{$consultant->id}}/edit"
                                    class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                <a title="Send Mail" onclick="get_mail('{{ $consultant->email }}')"
                                    class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons"> mail </i></a>
                                <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                                        onclick="addComment({{ $consultant->id }})"> <i class="material-icons"> comment </i> </button>
                            </td>
                        </tr>
                    @endforeach
                    @if(count($list) == 0)
                    <tr>
                        <td colspan="7" class="text-center">No Data</td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

@include('includes.new-comment')
@include('includes.new-mail')

{{-- To Add Comment Script --}}
<script src="{{ asset('js/pages/consultants/add-comment.js') }}"></script>

<script src="{{ asset('js/pages/employees/list_employees.js') }}"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script type="text/javascript" src="{{ asset('accounts/js/moment/moment.js') }}"></script>
<script type="text/javascript" src="{{ asset('accounts/js/daterangepicker/daterangepicker.js') }}"></script>

<script>
    var start = moment().startOf('month');
    var end = moment().endOf('month');


    $(function() {
        function dRange(start,end) {
            $('#dataRange').val(start.format('L') + ' - ' + end.format('L'));
            if(start != 1) {
                getStudentList();
            }
        }

        $('#data-range').daterangepicker({
            startDate: 1,
            endDate: 1,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]                
            }
        }, dRange);
    });

    function getStudentList() {
        var dates = $("#dataRange").val();
        $.ajax({
            url: '{{ route('consultants.index') }}',
            data: 'dates='+dates,
            success: function(result) {
                $("#ajaxData").html(result);
            }
        })
    }
    
    /* Send Email */
    function get_mail(id){
        $("#cemail").val(id).addClass('has-value');
        $("#modelBtn").click();
    }

    $("#emailForm").on('submit', function(e) {
      e.preventDefault();

        $.ajax({
            type: 'POST',
            url: '/sendEmailtoConsultant',
            data: $("#emailForm").serialize(),
            success: function(result) {
                document.getElementById("emailForm").reset();
                $(".closeBtn").trigger('click');
            }
        });
    });
    /* Email Ends Here */
</script>
@stop