@extends('layouts.default')
@section('title', 'Import files')
@section('header-links')
    @include('includes.headers.consultants')
@endsection
@section('content')
<div class="card" role="main">
    {{ Form::open(['url'=>'/save_import_consultants', 'method'=>'post', 'enctype'=>'multipart/form-data']) }}
    <div class="row">
        <div class="col-lg-3 col-md-3 col-sm-12">
            {{ Form::label('csv_file', 'Select CSV File') }}
            {{ Form::file('csv_file', null, ['class'=>'form-control', 'required'=>'required']) }}
        </div>
        <div class="col-lg-3 col-md-3 col-sm-12 mt-3">
            <button type="submit" class="btn btn-sm btn-primary">Click To Import files</button>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12 text-right pt-3">
            <a href="{{ url('/save_sample_csv') }}" class="btn btn-default btn-xs">Download sample CSV file</a>
        </div>
    </div>
    {{ Form::close() }}
</div>

<div class="card">
    <h3>Previously imported files list</h3>
    <div class="row" id="dataDiv">
        <table class="table table-show table-striped table-bordered dt-responsive nowrap jambo_table table-filter" cellspacing="0" id="abcd">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>User Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($list as $file)
                    <tr>
                        <td>{{ Date::parse($file->created_at)->format(env('APP_DATE'))  }}</td>
                        <td>{{ $file->user?->name }}</td>
                        <td><a href="{{ url('/save_imported_file') }}/{{ $file->id }}" class="btn btn-default btn-xs">Download</a></td>
                    </tr>
                @endforeach
                @if(count($list) == 0)
                <tr>
                    <td colspan="3" class="text-center">No Data</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@stop