@extends('layouts.default')
@section('title', 'Consultant call list')
<style>
    .height-overflow {
        height: 300px;
        overflow: auto;
        overflow-y: scroll;
    }

    .form-group .form-control + label.form-label
    {
       top: 0px !important;
    }
</style>
@section('new_button')
<div class="sideFormBox">
    <div class="circleContainer">
        <div class="circle">
            <span class="menu btn btn-info btn-Rcircle-iconic waves-effect waves-light"> 
                <i class="material-icons fontSize">add</i>
                <span class="fontSize ">
                   Add lead
                </span>
            </span>
        </div>
        <div class="sideFormContainer">
            <div class="sideForm">
                <div class="sideForm-Head">
                    <h3> <i class="material-icons">call</i> Add lead </h3>
                    <span class="ion-close-round close pointer">
                        <i class="material-icons  waves-effect waves-gray">clear</i>
                    </span>
                </div>
                <form id="create_calllist_form" class="form-horizontal form-label-left" method="POST"
                    action="{{ route('calls.store') }}">
                    <div class="sideForm-Body mb-3">
                        {{ Form::selectGroup('consultant_id', 'Consultant', $consultants, null, ['id'=>'consultant', 'required'=>'required', 'data-live-search'=>'true']) }}
                        
                        {!! Form::emailGroup('email', 'Email', '', ['id'=>'email','disabled'=>'disabled']) !!}

                        {!! Form::textGroup('mobile', 'Mobile', '', ['id'=>'mobile','disabled']) !!}

                        {{ Form::selectGroup('call_status', 'Call Status', $call_statues, null, ['id'=>'call_status', 'required'=>'required']) }}

                        <div id="callmeDiv" class="mt-3">
                            {{ Form::textGroup('callback_date', 'Callback Date', '', ['id' => 'callback_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
                        </div>

                        {!! Form::textareaGroup('comments', 'Comments', '', ['id'=>'', 'required'=>'required']) !!}
                    </div>
                    <div class="sideForm-Foot">
                        <button type="submit" name="create_calllist" value="1"
                            class="btn btn-danger btn-block waves-effect waves-light mb-2">Submit</button>
                        <button type="reset"
                            class="btn btn-outline-secondary btn-block  waves-effect waves-gray">Reset</button>
                    </div>
                    {{ csrf_field()}}
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('content')
<div class="row">   
    <div class="col-md-12 col-sm-12 col-xs-12">        
        <table class="table table-striped table-show table-filter table-bordered dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
            <thead>
                <tr>                            
                    <th>Consultant Name</th>
                    <th>Status</th>
                    <th>Comments</th>
                    <th>Call On</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($list as $call)
                    <tr>
                        <td>{{ ucwords($call->consultant->name) }}</td>
                        <td>{{ ucwords(str_replace('_', ' ', $call->call_status)) }}</td>
                        <td>{{ ucwords($call->comments) }}</td>
                        <td>
                            @if($call->call_status == 'call_me_later')
                            {{ \Carbon\Carbon::parse($call->callback_date)->format(env('APP_DATE')) }}
                            @endif
                        </td>
                        <td>
                            {{-- <a title="Edit" href="calls/{{$call->id}}/edit" class="btn btn-outline-info btn-circle-iconic btn34"> 
                                <i class="material-icons">create</i>
                            </a> --}}
                            <a title="Send Mail" onclick="get_mail('{{ $call->consultant->email }}')"
                                class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons"> mail </i></a>
                            <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                                onclick="addComment({{ $call->consultant->id }})"> <i class="material-icons"> comment </i></button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>           
    </div>
</div>
 
@include('includes.new-comment')
@include('includes.new-mail')

{{-- To Add Comment Script --}}
<script src="{{ asset('js/pages/consultants/add-comment.js') }}"></script>
{{-- Required Page JS Script --}}
@include('includes.datepicker')
<script src="{{ asset('js/pages/consultants/calls.js') }}"></script>

<script>
var today = new Date();
$('#callback_date').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
$('#callback_date').datepicker({
    format: 'yyyy-mm-dd',
    todayHighlight: true,
    clearBtn: true,
    endDate: today
});

function get_mail(id){
    $("#cemail").val(id).addClass('has-value');
    $("#modelBtn").click();
}

$("#emailForm").on('submit', function(e) {
    e.preventDefault();

    $.ajax({
        type: 'POST',
        url: '/sendEmailtoConsultant',
        data: $("#emailForm").serialize(),
        success: function(result) {
            document.getElementById("emailForm").reset();
            $(".closeBtn").trigger('click');
        }
    })
});
</script>
@stop