@extends('layouts.default')
@section('title','Edit consultant call')

@section('content')
<div class="card">
		{{ Form::model($call, ['route'=>['calls.update', $call->id], 'calss'=>'form-horizontal form-label-left', 'id'=>'update_calllist_form', 'method'=>'PUT']) }}
		<div class="row">
            <div class="col-md-4">
                {!! Form::selectGroup('consultant', 'consultant Name', $consultants, $call->consultant_id, ['id'=>'consultant', 'required'=>'required', 'readonly']) !!}
            </div>
            <div class="col-md-4">
                {!! Form::emailGroup('email', 'Email', $call->consultant->email, ['id'=>'email', 'disabled', 'readonly']) !!}
            </div>
            <div class="col-md-4">
                {!! Form::textGroup('mobile', 'Mobile', $call->consultant->mobile, ['id'=>'mobile', 'disabled', 'readonly']) !!}
            </div>
            <div class="col-md-4">
                {!! Form::selectGroup('call_status', 'Call Status', $call_statues, $call->call_status, ['id'=>'call_status', 'required'=>'required']) !!}
            </div>
            <div class="col-md-4" id="call_me_later_div">
                @php
                    if($call->callback_date != '') {
                        $cdate = date('yyyy-mm-dd', strtotime($call->callback_date));
                    } else {
                        $cdate = '';
                    }
                @endphp
                {{ Form::textGroup('callback_date', 'Callback Date', $call->callback_date, ['id' => 'callback_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>
            <div class="col-md-12" id="call_me_later_div">
                {!! Form::textareaGroup('comments', 'Comments', $call->comments, ['id'=>'comments']) !!}
            </div>
		</div>
		<div  class="col-md-6 col-sm-6 col-xs-12 text-right mrg-top-5">
			<button type="reset" class="btn btn-default waves-effect waves-gray mr-3">Reset</button>
			<button type="submit" class="btn btn-primary waves-effect waves-light" name="update_calllist" value="1">Submit</button>
		</div>
	</form>
</div>

<!-- /page content -->
@include('includes.datepicker')
<script type="text/javascript">
$(document).ready(function(){$('#consultant option:not(:selected)').attr('disabled',true);});
$(document).ready(function(){
	$("#consultant").change(function(){
		var consultant_id = $(this).val();
		$("#email").val('');
		$("#mobile").val('');
		if(consultant_id){
			$.ajax({
				url: '<?php echo url('getconsultantDetails')?>/'+consultant_id,
				success: function(result){
					getresult = JSON.parse(result);
					$("#email").val(getresult.email);
					$("#mobile").val(getresult.mobile);
				}
			});
		}
	});
	$("#call_status").change(function(){
		
		if($(this).val()=='call_me_later'){
  			$("#call_me_later_div").show();
  		}else{
  			$("#call_me_later_div").hide();
  		}
  	});

	var today = new Date();
  	$('#callback_date').datepicker({
		format: 'yyyy-mm-dd',
		todayHighlight: true,
		clearBtn: true
	});
});

</script>
@stop