@extends('layouts.default')
@section('title', 'Assign Consultants to Others')
@section('header-links')
    @include('includes.headers.consultants')
@endsection
@section('content')
<div class="card" role="main">
    {{ Form::open(['url'=>'/save_assign_consultants', 'method'=>'post', 'id'=>'assignForm']) }}
    <div class="row">
        <div class="col-lg-3 col-md-3 col-sm-12">
            {{ Form::selectGroup('consultant_ids', 'Consultant', $consultants, null, ['id'=>'consultantSelect', 'multiple', 'required'=>'required']) }}
        </div>
        <div class="col-lg-3 col-md-3 col-sm-12">
            {{ Form::selectGroup('user_id', 'User', $users, null, ['id'=>'userSelect', 'required'=>'required']) }}
        </div>
        <div class="col-lg-3 col-md-3 col-sm-12 mt-4">
            {{ Form::checkbox('check_all_dummy', 1, false, ['id'=>'check_all']) }} All Consultants
        </div>
        <div class="col-lg-3 col-md-3 col-sm-12 mt-3">
            <button type="button" class="btn btn-sm btn-primary" id="saveBtn">Assign Consultants</button>
        </div>
        {{ Form::hidden('check_all', null, ['id'=>'original_check']) }}
    </div>
    {{ Form::close() }}

    <div class="row" id="dataDiv"></div>
</div>

<script>
    $("#consultantSelect").on('change', function() {
        var cids = $("#consultantSelect").val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/get_consultants',
            data: 'cids='+cids,
            success: function(result) {
                $("#dataDiv").html(result);
            }
        });
    });

    $("#saveBtn").on('click', function() {
        if($("#check_all-1").prop('checked') == true){
            $("#original_check").val(1);
        } else {
            $("#original_check").val(0);
        }

        $("#assignForm").submit();
    })
</script>
@stop