<table class="table table-show table-striped table-bordered dt-responsive nowrap jambo_table table-filter" cellspacing="0" id="abcd">
    <thead>
        <tr>
            <th>Date</th>
            <th>Name</th>
            <th>Mobile</th>
            <th>Email</th>
            <th>Visa Type</th>
            <th>Status</th>
            <th>Creater</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($list as $consultant)
            <tr>
                <td>{{ date(env('APP_DATE'), strtotime($consultant->created_at))  }}</td>
                <td>
                    <a href="{{ url('consultants/'.$consultant->id) }}"
                        style="text-decoration: underline;">{{ ucwords($consultant->name) }}</a>
                </td>
                <td>{{ $consultant->mobile }}</td>
                <td>{{ $consultant->email }}</td>
                <td>{{ ucwords($consultant->visa_status) }}</td>
                <td>{{ $statuses[$consultant->status] }}</td>
                <td>
                    @if(isset($consultant->creater?->name)) 
                    {{ ucwords($consultant->creater?->name) }}
                    @endif
                </td>
                <td>
                    <a title="Edit" href="/consultants/{{$consultant->id}}/edit"
                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                    <a title="Send Mail" onclick="get_mail('{{ $consultant->email }}')"
                        class="btn btn-outline-secondary btn-circle-iconic btn34"> <i class="material-icons"> mail </i></a>
                    <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button"
                            onclick="addComment({{ $consultant->id }})"> <i class="material-icons"> comment </i> </button>
                </td>
            </tr>
        @endforeach
        @if(count($list) == 0)
        <tr>
            <td colspan="7" class="text-center">No Data</td>
        </tr>
        @endif
    </tbody>
</table>