@extends('layouts.default')
@section('title', 'Consultants Work Flow')
@section('header-links')
    @include('includes.headers.consultants')
@endsection
<style type="text/css">
	.c-items {
	  position: relative;
	  height: 10em;
	  width: 99%;
	  margin: 2px auto;
	  text-align: left;
	  white-space: nowrap;
	  overflow-x: auto;
	  overflow-y: hidden;
	  vertical-align:middle;
	  display: inline-block !important;
	}
	.c-items div {
	  	display: inline-block;
	  	width: 14em;
	  	height: 7em;
	  	margin: 0.5em;
	  	border: 1px solid brown;
	  	padding: 3px;
	  	white-space: normal;
	  	text-align: center;
		box-shadow: inset 0 -3em 3em rgba(0,0,0,0.1),
					0 0  0 2px rgb(255,255,255),
					0.3em 0.3em 1em rgba(0,0,0,0.3);
	}
	</style>
@section('content')
@foreach($list as $li)
	@if(count($li->ages) > 0)
	<h4>{{ ucwords($li->name) }}</h4>
	<div class="card c-items">
		@foreach($li->ages as $age)
		<div class="item"> 
			<h4>{{ $statuses[$age->status] }} - {{ $li->id }}</h4>
			<h6><small>{{ Date::parse($age->created_at)->format(env('APP_DATE')) }}</small></h6>
			@if($age->status == 'in_job')
			<p>{{ ucwords($age->job?->client?->name) }}</p>
			@else
			<p>--</p>
			@endif			
		</div>
		@endforeach
	</div>
	@endif
@endforeach
@stop