@extends('layouts.default')
@section('title', 'Create College')
@section('header-links')
    @include('includes.headers.colleges')
@endsection
@section('new_button')
<a  href="{!! URL::to('/college') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left"> remove_red_eye </i> College list</a>
@endsection
@section('content')

<div class="card">
    {!! Form::model($college, ['route'=>['college.update', $college->id], 'data-toggle'=>'validator', 'autocomplete'=>'off', 'role'=>'form', 'id'=>'edit_college_form', 'method'=>'PUT']) !!}
      	<div class="row">    	              		
	  		<div class="col-md-3 col-sm-6 col-xs-12">
	            {!! Form::textGroup('name', 'College Name', null, ['id'=>'name', 'required'=>'required']) !!}
	        </div>
	        <div class="col-md-3 col-sm-6 col-xs-12">
	            {!! Form::textGroup('contact_name', 'Contact Name', null, ['id'=>'contact_name', 'required'=>'required']) !!}
	        </div>
	        <div class="col-md-3 col-sm-6 col-xs-12">
	            {!! Form::textGroup('mobile', 'College Mobile', null, ['id'=>'mobile', 'maxlength'=>'14', 'required'=>'required']) !!}
	        </div>
	        <div class="col-md-3 col-sm-6 col-xs-12">
	        	{!! Form::textGroup('email', 'Contact Email *', null, ['id'=>'email', 'maxlength'=>'50', 'required'=>'required']) !!}
	        </div>
	    	<div class="col-md-3 col-sm-6 col-xs-12">
	    		{{ Form::selectGroup('country_id', 'Country', $countries, null, ['id'=>'country_1', 'data-live-search'=>'true', 'onchange'=>'getStates(1)'])}}
	        </div>
	        <div class="col-md-3 col-sm-6 col-xs-12">
	        	{{ Form::selectGroup('state_id', 'State', $states, null, ['id'=>'state_1', 'data-live-search'=>'true', 'onchange'=>'getCities(1)'])}}
            </div>
	    	<div class="col-md-3 col-sm-6 col-xs-12">
	    		{{ Form::selectGroup('city_id', 'City', $cities, $college->city_id, [ 'data-live-search'=>'true','id'=>'city_1'])}}
            </div>	      
	        <div class="col-md-6">
		       	{!! Form::textareaGroup('address', 'Address', null, ['id'=>'address']) !!}
	        </div>            
	        <div class="col-md-6 mrg-top-5">
		        {!! Form::saveButton('Save') !!}
		  	</div>		
	  	</div>
	</form>
</div>
<!-- /page content -->
<script>
    // Get States By Country
    function getStates(id) {
        var country = $("#country_" + id).val();
        $("#state_" + id).empty().selectpicker('refresh');
        $("#city_" + id).empty().selectpicker('refresh');
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/get_states',
            data: 'country_id=' + country,
            success: function(result) {
                $("#state_" + id).append(result);
                $("#state_" + id).selectpicker('refresh');
            }
        });
    }
    
    // Get Citites By State
    function getCities(id) {
        var state = $("#state_" + id).val();
        $("#city_" + id).empty().selectpicker('refresh');
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/get_cities',
            data: 'state_id=' + state,
            success: function(result) {
                $("#city_" + id).append(result);
                $("#city_" + id).selectpicker('refresh');
            }
        });
    }
    </script>
@stop