@extends('layouts.default')
@section('title', $title)
@section('header-links')
    @include('includes.headers.clients')
@endsection
@section('new_button')
<div class="searchBox mr-2">
	{!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
	<span class="search-icn"><i class="material-icons">search</i></span>
	<span class="form-controlBrd"></span>
</div>
<a href="{!! URL::to('/clients/create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">add</i>Create client</a>
@endsection
@section('content')
<table class="table table-striped table-bordered table-filter table-show dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" width="100%">
	<thead>
		<tr>
			<th>Client name</th>
			<th>Email</th>
			<th>Mobile</th>
			<th>Created By</th>
			<th>Created On</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
		@foreach($list as $li)
		<tr>
            <td>{{ $li->name }}</td>
            <td>{{ $li->email }}</td>
            <td>{{ $li->mobile }}</td>
            <td>{{ ucwords($li->creater?->name) }}</td>
            <td>{{ date(env('APP_DATE'), strtotime($li->created_at)) }}</td>
			<td>
				<a href="clients/{{ $li->id }}/edit" class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons"> create </i> </a>
			</td>
		</tr>
		@endforeach
        @if(count($list) == 0)
        <tr>
            <td class="text-center" colspan=6>No data</td>
        </tr>
        @endif
	</tbody>
</table>
@stop