@extends('layouts.default')
@section('title', 'Batch List')
@section('header-links')
    @include('includes.headers.batches')
@endsection
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
	<a  href="{!! URL::to('batch/create') !!}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Batch"><i class="material-icons left">add</i>Create batch</a>
@endsection
@section('content')
<div class="table-responsive">
<table class="table table-show table-striped table-bordered table-filter dt-responsive nowrap datatable-responsive jambo_table" cellspacing="0" >
 	<thead>
        <tr>        
          	<th>Batch ID</th>
			<th>Batch Name</th>
			<th>Technologies</th>
          	<th>Trainers</th>
          	<th>Start Date</th>
          	<th>End Date</th>
          	<th>Status</th>
          	<th>Action</th>
        </tr>
		</thead>
		<tbody>
  	 	@foreach($batches as $batch)
            @php
                $tnames = '';
            @endphp
            @foreach ($batch->btechnologies as $tech)
                @if(array_key_exists($tech->technology_id, $technologies))
                    @php
                        $tnames = ($tnames!='')?($tnames.', '. $technologies[$tech->technology_id]):($tnames.''.$technologies[$tech->technology_id]);
                    @endphp
                @endif
            @endforeach
			<tr>          	
				<td>{{ $batch->batch_id }}</td>
				<td>{{ ucwords($batch->name) }}</td>
				<td title="{{ $tnames }}">
                    {{ Str::limit($tnames, 15) }}
				</td>
				<td>{{ $batch->trainer->name }}</td>
				<td>{{ Date::parse($batch->start_date)->format(env('APP_DATE')) }}</td>
				<td>{{ Date::parse($batch->end_date)->format(env('APP_DATE'))  }}</td>
				<td>{{ $batch->status==1?'Active':'Inactive' }}</td>
				<td> 
					<a title="Edit" class="btn btn-outline-info btn-circle-iconic btn34" href="batch/{{$batch->id}}/edit"><i class="material-icons">create</i></a>
				</td>
			</tr>
		@endforeach
        @if(count($batches) == 0)
        <tr>
            <td class="text-center" colspan=8>No data</td>
        </tr>
        @endif
		</tbody>
</table>   
</div>
@stop