@extends('layouts.default')
@section('title', 'Send agreement to consultant')
@section('header-links')
    @include('includes.headers.agreements')
@endsection
@section('new_button')
<a href="{{ url('/agreements') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i
        class="material-icons left">list</i> Agreements list</a>
@endsection
@section('content')

<!-- page content -->
<div class="card">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <form class="mui-form" id="" action="{{ url('/send_agreement') }}" method="post"
                data-toggle="validator" role="form" autocomplete="off" enctype='multipart/form-data'>
                <div class="row">
                    <div class="col-lg-3 col-md-3 col-sm-12">
                        {!! Form::selectGroup('consultant_id', 'Consultant', $consultants, null, ['id'=>'consultant_id', 'required'=>'required']) !!}
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        {{ Form::emailGroup('email', 'Email', '', ['id'=>'email']) }}
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        {{ Form::textGroup('mobile', 'Mobile', '', ['id'=>'mobile', 'readonly']) }}
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        {{ Form::textGroup('ssn','SSN', '', ['id'=>'ssn', 'readonly']) }}
                    </div>
                    {{-- <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        {{ Form::textGroup('payrate','Payrate', '', ['id'=>'payrate', 'required'=>'required']) }}
                    </div> --}}
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        {{ Form::selectGroup('payrate_type', 'Payrate Type', ['fixed'=>'Fixed', 'percentage'=>'Percentage'], null, ['id'=>'payrate_type', 'title'=>'Payrate type']) }}
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group" style="display: :none;" id="fixed_div">
                        {{ Form::textGroup('fixed_rate','Fixed rate', '', ['id'=>'fixed_rate']) }}
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group" id="percentage_div" style="display:none;">
                        {{ Form::selectGroup('percentage_rate', 'Percentage rate', [1=>'80% - 20%', 2=>'75% - 25%'], null, ['id'=>'percentage_rate']) }}
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12">
                        {!! Form::selectGroup('agreement_id', 'Agreement', $agreements, null, ['id'=>'agreement_id', 'required'=>'required']) !!}
                    </div>
                </div>
                {{ csrf_field() }}
                <!-- Agreement Div -->
                <div id="new_agreement_div_id" style="display: none;"></div>
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12 text-right">
                        <button class="btn btn-default mr-2" type="reset">Reset</button>
                        <button type="submit" id="btn_send_mail" class="btn btn-primary">Send Mail</button>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Consultant</th>
                        <th>Payrate Type</th>
                        <th>Payrate</th>
                        <th>Agreement</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($agreement_list as $item)
                    <tr>
                        <td>{{ $item->consultant->name }}</td>
                        <td>{{ $item->payrate_type }}</td>
                        @if($item->payrate_type == 'fixed')
                        <td>{{ $item->fixed_rate }}</td>
                        @else
                        <td>{{ $item->percentage_rate }}</td>
                        @endif
                        <td>{{ $item->agreement->name }}
                            <a href="/download/{{ $item->agreement->filename }}" class="btn btn34 btn-default btn-circle-iconic waves-effect waves-blue" target="_blank"><span class="icon24 icon-Attachments"></span></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
{{-- CKEDITOR --}}
<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>

<script type="text/javascript">
    $('#consultant_id').change(function() {
		var id = $(this).val();
		$.ajax({
			url: '/consultant_details/'+id,
			success:function(data){
                var obj = jQuery.parseJSON(data);
				$('#email').val(obj.email).addClass('has-value');
				$('#mobile').val(obj.mobile).addClass('has-value');
				$('#ssn').val(obj.ssn).addClass('has-value');
			},
			error:function(data){
				$('#email').val('').addClass('has-value');
				$('#mobile').val('').addClass('has-value');
				$('#ssn').val('').addClass('has-value');
			}
		});
	});

    $('#payrate_type').change(function() {
        var type = $(this).val();
        if(type == 'fixed') {
            $("#fixed_div").show();
            $("#percentage_div").hide();
            $("#percentage_rate").val('');
        } else {
            $("#fixed_div").hide();
            $("#fixed_rate").val('');
            $("#percentage_div").show();
        }
    });
</script>
@stop