@extends('layouts.default')
@section('title', 'Agreement returns list')
@section('header-links')
    @include('includes.headers.agreements')
@endsection
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search ']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
    <a href="{{ url('/agreements/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">add</i> Create New Agreement</a>
@endsection
@section('content')
<div class="table-responsive">
  <table id="example" class="table table-bordered table-filter table-show">
    <thead>
      <tr>
        <th>Consultant</th>
        <th>Agreement File</th>
        <th>System IP</th>
        <th>Sent On</th>
      </tr>
    </thead>
    <tbody>
      @foreach($list as $agreement)
      <tr>
        <td>{{ ucwords($agreement->consultant->name) }}</td>
        <td><a href="public/storage/company_agreements/{{ $agreement->file }}" class="btn btn-xs" target="_blank"><span class="material-icons">
            download
            </span></a></td>
        <td>{{ $agreement->login_ip }}</td>
        <td>{{ isset($agreement->created_at)?date('d-M-Y', strtotime($agreement->created_at)):'--' }}</td>
      </tr>
      @endforeach

      @if (count($list) == 0)
          <tr>
            <td colspan="4" class="text-center">No Data</td>
          </tr>
      @endif
    </tbody>
  </table>
</div>
@stop